/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeId;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.types.semtype.ObjectDefinition;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.ObjectValue;
import io.ballerina.runtime.internal.values.RecursiveValue;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;

public abstract class AbstractObjectValue
implements ObjectValue,
RecursiveValue<ObjectDefinition> {
    private BTypedesc typedesc;
    private final BObjectType objectType;
    private final Type type;
    private SemType shape;
    private final ThreadLocal<ObjectDefinition> readonlyAttachedDefinition = new ThreadLocal();
    private final HashMap<String, Object> nativeData = new HashMap();

    public AbstractObjectValue(Type type) {
        this.type = type;
        this.objectType = (BObjectType)TypeUtils.getImpliedType(type);
    }

    @Override
    public void addNativeData(String key, Object data) {
        this.nativeData.put(key, data);
    }

    @Override
    public Object getNativeData(String key) {
        return this.nativeData.get(key);
    }

    @Override
    public HashMap<String, Object> getNativeData() {
        return this.nativeData;
    }

    @Override
    public long getIntValue(BString fieldName) {
        return (Long)this.get(fieldName);
    }

    @Override
    public double getFloatValue(BString fieldName) {
        return (Double)this.get(fieldName);
    }

    @Override
    public BString getStringValue(BString fieldName) {
        return (BString)this.get(fieldName);
    }

    @Override
    public String stringValue(BLink parent) {
        return "object " + this.objectType.toString();
    }

    @Override
    public String informalStringValue(BLink parent) {
        return this.stringValue(parent);
    }

    @Override
    public String expressionStringValue(BLink parent) {
        if (this.objectType.typeIdSet == null) {
            return "object " + this.hashCode();
        }
        StringJoiner sj = new StringJoiner("&");
        List<TypeId> typeIds = this.objectType.typeIdSet.getIds();
        for (TypeId typeId : typeIds) {
            String pkg = typeId.getPkg().toString();
            if (".".equals(pkg)) {
                sj.add(typeId.getName());
                continue;
            }
            sj.add("{" + pkg + "}" + typeId.getName());
        }
        return "object " + String.valueOf(sj) + " " + this.hashCode();
    }

    @Override
    public boolean getBooleanValue(BString fieldName) {
        return (Boolean)this.get(fieldName);
    }

    public BMap getMapValue(BString fieldName) {
        return (MapValueImpl)this.get(fieldName);
    }

    @Override
    public BObject getObjectValue(BString fieldName) {
        return (BObject)this.get(fieldName);
    }

    @Override
    public BArray getArrayValue(BString fieldName) {
        return (ArrayValue)this.get(fieldName);
    }

    @Override
    public ObjectType getType() {
        return this.objectType;
    }

    @Override
    public Type getOriginalType() {
        return this.type;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public void freezeDirect() {
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        for (Map.Entry<String, Field> field : this.objectType.getFields().entrySet()) {
            if (!SymbolFlags.isFlagOn(field.getValue().getFlags(), 1L)) continue;
            String fieldName = field.getKey();
            sj.add(fieldName + ":" + this.getStringValue(this.get(StringUtils.fromString(fieldName))));
        }
        return sj.toString();
    }

    @Override
    public BTypedesc getTypedesc() {
        if (this.typedesc == null) {
            this.typedesc = new TypedescValueImpl(this.type);
        }
        return this.typedesc;
    }

    private String getStringValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return "\"" + String.valueOf(value) + "\"";
        }
        return value.toString();
    }

    protected void checkFieldUpdate(String fieldName, Object value) {
        if (this.objectType.isReadOnly()) {
            throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.object", "InherentTypeViolation"), ErrorHelper.getErrorDetails(ErrorCodes.INVALID_READONLY_VALUE_UPDATE, new Object[0]));
        }
        Field field = this.objectType.getFields().get(fieldName);
        if (SymbolFlags.isFlagOn(field.getFlags(), 4L)) {
            throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.object", "InvalidUpdate"), ErrorHelper.getErrorDetails(ErrorCodes.OBJECT_INVALID_FINAL_FIELD_UPDATE, fieldName, this.objectType));
        }
        this.checkFieldUpdateType(fieldName, value);
    }

    private void checkFieldUpdateType(String fieldName, Object value) {
        Type fieldType = this.objectType.getFields().get(fieldName).getFieldType();
        if (TypeChecker.checkIsType(value, fieldType)) {
            return;
        }
        throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.object", "InherentTypeViolation"), ErrorHelper.getErrorDetails(ErrorCodes.INVALID_OBJECT_FIELD_VALUE_ERROR, fieldName, fieldType, TypeChecker.getType(value)));
    }

    public final SemType shapeOf() {
        return this.shape;
    }

    public final void cacheShape(SemType semType) {
        this.shape = semType;
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx) {
        TypeWithShape typeWithShape = (TypeWithShape)((Object)this.getType());
        return typeWithShape.inherentTypeOf(cx, ShapeAnalyzer::inherentTypeOf, this);
    }

    @Override
    public ObjectDefinition getReadonlyShapeDefinition() {
        return this.readonlyAttachedDefinition.get();
    }

    @Override
    public void setReadonlyShapeDefinition(ObjectDefinition definition) {
        this.readonlyAttachedDefinition.set(definition);
    }

    @Override
    public void resetReadonlyShapeDefinition() {
        this.readonlyAttachedDefinition.remove();
    }
}

