/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.BalRuntime;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class FPValue
implements BFunctionPointer,
RefValue {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getFunctionType();
    final Type type;
    private BTypedesc typedesc;
    public Function<Object[], Object> function;
    public String name;
    public StrandMetadata metadata;

    public FPValue(Function<Object[], Object> function, Type type, String name, boolean isIsolated) {
        this.function = function;
        this.type = type;
        this.name = name;
        this.metadata = new StrandMetadata(isIsolated, null);
    }

    @Override
    public Object call(Runtime runtime, Object ... t) {
        BalRuntime balRuntime = (BalRuntime)runtime;
        return balRuntime.scheduler.callFP(this, this.metadata, t);
    }

    @Override
    public String stringValue(BLink parent) {
        return "function " + String.valueOf(this.type);
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return this.stringValue(parent);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public void freezeDirect() {
    }

    @Override
    public BTypedesc getTypedesc() {
        if (this.typedesc == null) {
            this.typedesc = new TypedescValueImpl(this.type);
        }
        return this.typedesc;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "";
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx) {
        return Optional.of(SemType.tryInto(cx, this.getType()));
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }
}

