/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.RegExpCharSetRange;
import io.ballerina.runtime.internal.values.RegExpCharacterClass;
import io.ballerina.runtime.internal.values.RegExpCommonValue;
import io.ballerina.runtime.internal.values.RegExpLiteralCharOrEscape;
import java.util.StringJoiner;

public class RegExpCharSet
extends RegExpCommonValue {
    private Object[] charSetAtoms;

    public RegExpCharSet(ArrayValue charSetAtoms) {
        this.charSetAtoms = this.getCharSetAtomsList(charSetAtoms);
    }

    public RegExpCharSet(Object[] charSetAtoms) {
        this.charSetAtoms = charSetAtoms;
    }

    private Object[] getCharSetAtomsList(ArrayValue charSetAtoms) {
        int size = charSetAtoms.size();
        Object[] atoms = new Object[size];
        for (int i = 0; i < size; ++i) {
            Object atom = charSetAtoms.get(i);
            if (atom instanceof BString) {
                BString bString = (BString)atom;
                atoms[i] = bString.getValue();
                continue;
            }
            atoms[i] = atom;
        }
        return atoms;
    }

    public Object[] getCharSetAtoms() {
        return this.charSetAtoms;
    }

    public void setCharSetAtoms(String[] charSetAtoms) {
        this.charSetAtoms = charSetAtoms;
    }

    @Override
    public String stringValue(BLink parent) {
        StringJoiner atoms = new StringJoiner("");
        for (Object atom : this.charSetAtoms) {
            if (atom instanceof RegExpCharSetRange || atom instanceof RegExpCharSet || atom instanceof RegExpLiteralCharOrEscape || atom instanceof RegExpCharacterClass) {
                atoms.add(((BValue)atom).stringValue(parent));
                continue;
            }
            atoms.add((String)atom);
        }
        return atoms.toString();
    }
}

