/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability.tracer;

import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.runtime.observability.metrics.Tag;
import io.ballerina.runtime.observability.tracer.BSpan;
import io.opentelemetry.api.trace.StatusCode;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public final class TracingUtils {
    private TracingUtils() {
    }

    public static void startObservation(ObserverContext observerContext, boolean isClient) {
        BSpan span;
        String serviceName = observerContext.getServiceName();
        String operationName = observerContext.getOperationName();
        if (observerContext.getParent() != null) {
            BSpan parentSpan = observerContext.getParent().getSpan();
            span = BSpan.start(parentSpan, serviceName, operationName, isClient);
        } else {
            Map httpHeaders = (Map)observerContext.getProperty("_trace_properties_");
            span = httpHeaders != null ? BSpan.start(httpHeaders, serviceName, operationName, isClient) : BSpan.start(serviceName, operationName, isClient);
        }
        if (isClient) {
            observerContext.addProperty("_trace_properties_", span.extractContextAsHttpHeaders());
        }
        observerContext.setSpan(span);
    }

    public static void stopObservation(ObserverContext observerContext) {
        BSpan span = observerContext.getSpan();
        if (span != null) {
            ErrorValue bError = (ErrorValue)observerContext.getProperty("_ballerina_error_value_");
            if (bError != null) {
                span.addTag("error.message", bError.getPrintableStackTrace());
                span.setStatus(StatusCode.ERROR);
            } else {
                span.setStatus(StatusCode.OK);
            }
            Integer statusCode = (Integer)observerContext.getProperty("_http_status_code_");
            if (statusCode != null && statusCode >= 100) {
                span.addTags(Collections.singletonMap("http.status_code", Integer.toString(statusCode)));
            }
            Map<String, String> traceTags = observerContext.getAllTags().stream().collect(Collectors.toMap(Tag::getKey, Tag::getValue));
            span.addTags(traceTags);
            span.finishSpan();
        }
    }
}

