/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.service;

import io.ballerina.shell.service.BalShellGetResultRequest;
import io.ballerina.shell.service.BalShellGetResultResponse;
import io.ballerina.shell.service.DeleteRequest;
import io.ballerina.shell.service.ShellFileSourceResponse;
import io.ballerina.shell.service.ShellWrapper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;

@JsonSegment(value="balShell")
public class BalShellService
implements ExtendedLanguageServerService {
    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    @JsonRequest
    public CompletableFuture<BalShellGetResultResponse> getResult(BalShellGetResultRequest request) {
        return CompletableFuture.supplyAsync(() -> ShellWrapper.getInstance().getResult(request.getSource()));
    }

    @JsonRequest
    public CompletableFuture<ShellFileSourceResponse> getShellFileSource() {
        return CompletableFuture.supplyAsync(() -> ShellWrapper.getInstance().getShellFileSource());
    }

    @JsonRequest
    public CompletableFuture<List<Map<String, String>>> getVariableValues() {
        return CompletableFuture.supplyAsync(() -> ShellWrapper.getInstance().getAvailableVariables());
    }

    @JsonRequest
    public CompletableFuture<Boolean> deleteDeclarations(DeleteRequest request) {
        return CompletableFuture.supplyAsync(() -> ShellWrapper.getInstance().deleteDeclarations(request.getVarToDelete()));
    }

    @JsonRequest
    public CompletableFuture<Boolean> restartNotebook() {
        return CompletableFuture.supplyAsync(() -> ShellWrapper.getInstance().restart());
    }

    public String getName() {
        return "balShell";
    }
}

