/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.service.util;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static String getMimeTypeFromName(Type type) {
        return switch (type.getTag()) {
            case 15, 24, 27, 32, 44 -> "ballerina-notebook/json-view";
            case 17 -> "ballerina-notebook/table-view";
            case 16, 18, 19, 20, 21 -> "ballerina-notebook/xml-view";
            default -> "plain/text";
        };
    }

    public static String convertToJsonIfAcceptable(Object value) {
        Type type = io.ballerina.runtime.api.utils.TypeUtils.getType(value);
        return switch (type.getTag()) {
            case 15, 17, 24, 27, 32, 44 -> StringUtils.getJsonString(value);
            case 16, 18, 19, 20, 21, 47 -> StringUtils.getStringValue(value);
            default -> StringUtils.getExpressionStringValue(value);
        };
    }
}

