/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.centralconnector;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.centralconnector.response.ConnectorResponse;
import io.ballerina.centralconnector.response.ConnectorsResponse;
import io.ballerina.centralconnector.response.PackageResponse;
import io.ballerina.centralconnector.response.SymbolResponse;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.Settings;
import io.ballerina.projects.internal.model.Central;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.util.ProjectUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.wso2.ballerinalang.util.RepoUtils;

class RestClient {
    private static final String BASE_URL = "https://api.central.ballerina.io/2.0/registry/";
    private static final String SEARCH_SYMBOLS = "search-symbols";
    private static final String SEARCH_PACKAGES = "search-packages";
    private static final String CONNECTOR = "connector";
    private final Gson gson = new Gson();
    private final CentralAPIClient centralClient;
    private static final String supportedPlatform = Arrays.stream(JvmTarget.values()).map(JvmTarget::code).collect(Collectors.joining(","));

    public RestClient() {
        Settings settings = RepoUtils.readSettings();
        Central central = settings.getCentral();
        Proxy proxy = settings.getProxy();
        this.centralClient = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)proxy), proxy.username(), proxy.password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), central.getConnectTimeout(), central.getReadTimeout(), central.getWriteTimeout(), central.getCallTimeout(), central.getMaxRetries());
    }

    public ConnectorsResponse connectors(Map<String, String> queryMap) {
        JsonElement connectorSearchResult;
        try {
            connectorSearchResult = this.centralClient.getConnectors(queryMap, "any", RepoUtils.getBallerinaVersion());
        }
        catch (CentralClientException e) {
            throw new RuntimeException(e);
        }
        return (ConnectorsResponse)this.gson.fromJson(connectorSearchResult.getAsString(), ConnectorsResponse.class);
    }

    public ConnectorResponse connector(String id) {
        JsonObject connectorSearchResult;
        try {
            connectorSearchResult = this.centralClient.getConnector(id, "any", RepoUtils.getBallerinaVersion());
        }
        catch (CentralClientException e) {
            throw new RuntimeException(e);
        }
        return (ConnectorResponse)this.gson.fromJson((JsonElement)connectorSearchResult, ConnectorResponse.class);
    }

    public ConnectorResponse connector(String org, String module, String version, String connector) {
        String path = String.format("%s/connectors/%s/%s/%s/%s/%s", BASE_URL, org, module, version, module, connector);
        String response = this.query(path);
        return (ConnectorResponse)this.gson.fromJson(response, ConnectorResponse.class);
    }

    public PackageResponse searchPackages(Map<String, String> queryMap) {
        String queryMapString = this.getQueryMapString(queryMap);
        String response = this.query(SEARCH_PACKAGES, queryMapString);
        return (PackageResponse)this.gson.fromJson(response, PackageResponse.class);
    }

    public SymbolResponse searchSymbols(Map<String, String> queryMap) {
        String queryMapString = this.getQueryMapString(queryMap);
        String response = this.query(SEARCH_SYMBOLS, queryMapString);
        return (SymbolResponse)this.gson.fromJson(response, SymbolResponse.class);
    }

    public String latestPackageVersion(String org, String name) {
        try {
            List packageVersions = this.centralClient.getPackageVersions(org, name, supportedPlatform, RepoUtils.getBallerinaVersion());
            if (packageVersions.isEmpty()) {
                throw new RuntimeException("No versions found for the package");
            }
            String latestVersion = (String)packageVersions.getFirst();
            for (String version : packageVersions) {
                if (!SemanticVersion.from((String)version).greaterThan(SemanticVersion.from((String)latestVersion))) continue;
                latestVersion = version;
            }
            return latestVersion;
        }
        catch (CentralClientException e) {
            throw new RuntimeException("Package versions cannot be pulled: " + e.getMessage(), e);
        }
    }

    private String getQueryMapString(Map<String, String> queryMap) {
        StringBuilder queryParams = new StringBuilder();
        for (Map.Entry<String, String> entry : queryMap.entrySet()) {
            if (!queryParams.isEmpty()) {
                queryParams.append("&");
            }
            queryParams.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
        }
        return queryParams.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String query(String api) {
        HttpURLConnection conn = null;
        try {
            String string;
            URL url = new URL(api);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) throw new RuntimeException("GET request not worked");
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            try {
                String inputLine;
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                string = response.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private String query(String api, String queryMap) {
        String fullUrl = String.format("%s/%s?%s", BASE_URL, api, queryMap);
        return this.query(fullUrl);
    }
}

