/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.ballerinalang.langserver.commons.registration.BallerinaClientCapability;
import org.ballerinalang.langserver.commons.registration.BallerinaClientCapabilitySetter;

public final class ExtendedClientCapabilityBuilder {
    private static List<BallerinaClientCapabilitySetter<? extends BallerinaClientCapability>> capabilitySetters;

    private ExtendedClientCapabilityBuilder() {
    }

    public static List<BallerinaClientCapability> get(List<Object> configs) {
        if (capabilitySetters == null) {
            capabilitySetters = new ArrayList<BallerinaClientCapabilitySetter<? extends BallerinaClientCapability>>();
            ServiceLoader<BallerinaClientCapabilitySetter> loader = ServiceLoader.load(BallerinaClientCapabilitySetter.class);
            for (BallerinaClientCapabilitySetter capabilitySetter : loader) {
                capabilitySetters.add((BallerinaClientCapabilitySetter<? extends BallerinaClientCapability>)capabilitySetter);
            }
        }
        ArrayList<BallerinaClientCapability> clientCapabilities = new ArrayList<BallerinaClientCapability>();
        for (Object config : configs) {
            if (!(config instanceof JsonObject)) continue;
            JsonObject jConfig = (JsonObject)config;
            String capabilityName = jConfig.get("name").getAsString();
            Optional<BallerinaClientCapabilitySetter> setter = capabilitySetters.stream().filter(s -> s.getCapabilityName().equals(capabilityName)).findFirst();
            if (setter.isEmpty()) continue;
            setter.get().build(jConfig).ifPresent(clientCapabilities::add);
        }
        return clientCapabilities;
    }
}

