/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.ballerinalang.langserver.commons.LSOperation;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.config.LSClientConfig;
import org.ballerinalang.langserver.config.LSClientConfigHolder;
import org.ballerinalang.langserver.telemetry.LSErrorTelemetryEvent;
import org.ballerinalang.langserver.telemetry.LSTelemetryEvent;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageClient;

public class LSClientLogger {
    private LanguageClient languageClient;
    private boolean isInitializedOnce;
    private LSClientConfigHolder configHolder;
    private static final LanguageServerContext.Key<LSClientLogger> CLIENT_LOGGER_KEY = new LanguageServerContext.Key();

    public static LSClientLogger getInstance(LanguageServerContext serverContext) {
        LSClientLogger lsClientLogger = (LSClientLogger)serverContext.get(CLIENT_LOGGER_KEY);
        if (lsClientLogger == null) {
            lsClientLogger = new LSClientLogger(serverContext);
        }
        return lsClientLogger;
    }

    private LSClientLogger(LanguageServerContext serverContext) {
        serverContext.put(CLIENT_LOGGER_KEY, (Object)this);
    }

    public void initialize(LanguageClient languageClient, LanguageServerContext serverContext) {
        this.languageClient = languageClient;
        this.isInitializedOnce = true;
        this.configHolder = LSClientConfigHolder.getInstance(serverContext);
    }

    public void notifyUser(String operation, Throwable error) {
        if (!this.isInitializedOnce) {
            return;
        }
        if (this.languageClient != null) {
            this.languageClient.showMessage(new MessageParams(MessageType.Error, operation + " failed, " + error.getMessage()));
        }
    }

    public void notifyClient(MessageType messageType, String message) {
        if (!this.isInitializedOnce) {
            return;
        }
        this.languageClient.showMessage(new MessageParams(messageType, message));
    }

    public void logError(LSOperation operation, String message, Throwable error, TextDocumentIdentifier identifier, Position ... pos) {
        if (!this.isInitializedOnce || this.languageClient == null) {
            return;
        }
        LSClientConfig config = this.configHolder.getConfig();
        if (config.isEnableTelemetry()) {
            this.languageClient.telemetryEvent((Object)LSErrorTelemetryEvent.from(operation, message, error));
        }
        String details = LSClientLogger.getErrorDetails(identifier, error, pos);
        if (config.isDebugLogEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8);
            error.printStackTrace(ps);
            this.languageClient.logMessage(new MessageParams(MessageType.Error, message + " " + details + "\n" + String.valueOf(baos)));
        }
    }

    public void logTrace(String message) {
        if (!this.isInitializedOnce) {
            return;
        }
        if (this.configHolder.getConfig().isTraceLogEnabled() && this.languageClient != null) {
            this.languageClient.logMessage(new MessageParams(MessageType.Info, message));
        }
    }

    public void logWarning(String message) {
        if (!this.isInitializedOnce) {
            return;
        }
        if (this.configHolder.getConfig().isTraceLogEnabled() && this.languageClient != null) {
            this.languageClient.logMessage(new MessageParams(MessageType.Warning, message));
        }
    }

    public void logMessage(String message) {
        if (!this.isInitializedOnce) {
            return;
        }
        if (this.languageClient != null) {
            this.languageClient.logMessage(new MessageParams(MessageType.Log, message));
        }
    }

    public void telemetryEvent(LSTelemetryEvent event) {
        if (!this.isInitializedOnce || this.languageClient == null) {
            return;
        }
        if (this.configHolder.getConfig().isEnableTelemetry()) {
            this.languageClient.telemetryEvent((Object)event);
        }
    }

    private static String getErrorDetails(TextDocumentIdentifier identifier, Throwable error, Position ... position) {
        String msg = error.getMessage();
        StringBuilder result = new StringBuilder("{");
        if (identifier != null) {
            result.append("uri: '").append(identifier.getUri().replaceFirst("file://", "")).append("'");
        }
        if (position != null && position.length > 0 && position[0] != null) {
            if (position.length == 2) {
                result.append(", [").append(position[0].getLine() + 1).append(":").append(position[0].getCharacter() + 1).append("]");
                result.append("- [").append(position[1].getLine() + 1).append(":").append(position[1].getCharacter() + 1).append("]");
            } else {
                result.append(", [").append(position[0].getLine() + 1).append(":").append(position[0].getCharacter() + 1).append("]");
            }
        }
        if (msg != null && !msg.isEmpty()) {
            result.append(", error: '").append(msg);
        } else {
            result.append(", error: '").append(error.toString());
            for (StackTraceElement elm : error.getStackTrace()) {
                if (!elm.getClassName().startsWith("org.wso2.")) continue;
                result.append(", ").append(elm.toString());
                break;
            }
        }
        result.append("'}");
        return result.toString();
    }
}

