/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.Project;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.EnvironmentBuilder;
import io.ballerina.projects.environment.PackageRepository;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.internal.environment.BallerinaDistribution;
import io.ballerina.projects.internal.environment.BallerinaUserHome;
import io.ballerina.projects.internal.repositories.BallerinaDistributionRepository;
import io.ballerina.projects.internal.repositories.RemotePackageRepository;
import io.ballerina.projects.util.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.CentralPackageDescriptorLoader;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.codeaction.CodeActionModuleId;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.completions.providers.context.util.ServiceTemplateGenerator;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkDoneProgressEnd;
import org.eclipse.lsp4j.WorkDoneProgressReport;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.util.Names;

public class LSPackageLoader {
    public static final LanguageServerContext.Key<LSPackageLoader> LS_PACKAGE_LOADER_KEY = new LanguageServerContext.Key();
    private final List<ModuleInfo> distRepoPackages = new ArrayList<ModuleInfo>();
    private final List<ModuleInfo> remoteRepoPackages = new ArrayList<ModuleInfo>();
    private final List<ModuleInfo> localRepoPackages = new ArrayList<ModuleInfo>();
    private final List<ModuleInfo> centralPackages = new ArrayList<ModuleInfo>();
    private final LSClientLogger clientLogger;
    ExtendedLanguageClient languageClient;
    private String notificationTaskId;
    private boolean initialized = false;
    private final CentralPackageDescriptorLoader centralPackageDescriptorLoader;

    public static LSPackageLoader getInstance(LanguageServerContext context) {
        LSPackageLoader lsPackageLoader = (LSPackageLoader)context.get(LS_PACKAGE_LOADER_KEY);
        if (lsPackageLoader == null) {
            lsPackageLoader = new LSPackageLoader(context);
        }
        return lsPackageLoader;
    }

    private LSPackageLoader(LanguageServerContext context) {
        this.clientLogger = LSClientLogger.getInstance(context);
        this.centralPackageDescriptorLoader = CentralPackageDescriptorLoader.getInstance(context);
        context.put(LS_PACKAGE_LOADER_KEY, (Object)this);
    }

    public boolean isInitialized() {
        return Boolean.TRUE.equals(this.initialized);
    }

    public void loadModules(LanguageServerContext context) {
        String taskId;
        LSClientLogger lsClientLogger = LSClientLogger.getInstance(context);
        this.notificationTaskId = taskId = UUID.randomUUID().toString();
        HashMap packagesList = new HashMap();
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> {
            this.languageClient = (ExtendedLanguageClient)context.get(ExtendedLanguageClient.class);
            if (this.languageClient == null) {
                return;
            }
            WorkDoneProgressCreateParams workDoneProgressCreateParams = new WorkDoneProgressCreateParams();
            workDoneProgressCreateParams.setToken(taskId);
            this.languageClient.createProgress(workDoneProgressCreateParams);
            WorkDoneProgressBegin beginNotification = new WorkDoneProgressBegin();
            beginNotification.setTitle("Indexing");
            beginNotification.setCancellable(Boolean.valueOf(false));
            beginNotification.setMessage("Loading packages from Ballerina home...");
            this.languageClient.notifyProgress(new ProgressParams(Either.forLeft((Object)taskId), Either.forLeft((Object)beginNotification)));
        }).thenRunAsync(() -> {
            Environment environment = EnvironmentBuilder.getBuilder().build();
            BallerinaDistribution ballerinaDistribution = BallerinaDistribution.from((Environment)environment);
            BallerinaDistributionRepository packageRepository = ballerinaDistribution.packageRepository();
            List<String> skippedLangLibs = Arrays.asList("lang.annotations", "lang.__internal", "lang.query");
            lsClientLogger.logTrace("Loading packages from Ballerina distribution");
            this.distRepoPackages.addAll(this.checkAndResolvePackagesFromRepository((PackageRepository)packageRepository, skippedLangLibs, Collections.emptySet()));
            lsClientLogger.logTrace("Successfully loaded packages from Ballerina distribution");
            this.getDistributionRepoModules().forEach(packageInfo -> packagesList.put(packageInfo.packageIdentifier(), packageInfo));
            ArrayList<ModuleInfo> repoPackages = new ArrayList<ModuleInfo>(this.getLocalRepoModules());
            repoPackages.stream().filter(packageInfo -> !packagesList.containsKey(packageInfo.packageIdentifier())).forEach(packageInfo -> packagesList.put(packageInfo.packageIdentifier(), packageInfo));
        })).thenRunAsync(() -> {
            WorkDoneProgressCreateParams workDoneProgressCreateParams = new WorkDoneProgressCreateParams();
            workDoneProgressCreateParams.setToken(taskId);
            this.languageClient.createProgress(workDoneProgressCreateParams);
            WorkDoneProgressReport progressNotification = new WorkDoneProgressReport();
            progressNotification.setMessage("Loading packages from Ballerina central");
            progressNotification.setCancellable(Boolean.valueOf(false));
            this.languageClient.notifyProgress(new ProgressParams(Either.forLeft((Object)taskId), Either.forLeft((Object)progressNotification)));
            try {
                String moduleInfo = FileUtils.readFileAsString((String)"moduleInfo.json");
                this.centralPackages.addAll((Collection)new Gson().fromJson(moduleInfo, new TypeToken<List<ModuleInfo>>(){}.getType()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).thenRunAsync(() -> {
            WorkDoneProgressEnd endNotification = new WorkDoneProgressEnd();
            endNotification.setMessage("Initialized Successfully!");
            this.languageClient.notifyProgress(new ProgressParams(Either.forLeft((Object)taskId), Either.forLeft((Object)endNotification)));
        })).exceptionally(e -> {
            WorkDoneProgressEnd endNotification = new WorkDoneProgressEnd();
            endNotification.setMessage("Initialization Failed!");
            this.languageClient.notifyProgress(new ProgressParams(Either.forLeft((Object)taskId), Either.forLeft((Object)endNotification)));
            this.clientLogger.logTrace("Failed initializing the Package Loader due to " + e.getMessage());
            return null;
        });
        this.initialized = true;
    }

    public List<ModuleInfo> getLocalRepoModules() {
        return this.localRepoPackages;
    }

    public List<ModuleInfo> getRemoteRepoModules() {
        return this.remoteRepoPackages;
    }

    public List<ModuleInfo> getDistributionRepoModules() {
        return this.distRepoPackages;
    }

    public List<ModuleInfo> getCentralPackages() {
        return this.centralPackages;
    }

    public List<ModuleInfo> getAllVisiblePackages(DocumentServiceContext ctx) {
        HashMap packagesList = new HashMap();
        this.getDistributionRepoModules().forEach(packageInfo -> packagesList.put(packageInfo.packageIdentifier(), packageInfo));
        ArrayList<ModuleInfo> repoPackages = new ArrayList<ModuleInfo>();
        repoPackages.addAll(this.getRemoteRepoModules());
        repoPackages.addAll(this.getLocalRepoModules());
        repoPackages.stream().filter(packageInfo -> !packagesList.containsKey(packageInfo.packageIdentifier())).forEach(packageInfo -> packagesList.put(packageInfo.packageIdentifier(), packageInfo));
        Package currentPackage = ((Project)ctx.workspace().project(ctx.filePath()).get()).currentPackage();
        currentPackage.modules().forEach(module -> {
            Package packageInstance = module.packageInstance();
            ModuleInfo moduleInfo = new ModuleInfo(PackageOrg.from((String)""), packageInstance.packageName(), packageInstance.packageVersion(), packageInstance.project().sourceRoot());
            moduleInfo.setModuleFromCurrentPackage(true);
            Optional currentModule = ctx.currentModule();
            String packageName = moduleInfo.packageName();
            String moduleName = module.descriptor().name().moduleNamePart();
            String qualifiedModName = packageName + String.valueOf(Names.DOT) + moduleName;
            if (currentModule.isEmpty() || module.isDefaultModule() || module.equals(currentModule.get()) || ModuleUtil.matchingImportedModule(ctx, "", qualifiedModName).isPresent()) {
                return;
            }
            moduleInfo.packageName = packageName + "." + moduleName;
            packagesList.put(moduleInfo.packageName, moduleInfo);
        });
        return new ArrayList<ModuleInfo>(packagesList.values());
    }

    public List<ModuleInfo> getPackagesFromBallerinaUserHome(DocumentServiceContext ctx) {
        ArrayList<ModuleInfo> packagesList = new ArrayList<ModuleInfo>();
        Optional project = ctx.workspace().project(ctx.filePath());
        if (project.isEmpty()) {
            return Collections.emptyList();
        }
        return packagesList;
    }

    public List<ModuleInfo> checkAndResolvePackagesFromRepository(PackageRepository repository, List<String> skipList, Set<String> loadedPackages) {
        Map packageMap = repository.getPackages();
        ArrayList<ModuleInfo> packages = new ArrayList<ModuleInfo>();
        packageMap.forEach((key, value) -> {
            if (key.equals(Names.BALLERINA_INTERNAL_ORG.getValue())) {
                return;
            }
            value.forEach(nameEntry -> {
                String[] components = nameEntry.split(":");
                if (components.length != 2 || skipList.contains(components[0])) {
                    return;
                }
                String nameComponent = components[0];
                String version = components[1];
                PackageOrg packageOrg = PackageOrg.from((String)key);
                PackageName packageName = PackageName.from((String)nameComponent);
                String packageIdentifier = packageOrg.toString() + "/" + String.valueOf(packageName);
                if (loadedPackages.contains(packageIdentifier)) {
                    return;
                }
                PackageVersion pkgVersion = PackageVersion.from((String)version);
                try {
                    PackageDescriptor pkdDesc = PackageDescriptor.from((PackageOrg)packageOrg, (PackageName)packageName, (PackageVersion)pkgVersion);
                    ResolutionRequest request = ResolutionRequest.from((PackageDescriptor)pkdDesc, (PackageDependencyScope)PackageDependencyScope.DEFAULT);
                    Optional repoPackage = repository.getPackage(request, ResolutionOptions.builder().setOffline(true).build());
                    repoPackage.ifPresent(pkg -> packages.add(new ModuleInfo((Package)pkg)));
                }
                catch (Throwable e) {
                    this.clientLogger.logTrace("Failed to resolve package " + String.valueOf(packageOrg) + (String)(!packageOrg.value().isEmpty() ? "/" : String.valueOf(packageName) + ":" + String.valueOf(pkgVersion)));
                }
            });
        });
        return packages;
    }

    public List<ModuleInfo> updatePackageMap(DocumentServiceContext context) {
        Optional project = context.workspace().project(context.filePath());
        if (project.isEmpty()) {
            return Collections.emptyList();
        }
        BallerinaUserHome ballerinaUserHome = BallerinaUserHome.from((Environment)((Project)project.get()).projectEnvironmentContext().environment());
        RemotePackageRepository remoteRepository = ballerinaUserHome.remotePackageRepository();
        List<ModuleInfo> moduleInfos = this.checkAndResolvePackagesFromRepository((PackageRepository)remoteRepository, Collections.emptyList(), this.remoteRepoPackages.stream().map(ModuleInfo::packageIdentifier).collect(Collectors.toSet()));
        this.remoteRepoPackages.addAll(moduleInfos);
        return moduleInfos;
    }

    public static class ModuleInfo {
        private static final String JSON_PROPERTY_ORGANIZATION = "organization";
        @SerializedName(value="organization")
        private final String packageOrg;
        private static final String JSON_PROPERTY_NAME = "name";
        @SerializedName(value="name")
        private String packageName;
        private static final String JSON_PROPERTY_VERSION = "version";
        @SerializedName(value="version")
        private final String packageVersion;
        @Expose(deserialize=false)
        private final Path sourceRoot;
        @Expose(deserialize=false)
        private final String moduleIdentifier;
        @Expose(deserialize=false)
        private boolean isModuleFromCurrentPackage = false;
        @Expose(deserialize=false)
        private final List<ServiceTemplateGenerator.ListenerMetaData> listenerMetaData = new ArrayList<ServiceTemplateGenerator.ListenerMetaData>();

        public ModuleInfo(String packageOrg, String packageName, String packageVersion) {
            this.packageOrg = packageOrg;
            this.packageName = packageName;
            this.packageVersion = packageVersion;
            this.sourceRoot = null;
            this.moduleIdentifier = packageOrg + "/" + packageName;
        }

        public ModuleInfo(PackageOrg packageOrg, PackageName packageName, PackageVersion version, Path path) {
            this.packageOrg = packageOrg.value();
            this.packageName = packageName.value();
            this.packageVersion = version.value().toString();
            this.sourceRoot = path;
            this.moduleIdentifier = packageOrg.toString().isEmpty() ? packageName.toString() : String.valueOf(packageOrg) + "/" + String.valueOf(packageName);
        }

        public ModuleInfo(Package pkg) {
            this.packageOrg = pkg.packageOrg().value();
            this.packageName = pkg.packageName().value();
            this.packageVersion = pkg.packageVersion().value().toString();
            this.sourceRoot = pkg.project().sourceRoot();
            this.moduleIdentifier = this.packageOrg.toString() + "/" + this.packageName.toString();
            this.addServiceTemplateMetaData();
        }

        public List<ServiceTemplateGenerator.ListenerMetaData> getListenerMetaData() {
            return this.listenerMetaData;
        }

        public String getModuleIdentifier() {
            return this.moduleIdentifier;
        }

        public boolean isModuleFromCurrentPackage() {
            return this.isModuleFromCurrentPackage;
        }

        public void setModuleFromCurrentPackage(boolean moduleFromCurrentPackage) {
            this.isModuleFromCurrentPackage = moduleFromCurrentPackage;
        }

        public String packageName() {
            return this.packageName;
        }

        public String packageOrg() {
            return this.packageOrg;
        }

        public String packageVersion() {
            return this.packageVersion;
        }

        public Path sourceRoot() {
            return this.sourceRoot;
        }

        public String packageIdentifier() {
            return this.moduleIdentifier;
        }

        private void addServiceTemplateMetaData() {
            String orgName = ModuleUtil.escapeModuleName(this.packageOrg());
            Project project = ProjectLoader.loadProject((Path)this.sourceRoot());
            PackageCompilation packageCompilation = project.currentPackage().getCompilation();
            Module module = project.currentPackage().getDefaultModule();
            String moduleName = module.descriptor().name().toString();
            String version = module.packageInstance().descriptor().version().value().toString();
            CodeActionModuleId moduleID = CodeActionModuleId.from(orgName, moduleName, version);
            SemanticModel semanticModel = packageCompilation.getSemanticModel(module.moduleId());
            semanticModel.moduleSymbols().stream().filter(ServiceTemplateGenerator.listenerPredicate()).forEach(listener -> ServiceTemplateGenerator.generateServiceSnippetMetaData(listener, moduleID).ifPresent(this.listenerMetaData::add));
        }
    }
}

