/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.LSCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;

public class CodeActionProvidersHolder {
    private static final Map<SyntaxKind, List<RangeBasedCodeActionProvider>> rangeBasedProviders = new HashMap<SyntaxKind, List<RangeBasedCodeActionProvider>>();
    private static final List<DiagnosticBasedCodeActionProvider> diagnosticsBasedProviders = new ArrayList<DiagnosticBasedCodeActionProvider>();
    private static final LanguageServerContext.Key<CodeActionProvidersHolder> CODE_ACTION_PROVIDERS_HOLDER_KEY = new LanguageServerContext.Key();

    public static CodeActionProvidersHolder getInstance(LanguageServerContext serverContext) {
        CodeActionProvidersHolder codeActionProvidersHolder = (CodeActionProvidersHolder)serverContext.get(CODE_ACTION_PROVIDERS_HOLDER_KEY);
        if (codeActionProvidersHolder == null) {
            codeActionProvidersHolder = new CodeActionProvidersHolder(serverContext);
        }
        return codeActionProvidersHolder;
    }

    private CodeActionProvidersHolder(LanguageServerContext serverContext) {
        serverContext.put(CODE_ACTION_PROVIDERS_HOLDER_KEY, (Object)this);
        this.loadServices();
    }

    private void loadServices() {
        if (!rangeBasedProviders.isEmpty()) {
            return;
        }
        ServiceLoader<LSCodeActionProvider> serviceLoader = ServiceLoader.load(LSCodeActionProvider.class);
        for (SyntaxKind nodeType : SyntaxKind.values()) {
            rangeBasedProviders.put(nodeType, new ArrayList());
        }
        for (LSCodeActionProvider provider : serviceLoader) {
            if (provider == null) continue;
            if (provider instanceof RangeBasedCodeActionProvider) {
                RangeBasedCodeActionProvider codeActionProvider = (RangeBasedCodeActionProvider)provider;
                for (SyntaxKind nodeType : codeActionProvider.getSyntaxKinds()) {
                    rangeBasedProviders.get(nodeType).add(codeActionProvider);
                }
            }
            if (!(provider instanceof DiagnosticBasedCodeActionProvider)) continue;
            DiagnosticBasedCodeActionProvider codeActionProvider = (DiagnosticBasedCodeActionProvider)provider;
            diagnosticsBasedProviders.add(codeActionProvider);
        }
    }

    List<RangeBasedCodeActionProvider> getActiveRangeBasedProviders(SyntaxKind nodeType, CodeActionContext ctx) {
        if (rangeBasedProviders.containsKey(nodeType)) {
            return rangeBasedProviders.get(nodeType).stream().filter(provider -> provider.isEnabled(ctx.languageServercontext())).sorted(Comparator.comparingInt(LSCodeActionProvider::priority)).toList();
        }
        return Collections.emptyList();
    }

    List<DiagnosticBasedCodeActionProvider> getActiveDiagnosticsBasedProviders(CodeActionContext ctx) {
        return diagnosticsBasedProviders.stream().filter(provider -> provider.isEnabled(ctx.languageServercontext())).sorted(Comparator.comparingInt(LSCodeActionProvider::priority)).toList();
    }

    public Optional<? extends LSCodeActionProvider> getProviderByName(String name) {
        Optional<DiagnosticBasedCodeActionProvider> diagnosticBasedProvider = diagnosticsBasedProviders.stream().filter(provider -> provider.getName().equals(name)).findFirst();
        if (diagnosticBasedProvider.isPresent()) {
            return diagnosticBasedProvider;
        }
        for (List<RangeBasedCodeActionProvider> providerList : rangeBasedProviders.values()) {
            Optional<RangeBasedCodeActionProvider> rangeBasedCodeActionProvider = providerList.stream().filter(provider -> provider.getName().equals(name)).findFirst();
            if (!rangeBasedCodeActionProvider.isPresent()) continue;
            return rangeBasedCodeActionProvider;
        }
        return Optional.empty();
    }
}

