/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.Document;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.codeaction.CodeActionNodeAnalyzer;
import org.ballerinalang.langserver.codeaction.DiagBasedPositionDetailsImpl;
import org.ballerinalang.langserver.codeaction.ScopedSymbolFinder;
import org.ballerinalang.langserver.common.ImportsAcceptor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.codeaction.CodeActionData;
import org.ballerinalang.langserver.commons.codeaction.ResolvableCodeAction;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public final class CodeActionUtil {
    private CodeActionUtil() {
    }

    public static List<Diagnostic> toDiagnostics(List<io.ballerina.tools.diagnostics.Diagnostic> ballerinaDiags) {
        ArrayList<Diagnostic> lsDiagnostics = new ArrayList<Diagnostic>();
        ballerinaDiags.forEach(diagnostic -> {
            Diagnostic lsDiagnostic = new Diagnostic();
            lsDiagnostic.setSeverity(DiagnosticSeverity.Error);
            lsDiagnostic.setMessage(diagnostic.message());
            Range range = new Range();
            Location location = diagnostic.location();
            LineRange lineRange = location.lineRange();
            int startLine = lineRange.startLine().line();
            int startChar = lineRange.startLine().offset();
            int endLine = lineRange.endLine().line();
            int endChar = lineRange.endLine().offset();
            if (endLine <= 0) {
                endLine = startLine;
            }
            if (endChar <= 0) {
                endChar = startChar + 1;
            }
            range.setStart(new Position(startLine, startChar));
            range.setEnd(new Position(endLine, endChar));
            lsDiagnostic.setRange(range);
            lsDiagnostics.add(lsDiagnostic);
        });
        return lsDiagnostics;
    }

    public static Optional<String> getPossibleType(TypeSymbol typeDescriptor, List<TextEdit> importEdits, CodeActionContext context) {
        List<String> possibleTypes = CodeActionUtil.getPossibleTypes(typeDescriptor, importEdits, context);
        return possibleTypes.isEmpty() ? Optional.empty() : Optional.of(possibleTypes.get(0));
    }

    public static Optional<String> getPossibleType(TypeSymbol typeDescriptor, CodeActionContext context, ImportsAcceptor importsAcceptor) {
        List<String> possibleTypes = CodeActionUtil.getPossibleTypes(typeDescriptor, context, importsAcceptor);
        return possibleTypes.isEmpty() ? Optional.empty() : Optional.of(possibleTypes.get(0));
    }

    public static Optional<String> getPossibleType(TypeSymbol typeDescriptor, CodeActionContext context) {
        ImportsAcceptor importsAcceptor = new ImportsAcceptor((DocumentServiceContext)context);
        List<String> possibleTypes = CodeActionUtil.getPossibleTypes(typeDescriptor, context, importsAcceptor);
        return possibleTypes.isEmpty() ? Optional.empty() : Optional.of(possibleTypes.get(0));
    }

    public static List<String> getPossibleTypes(TypeSymbol typeDescriptor, List<TextEdit> importEdits, CodeActionContext context) {
        ImportsAcceptor importsAcceptor = new ImportsAcceptor((DocumentServiceContext)context);
        List<String> possibleTypes = CodeActionUtil.getPossibleTypes(typeDescriptor, context, importsAcceptor);
        importEdits.addAll(importsAcceptor.getNewImportTextEdits());
        return possibleTypes;
    }

    public static List<String> getPossibleTypes(TypeSymbol typeDescriptor, CodeActionContext context, ImportsAcceptor importsAcceptor) {
        return new ArrayList<String>(CodeActionUtil.getPossibleTypeSymbols(typeDescriptor, context, importsAcceptor).values());
    }

    public static Map<TypeSymbol, String> getPossibleTypeSymbols(TypeSymbol typeDescriptor, List<TextEdit> importEdits, CodeActionContext context) {
        ImportsAcceptor importsAcceptor = new ImportsAcceptor((DocumentServiceContext)context);
        Map<TypeSymbol, String> possibleTypes = CodeActionUtil.getPossibleTypeSymbols(typeDescriptor, context, importsAcceptor);
        importEdits.addAll(importsAcceptor.getNewImportTextEdits());
        return possibleTypes;
    }

    public static Map<TypeSymbol, String> getPossibleTypeSymbols(TypeSymbol typeDescriptor, CodeActionContext context, ImportsAcceptor importsAcceptor) {
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return Collections.emptyMap();
        }
        if (typeDescriptor.getName().isPresent() && ((String)typeDescriptor.getName().get()).startsWith("$")) {
            typeDescriptor = CommonUtil.getRawType(typeDescriptor);
        }
        HashMap<TypeSymbol, String> typesMap = new HashMap<TypeSymbol, String>();
        Types types = ((SemanticModel)semanticModel.get()).types();
        TypeBuilder typeBuilder = types.builder();
        if (typeDescriptor.typeKind() == TypeDescKind.RECORD) {
            Optional<TypeSymbol> firstFieldType;
            boolean isConstrainedMap;
            boolean jsonSubType;
            Position cursorPosition = new Position(context.range().getStart().getLine(), context.range().getStart().getCharacter());
            List visibleSymbols = context.visibleSymbols(cursorPosition);
            for (Symbol symbol : visibleSymbols) {
                if (symbol.kind() != SymbolKind.TYPE_DEFINITION || ((TypeDefinitionSymbol)symbol).typeDescriptor().typeKind() != TypeDescKind.RECORD || !typeDescriptor.subtypeOf(((TypeDefinitionSymbol)symbol).typeDescriptor())) continue;
                Optional module = symbol.getModule();
                Object fqPrefix = "";
                if (module.isPresent() && !"$anon".equals(((ModuleSymbol)module.get()).id().orgName())) {
                    ModuleID id = ((ModuleSymbol)module.get()).id();
                    fqPrefix = id.orgName() + "/" + id.moduleName() + ":" + id.version() + ":";
                }
                String moduleQualifiedName = (String)fqPrefix + (String)symbol.getName().get();
                typesMap.put(((TypeDefinitionSymbol)symbol).typeDescriptor(), FunctionGenerator.processModuleIDsInText(importsAcceptor, moduleQualifiedName, (DocumentServiceContext)context));
            }
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeDescriptor;
            String rType = FunctionGenerator.generateTypeSignature(importsAcceptor, typeDescriptor, (DocumentServiceContext)context);
            typesMap.put((TypeSymbol)recordTypeSymbol, !recordTypeSymbol.fieldDescriptors().isEmpty() ? rType : "record {}");
            boolean bl = jsonSubType = recordTypeSymbol.fieldDescriptors().values().stream().allMatch(recordFieldSymbol -> CodeActionUtil.isJsonMemberType(recordFieldSymbol.typeDescriptor())) && recordTypeSymbol.restTypeDescriptor().map(CodeActionUtil::isJsonMemberType).orElse(true) != false;
            if (jsonSubType) {
                typesMap.put(types.JSON, types.JSON.signature());
            }
            if (isConstrainedMap = (firstFieldType = recordTypeSymbol.fieldDescriptors().values().stream().findFirst().map(RecordFieldSymbol::typeDescriptor)).map(fieldType -> recordTypeSymbol.fieldDescriptors().values().stream().map(RecordFieldSymbol::typeDescriptor).allMatch(type -> type.subtypeOf(fieldType) || fieldType.subtypeOf(type))).orElse(false).booleanValue()) {
                String type = FunctionGenerator.generateTypeSignature(importsAcceptor, firstFieldType.get(), (DocumentServiceContext)context);
                typesMap.put((TypeSymbol)typeBuilder.MAP_TYPE.withTypeParam(firstFieldType.get()).build(), "map<" + type + ">");
                return typesMap;
            }
            typesMap.put((TypeSymbol)typeBuilder.MAP_TYPE.withTypeParam(types.ANY).build(), "map<any>");
        } else if (typeDescriptor.typeKind() == TypeDescKind.TUPLE) {
            boolean isArrayCandidate;
            TupleTypeSymbol tupleType = (TupleTypeSymbol)typeDescriptor;
            Optional firstMemberType = tupleType.memberTypeDescriptors().stream().findFirst();
            boolean bl = isArrayCandidate = tupleType.restTypeDescriptor().isEmpty() && firstMemberType.map(first -> tupleType.memberTypeDescriptors().stream().allMatch(typeSymbol -> typeSymbol.subtypeOf(first) || first.subtypeOf(typeSymbol))).orElse(false) != false;
            if (isArrayCandidate) {
                CodeActionUtil.getPossibleTypeSymbols((TypeSymbol)firstMemberType.get(), context, importsAcceptor).entrySet().forEach(entry -> typesMap.put((TypeSymbol)typeBuilder.ARRAY_TYPE.withType((TypeSymbol)entry.getKey()).build(), (String)entry.getValue() + "[]"));
            }
            typesMap.put((TypeSymbol)tupleType, FunctionGenerator.generateTypeSignature(importsAcceptor, (TypeSymbol)tupleType, (DocumentServiceContext)context));
        } else if (typeDescriptor.typeKind() == TypeDescKind.ARRAY) {
            ArrayTypeSymbol arrayTypeSymbol = (ArrayTypeSymbol)typeDescriptor;
            CodeActionUtil.getPossibleTypeSymbols(arrayTypeSymbol.memberTypeDescriptor(), context, importsAcceptor).entrySet().forEach(entry -> {
                ArrayTypeSymbol newArrType = typeBuilder.ARRAY_TYPE.withType((TypeSymbol)entry.getKey()).build();
                String signature = switch (newArrType.memberTypeDescriptor().typeKind()) {
                    case TypeDescKind.FUNCTION, TypeDescKind.UNION -> {
                        String typeName = FunctionGenerator.processModuleIDsInText(importsAcceptor, newArrType.memberTypeDescriptor().signature(), (DocumentServiceContext)context);
                        yield "(" + typeName + ")[]";
                    }
                    default -> FunctionGenerator.processModuleIDsInText(importsAcceptor, newArrType.signature(), (DocumentServiceContext)context);
                };
                typesMap.put((TypeSymbol)newArrType, signature);
            });
        } else {
            typesMap.put(typeDescriptor, FunctionGenerator.generateTypeSignature(importsAcceptor, typeDescriptor, (DocumentServiceContext)context));
        }
        return typesMap;
    }

    public static boolean isJsonMemberType(TypeSymbol typeSymbol) {
        return switch (typeSymbol.typeKind()) {
            case TypeDescKind.NIL, TypeDescKind.BOOLEAN, TypeDescKind.INT, TypeDescKind.FLOAT, TypeDescKind.DECIMAL, TypeDescKind.STRING, TypeDescKind.JSON -> true;
            case TypeDescKind.ARRAY -> CodeActionUtil.isJsonMemberType(((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor());
            case TypeDescKind.MAP -> CodeActionUtil.isJsonMemberType(((MapTypeSymbol)typeSymbol).typeParam());
            default -> false;
        };
    }

    public static DiagBasedPositionDetails computePositionDetails(SyntaxTree syntaxTree, io.ballerina.tools.diagnostics.Diagnostic diagnostic, CodeActionContext context) {
        Symbol matchedSymbol;
        NonTerminalNode matchedNode;
        Range range = PositionUtil.toRange(diagnostic.location().lineRange());
        NonTerminalNode cursorNode = CommonUtil.findNode(range, syntaxTree);
        Document srcFile = (Document)context.currentDocument().orElseThrow();
        SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().orElseThrow();
        Optional<Pair<NonTerminalNode, Symbol>> nodeAndSymbol = CodeActionUtil.getMatchedNodeAndSymbol(cursorNode, range, semanticModel, srcFile);
        if (nodeAndSymbol.isPresent()) {
            matchedNode = (NonTerminalNode)nodeAndSymbol.get().getLeft();
            matchedSymbol = (Symbol)nodeAndSymbol.get().getRight();
        } else {
            matchedNode = cursorNode;
            matchedSymbol = null;
        }
        return DiagBasedPositionDetailsImpl.from(matchedNode, matchedSymbol, diagnostic);
    }

    public static List<TextEdit> getTypeGuardCodeActionEdits(String varName, Range range, UnionTypeSymbol unionType, CodeActionContext context) {
        boolean transitiveBinaryUnion;
        Position startPos = range.getEnd();
        Range newTextRange = new Range(startPos, startPos);
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        String spaces = StringUtils.repeat((char)' ', (int)range.getStart().getCharacter());
        String padding = CommonUtil.LINE_SEPARATOR + CommonUtil.LINE_SEPARATOR + spaces;
        List<TypeSymbol> errorMembers = unionType.memberTypeDescriptors().stream().filter(typeSymbol -> CommonUtil.getRawType(typeSymbol).typeKind() == TypeDescKind.ERROR).toList();
        ArrayList<TypeSymbol> members = new ArrayList<TypeSymbol>(unionType.memberTypeDescriptors());
        if (members.size() == 1) {
            return edits;
        }
        boolean bl = transitiveBinaryUnion = unionType.memberTypeDescriptors().size() - errorMembers.size() == 1;
        if (transitiveBinaryUnion) {
            members.removeIf(typeSymbol -> CommonUtil.getRawType(typeSymbol).typeKind() == TypeDescKind.ERROR);
        }
        ImportsAcceptor importsAcceptor = new ImportsAcceptor((DocumentServiceContext)context);
        if ((unionType.memberTypeDescriptors().size() == 2 || transitiveBinaryUnion) && !errorMembers.isEmpty()) {
            members.forEach(bType -> {
                if (bType.typeKind() == TypeDescKind.NIL) {
                    String type = ((TypeSymbol)errorMembers.get(0)).signature();
                    type = FunctionGenerator.processModuleIDsInText(importsAcceptor, type, (DocumentServiceContext)context);
                    String newText = CodeActionUtil.generateIfElseText(varName, spaces, padding, List.of(type));
                    edits.add(new TextEdit(newTextRange, newText));
                } else {
                    String type = CodeActionUtil.getPossibleType(bType, edits, context).orElseThrow();
                    String newText = CodeActionUtil.generateIfElseText(varName, spaces, padding, List.of(type));
                    edits.add(new TextEdit(newTextRange, newText));
                }
            });
        } else {
            boolean addErrorTypeAtEnd = false;
            ArrayList<TypeSymbol> tMembers = new ArrayList<TypeSymbol>(unionType.memberTypeDescriptors());
            if (errorMembers.size() > 1) {
                tMembers.removeIf(typeSymbol -> CommonUtil.getRawType(typeSymbol).typeKind() == TypeDescKind.ERROR);
                addErrorTypeAtEnd = true;
            }
            ArrayList<String> memberTypes = new ArrayList<String>();
            for (TypeSymbol tMember : tMembers) {
                memberTypes.add(CodeActionUtil.getPossibleType(tMember, edits, context).orElseThrow());
            }
            if (addErrorTypeAtEnd) {
                memberTypes.add("error");
            }
            edits.add(new TextEdit(newTextRange, CodeActionUtil.generateIfElseText(varName, spaces, padding, memberTypes)));
        }
        edits.addAll(importsAcceptor.getNewImportTextEdits());
        return edits;
    }

    public static List<TextEdit> addGettersCodeActionEdits(String varName, Range range, String spaces, String typeName) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        edits.add(new TextEdit(range, CodeActionUtil.generateGetterFunctionBodyText(varName, typeName, spaces)));
        return edits;
    }

    public static List<TextEdit> addSettersCodeActionEdits(String varName, Range range, String spaces, String typeName) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        edits.add(new TextEdit(range, CodeActionUtil.generateSetterFunctionBodyText(varName, typeName, spaces)));
        return edits;
    }

    public static List<TextEdit> getAddCheckTextEdits(Position pos, NonTerminalNode matchedNode, CodeActionContext context, List<TypeSymbol> errorTypeSymbols, ImportsAcceptor acceptor) {
        if (errorTypeSymbols.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        Optional<FunctionDefinitionNode> enclosedFuncNode = CodeActionUtil.getEnclosedFunction((Node)matchedNode);
        String returnText = "";
        Range returnRange = null;
        Optional semanticModel = context.currentSemanticModel();
        Optional document = context.currentDocument();
        if (enclosedFuncNode.isPresent() && semanticModel.isPresent() && document.isPresent()) {
            if (enclosedFuncNode.get().functionSignature().returnTypeDesc().isPresent()) {
                ReturnTypeDescriptorNode enclosedRetTypeDescNode = (ReturnTypeDescriptorNode)enclosedFuncNode.get().functionSignature().returnTypeDesc().get();
                Optional returnTypeDescriptor = ((SemanticModel)semanticModel.get()).symbol((Document)document.get(), enclosedFuncNode.get().functionName().lineRange().startLine()).filter(funcSymbol -> funcSymbol.kind() == SymbolKind.FUNCTION || funcSymbol.kind() == SymbolKind.METHOD || funcSymbol.kind() == SymbolKind.RESOURCE_METHOD).flatMap(symbol -> ((FunctionSymbol)symbol).typeDescriptor().returnTypeDescriptor());
                if (returnTypeDescriptor.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<TypeSymbol> allErrorTypes = new ArrayList<TypeSymbol>(errorTypeSymbols);
                Pair<List<TypeSymbol>, List<TypeSymbol>> errorAndNonErrorTypedSymbols = CodeActionUtil.getErrorAndNonErrorTypedSymbols((TypeSymbol)returnTypeDescriptor.get());
                allErrorTypes.addAll((Collection)errorAndNonErrorTypedSymbols.getRight());
                List<TypeSymbol> errorSymbolsToAdd = CodeActionUtil.filterErrorSubTypes(allErrorTypes);
                boolean isNewErrorTypeAvailable = errorSymbolsToAdd.stream().anyMatch(typeSymbol -> ((List)errorAndNonErrorTypedSymbols.getRight()).stream().noneMatch(otherSymbol -> otherSymbol.signature().equals(typeSymbol.signature())));
                if (!errorSymbolsToAdd.isEmpty() && isNewErrorTypeAvailable) {
                    if (((TypeSymbol)returnTypeDescriptor.get()).typeKind() == TypeDescKind.COMPILATION_ERROR) {
                        String returnType = enclosedRetTypeDescNode.type().toString().replaceAll("\\s+", "");
                        UnionTypeSymbol newMemberType = ((SemanticModel)semanticModel.get()).types().builder().UNION_TYPE.withMemberTypes(errorSymbolsToAdd.toArray(new TypeSymbol[0])).build();
                        returnText = String.format("returns %s|%s", returnType, newMemberType.signature());
                    } else {
                        ArrayList<TypeSymbol> memberTypes = new ArrayList<TypeSymbol>();
                        boolean nilReturnType = ((List)errorAndNonErrorTypedSymbols.getLeft()).stream().anyMatch(typeSymbol -> typeSymbol.typeKind() == TypeDescKind.NIL);
                        memberTypes.addAll(((List)errorAndNonErrorTypedSymbols.getLeft()).stream().filter(typeSymbol -> typeSymbol.typeKind() != TypeDescKind.NIL).toList());
                        memberTypes.addAll(errorSymbolsToAdd);
                        UnionTypeSymbol newType = ((SemanticModel)semanticModel.get()).types().builder().UNION_TYPE.withMemberTypes(memberTypes.toArray(new TypeSymbol[0])).build();
                        String typeName = CodeActionUtil.getPossibleType((TypeSymbol)newType, context, acceptor).orElseThrow();
                        returnText = String.format("returns %s", typeName + (nilReturnType ? "?" : ""));
                    }
                    returnRange = PositionUtil.toRange(enclosedRetTypeDescNode.lineRange());
                }
            } else {
                List<TypeSymbol> errorSymbolsToAdd = CodeActionUtil.filterErrorSubTypes(errorTypeSymbols);
                UnionTypeSymbol newMemberType = ((SemanticModel)semanticModel.get()).types().builder().UNION_TYPE.withMemberTypes(errorSymbolsToAdd.toArray(new TypeSymbol[0])).build();
                String typeName = CodeActionUtil.getPossibleType((TypeSymbol)newMemberType, context, acceptor).orElseThrow();
                returnText = String.format(" returns %s?", typeName);
                Position position = PositionUtil.toPosition(enclosedFuncNode.get().functionSignature().closeParenToken().lineRange().endLine());
                returnRange = new Range(position, position);
            }
        }
        if (matchedNode.kind() != SyntaxKind.BRACED_EXPRESSION && matchedNode.parent().kind() == SyntaxKind.METHOD_CALL) {
            Position endPos = PositionUtil.toPosition(matchedNode.lineRange().endLine());
            edits.add(new TextEdit(new Range(pos, pos), "("));
            edits.add(new TextEdit(new Range(endPos, endPos), ")"));
        }
        edits.add(new TextEdit(new Range(pos, pos), "check "));
        if (!returnText.isEmpty()) {
            edits.add(new TextEdit(returnRange, returnText));
        }
        return edits;
    }

    private static List<TypeSymbol> filterErrorSubTypes(List<TypeSymbol> errorTypeSymbols) {
        if (errorTypeSymbols.size() == 1) {
            return errorTypeSymbols;
        }
        ArrayList<TypeSymbol> errorTypeSymbolsClone = new ArrayList<TypeSymbol>(errorTypeSymbols);
        return errorTypeSymbolsClone.stream().filter(typeSymbol -> errorTypeSymbols.stream().filter(other -> !other.signature().equals(typeSymbol.signature())).noneMatch(arg_0 -> ((TypeSymbol)typeSymbol).subtypeOf(arg_0))).toList();
    }

    private static Pair<List<TypeSymbol>, List<TypeSymbol>> getErrorAndNonErrorTypedSymbols(TypeSymbol returnTypeDescriptor) {
        if (returnTypeDescriptor.typeKind() == TypeDescKind.UNION) {
            ArrayList<TypeSymbol> errorTypeSymbols = new ArrayList<TypeSymbol>();
            ArrayList<TypeSymbol> nonErrorTypeSymbols = new ArrayList<TypeSymbol>();
            for (TypeSymbol typeSymbol : ((UnionTypeSymbol)returnTypeDescriptor).memberTypeDescriptors()) {
                if (CommonUtil.getRawType(typeSymbol).typeKind() == TypeDescKind.ERROR) {
                    errorTypeSymbols.add(typeSymbol);
                    continue;
                }
                nonErrorTypeSymbols.add(typeSymbol);
            }
            return Pair.of(nonErrorTypeSymbols, errorTypeSymbols);
        }
        if (CommonUtil.getRawType(returnTypeDescriptor).typeKind() == TypeDescKind.ERROR) {
            return Pair.of(Collections.emptyList(), List.of(returnTypeDescriptor));
        }
        return Pair.of(List.of(returnTypeDescriptor), Collections.emptyList());
    }

    public static Node largestExpressionNode(Node node, Range range) {
        Predicate<Node> isWithinScope = tNode -> tNode != null && !(tNode instanceof ExpressionStatementNode) && PositionUtil.isWithinRange(PositionUtil.toPosition(tNode.lineRange().startLine()), range) && PositionUtil.isWithinRange(PositionUtil.toPosition(tNode.lineRange().endLine()), range);
        while (isWithinScope.test((Node)node.parent())) {
            node = node.parent();
        }
        if (node.kind() == SyntaxKind.ASSIGNMENT_STATEMENT) {
            return ((AssignmentStatementNode)node).expression();
        }
        if (node.kind() == SyntaxKind.MODULE_VAR_DECL) {
            return ((ModuleVariableDeclarationNode)node).typedBindingPattern().bindingPattern();
        }
        if (node.kind() == SyntaxKind.LOCAL_VAR_DECL) {
            return ((VariableDeclarationNode)node).typedBindingPattern().bindingPattern();
        }
        return node;
    }

    public static Optional<NonTerminalNode> getTopLevelNode(Range range, SyntaxTree syntaxTree) {
        CodeActionNodeAnalyzer analyzer = CodeActionNodeAnalyzer.analyze(range, syntaxTree);
        return analyzer.getCodeActionNode();
    }

    private static boolean isWithinRange(int positionOffset, int startOffSet, int endOffset) {
        return positionOffset > startOffSet && positionOffset < endOffset;
    }

    private static Optional<Pair<NonTerminalNode, Symbol>> getMatchedNodeAndSymbol(NonTerminalNode cursorNode, Range range, SemanticModel semanticModel, Document srcFile) {
        ScopedSymbolFinder scopedSymbolFinder = new ScopedSymbolFinder(range);
        scopedSymbolFinder.visit((Node)cursorNode);
        if (scopedSymbolFinder.node().isEmpty() || scopedSymbolFinder.nodeIdentifierPos().isEmpty()) {
            return Optional.empty();
        }
        LinePosition position = scopedSymbolFinder.nodeIdentifierPos().get();
        LinePosition matchedNodePos = LinePosition.from((int)position.line(), (int)(position.offset() + 1));
        Optional optMatchedSymbol = semanticModel.symbol(srcFile, matchedNodePos);
        if (optMatchedSymbol.isEmpty()) {
            return Optional.empty();
        }
        Symbol matchedSymbol = (Symbol)optMatchedSymbol.get();
        NonTerminalNode matchedNode = scopedSymbolFinder.node().get();
        return Optional.of(new ImmutablePair((Object)matchedNode, (Object)matchedSymbol));
    }

    public static Optional<ExplicitAnonymousFunctionExpressionNode> getEnclosingAnonFuncExpr(Node matchedNode) {
        if (matchedNode == null) {
            return Optional.empty();
        }
        while (matchedNode.parent() != null) {
            if (matchedNode.kind() == SyntaxKind.EXPLICIT_ANONYMOUS_FUNCTION_EXPRESSION) {
                return Optional.of((ExplicitAnonymousFunctionExpressionNode)matchedNode);
            }
            matchedNode = matchedNode.parent();
        }
        return Optional.empty();
    }

    public static Optional<FunctionDefinitionNode> getEnclosedFunction(Node matchedNode) {
        if (matchedNode == null) {
            return Optional.empty();
        }
        FunctionDefinitionNode functionDefNode = null;
        Node parentNode = matchedNode;
        while (parentNode.parent() != null) {
            boolean isFunctionDef = false;
            if (parentNode.kind() == SyntaxKind.FUNCTION_DEFINITION && parentNode.parent().kind() == SyntaxKind.MODULE_PART) {
                isFunctionDef = true;
            } else if (parentNode.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION && (parentNode.parent().kind() == SyntaxKind.CLASS_DEFINITION || parentNode.parent().kind() == SyntaxKind.SERVICE_DECLARATION || parentNode.parent().kind() == SyntaxKind.OBJECT_CONSTRUCTOR)) {
                isFunctionDef = true;
            } else if (parentNode.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
                NonTerminalNode evalNode = parentNode.parent();
                if (evalNode.kind() == SyntaxKind.SERVICE_DECLARATION) {
                    isFunctionDef = true;
                } else if (evalNode.kind() == SyntaxKind.CLASS_DEFINITION) {
                    isFunctionDef = ((ClassDefinitionNode)evalNode).classTypeQualifiers().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.CLIENT_KEYWORD);
                } else if (evalNode.kind() == SyntaxKind.OBJECT_CONSTRUCTOR) {
                    isFunctionDef = true;
                }
            }
            if (isFunctionDef) {
                functionDefNode = (FunctionDefinitionNode)parentNode;
                break;
            }
            parentNode = parentNode.parent();
        }
        return Optional.ofNullable(functionDefNode);
    }

    public static boolean hasErrorMemberType(UnionTypeSymbol unionTypeSymbol) {
        return unionTypeSymbol.memberTypeDescriptors().stream().map(CommonUtil::getRawType).anyMatch(member -> member.typeKind() == TypeDescKind.ERROR);
    }

    private static String generateIfElseText(String varName, String spaces, String padding, List<String> memberTypes) {
        if (memberTypes.size() == 1) {
            return CommonUtil.LINE_SEPARATOR + String.format("%sif %s is %s {%s}", spaces, varName, memberTypes.get(0), padding);
        }
        StringBuilder newTextBuilder = new StringBuilder();
        for (int i = 0; i < memberTypes.size() - 1; ++i) {
            String memberType = memberTypes.get(i);
            String prefix = i == 0 ? spaces : " else ";
            newTextBuilder.append(String.format("%sif %s is %s {%s}", prefix, varName, memberType, padding));
        }
        newTextBuilder.append(String.format(" else {%s}%s", padding, CommonUtil.LINE_SEPARATOR));
        return CommonUtil.LINE_SEPARATOR + newTextBuilder.toString();
    }

    private static String generateGetterFunctionBodyText(String varName, String typeName, String spaces) {
        StringBuilder newTextBuilder = new StringBuilder();
        String extractedVarName = CodeActionUtil.removeQuotedIdentifier(varName);
        String functionName = extractedVarName.substring(0, 1).toUpperCase(Locale.ROOT) + extractedVarName.substring(1);
        newTextBuilder.append(CommonUtil.LINE_SEPARATOR).append(CommonUtil.LINE_SEPARATOR).append(spaces).append(String.format("public function get%s() returns %s { ", functionName, typeName)).append(CommonUtil.LINE_SEPARATOR).append(spaces).append(spaces).append(String.format("return self.%s;", varName)).append(CommonUtil.LINE_SEPARATOR).append(spaces).append("}");
        return newTextBuilder.toString();
    }

    private static String generateSetterFunctionBodyText(String varName, String typeName, String spaces) {
        StringBuilder newTextBuilder = new StringBuilder();
        String extractedVarName = CodeActionUtil.removeQuotedIdentifier(varName);
        String functionName = extractedVarName.substring(0, 1).toUpperCase(Locale.ROOT) + extractedVarName.substring(1);
        newTextBuilder.append(CommonUtil.LINE_SEPARATOR).append(CommonUtil.LINE_SEPARATOR).append(spaces).append(String.format("public function set%s(%s %s) { ", functionName, typeName, extractedVarName)).append(CommonUtil.LINE_SEPARATOR).append(spaces).append(spaces).append(String.format("self.%s = %s;", varName, extractedVarName)).append(CommonUtil.LINE_SEPARATOR).append(spaces).append("}");
        return newTextBuilder.toString();
    }

    public static boolean isWithinVarName(CodeActionContext context, ObjectFieldNode objectFieldNode) {
        return objectFieldNode.fieldName().lineRange().startLine().offset() <= context.cursorPosition().getCharacter() && context.cursorPosition().getCharacter() <= objectFieldNode.fieldName().lineRange().endLine().offset();
    }

    public static boolean isRangeSelection(Range range) {
        return !range.getStart().equals((Object)range.getEnd());
    }

    public static List<TextEdit> getGetterSetterCodeEdits(ObjectFieldNode objectFieldNode, Optional<FunctionDefinitionNode> initNode, String fieldName, String typeName, String name) {
        int textOffset;
        int startOffset;
        int startLine;
        if (initNode.isEmpty()) {
            LinePosition linePosition = ((ClassDefinitionNode)objectFieldNode.parent()).members().get(((ClassDefinitionNode)objectFieldNode.parent()).members().size() - 1).lineRange().endLine();
            startLine = linePosition.line();
            startOffset = linePosition.offset();
            textOffset = objectFieldNode.lineRange().startLine().offset();
        } else {
            LineRange lineRange = initNode.get().lineRange();
            startLine = lineRange.endLine().line();
            startOffset = lineRange.endLine().offset();
            textOffset = lineRange.startLine().offset();
        }
        Position startPos = new Position(startLine, startOffset);
        Range newTextRange = new Range(startPos, startPos);
        String spaces = StringUtils.repeat((char)' ', (int)textOffset);
        if (name.equals("Getter")) {
            return CodeActionUtil.addGettersCodeActionEdits(fieldName, newTextRange, spaces, typeName);
        }
        if (name.equals("Setter")) {
            return CodeActionUtil.addSettersCodeActionEdits(fieldName, newTextRange, spaces, typeName);
        }
        List<TextEdit> edits = CodeActionUtil.addGettersCodeActionEdits(fieldName, newTextRange, spaces, typeName);
        edits.addAll(CodeActionUtil.addSettersCodeActionEdits(fieldName, newTextRange, spaces, typeName));
        return edits;
    }

    public static Optional<FunctionDefinitionNode> getInitNode(ObjectFieldNode objectFieldNode) {
        FunctionDefinitionNode initNode = null;
        for (Node node : ((ClassDefinitionNode)objectFieldNode.parent()).members()) {
            if (node.kind() != SyntaxKind.OBJECT_METHOD_DEFINITION || !((FunctionDefinitionNode)node).functionName().toString().equals("init")) continue;
            initNode = (FunctionDefinitionNode)node;
        }
        return Optional.ofNullable(initNode);
    }

    public static boolean isFunctionDefined(String functionName, ObjectFieldNode objectFieldNode) {
        for (Node node : ((ClassDefinitionNode)objectFieldNode.parent()).members()) {
            if (node.kind() != SyntaxKind.OBJECT_METHOD_DEFINITION || !((FunctionDefinitionNode)node).functionName().text().equals(CodeActionUtil.removeQuotedIdentifier(functionName))) continue;
            return true;
        }
        return false;
    }

    public static Optional<ObjectFieldNode> getObjectFieldNode(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        NonTerminalNode matchedNode = posDetails.matchedCodeActionNode();
        if (matchedNode.kind() != SyntaxKind.OBJECT_FIELD || matchedNode.hasDiagnostics()) {
            return Optional.empty();
        }
        ObjectFieldNode objectFieldNode = (ObjectFieldNode)matchedNode;
        if (!CodeActionUtil.isWithinVarName(context, objectFieldNode)) {
            return Optional.empty();
        }
        return Optional.of(objectFieldNode);
    }

    public static boolean isImmutableObjectField(ObjectFieldNode objectFieldNode) {
        return objectFieldNode.qualifierList().stream().anyMatch(qualifiers -> qualifiers.toString().strip().equals("final") || qualifiers.toString().strip().equals("readonly"));
    }

    public static <T> Function<List<DiagnosticProperty<?>>, Optional<T>> getDiagPropertyFilterFunction(int propertyIndex) {
        Function<List<DiagnosticProperty<?>>, Optional<T>> filterFunction = diagnosticProperties -> {
            if (diagnosticProperties.size() < propertyIndex + 1) {
                return Optional.empty();
            }
            DiagnosticProperty diagnosticProperty = (DiagnosticProperty)diagnosticProperties.get(propertyIndex);
            return Optional.ofNullable(diagnosticProperty.value());
        };
        return filterFunction;
    }

    public static CodeAction createCodeAction(String commandTitle, Command command, String codeActionKind) {
        ArrayList<io.ballerina.tools.diagnostics.Diagnostic> diagnostics = new ArrayList<io.ballerina.tools.diagnostics.Diagnostic>();
        CodeAction action = new CodeAction(commandTitle);
        action.setKind(codeActionKind);
        action.setCommand(command);
        action.setDiagnostics(CodeActionUtil.toDiagnostics(diagnostics));
        return action;
    }

    public static CodeAction createCodeAction(String commandTitle, List<TextEdit> edits, String uri) {
        ArrayList<io.ballerina.tools.diagnostics.Diagnostic> diagnostics = new ArrayList<io.ballerina.tools.diagnostics.Diagnostic>();
        CodeAction action = new CodeAction(commandTitle);
        action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, null), edits)))));
        action.setDiagnostics(CodeActionUtil.toDiagnostics(diagnostics));
        return action;
    }

    public static CodeAction createCodeAction(String commandTitle, List<TextEdit> edits, String uri, String codeActionKind) {
        CodeAction action = CodeActionUtil.createCodeAction(commandTitle, edits, uri);
        action.setKind(codeActionKind);
        return action;
    }

    public static String removeQuotedIdentifier(String identifier) {
        return identifier.startsWith("'") ? identifier.substring(1) : identifier;
    }

    public static ResolvableCodeAction createResolvableCodeAction(String commandTitle, String codeActionKind, CodeActionData data) {
        ArrayList<io.ballerina.tools.diagnostics.Diagnostic> diagnostics = new ArrayList<io.ballerina.tools.diagnostics.Diagnostic>();
        ResolvableCodeAction action = new ResolvableCodeAction(commandTitle);
        action.setDiagnostics(CodeActionUtil.toDiagnostics(diagnostics));
        action.setKind(codeActionKind);
        action.setData(data);
        return action;
    }

    public static boolean addNewLineAtEnd(Node enclosingNode) {
        for (Node next : enclosingNode.parent().children()) {
            if (next.textRange().length() <= 0 || next.lineRange().startLine().line() != enclosingNode.lineRange().endLine().line() + 1) continue;
            return true;
        }
        return false;
    }

    public static void addRenamePopup(CodeActionContext context, CodeAction codeAction, String command, Position renamePosition) {
        LSClientCapabilities lsClientCapabilities = (LSClientCapabilities)context.languageServercontext().get(LSClientCapabilities.class);
        if (lsClientCapabilities.getInitializationOptions().isPositionalRefactorRenameSupported()) {
            codeAction.setCommand(new Command(command, "ballerina.action.positional.rename", List.of(context.fileUri(), renamePosition)));
        }
    }
}

