/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import com.google.gson.Gson;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.CodeActionManager;
import io.ballerina.projects.Document;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContextImpl;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContextImpl;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.CodeActionExtension;
import org.ballerinalang.langserver.commons.CodeActionResolveContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.codeaction.CodeActionData;
import org.ballerinalang.langserver.commons.codeaction.ResolvableCodeAction;
import org.ballerinalang.langserver.util.LSClientUtil;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CompilerPluginCodeActionExtension
implements CodeActionExtension {
    private final Gson gson = new Gson();

    public boolean validate(CodeActionParams inputParams) {
        return inputParams.getTextDocument().getUri().endsWith(".bal");
    }

    public List<? extends CodeAction> execute(CodeActionParams inputParams, CodeActionContext context, LanguageServerContext serverContext) {
        Optional packageCompilation = context.workspace().waitAndGetPackageCompilation(context.filePath());
        if (packageCompilation.isEmpty() || context.currentDocument().isEmpty() || context.currentSemanticModel().isEmpty()) {
            return Collections.emptyList();
        }
        LSClientCapabilities clientCapabilities = (LSClientCapabilities)serverContext.get(LSClientCapabilities.class);
        LSClientLogger clientLogger = LSClientLogger.getInstance(context.languageServercontext());
        if (!LSClientUtil.isCodeActionResolveSupported(clientCapabilities.getTextDocCapabilities())) {
            clientLogger.logTrace("Client doesn't support resolve code actions. Compiler plugin code actions disabled");
            return Collections.emptyList();
        }
        Position cursorPos = context.cursorPosition();
        LinePosition linePosition = LinePosition.from((int)cursorPos.getLine(), (int)cursorPos.getCharacter());
        Document document = (Document)context.currentDocument().get();
        SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().get();
        CodeActionManager codeActionManager = ((PackageCompilation)packageCompilation.get()).getCodeActionManager();
        return context.diagnostics(context.filePath()).stream().filter(diagnostic -> PositionUtil.isWithinRange(cursorPos, PositionUtil.toRange(diagnostic.location().lineRange()))).map(diagnostic -> {
            CodeActionContextImpl codeActionContext = CodeActionContextImpl.from((String)context.fileUri(), (Path)context.filePath(), (LinePosition)linePosition, (Document)document, (SemanticModel)semanticModel, (Diagnostic)diagnostic);
            return codeActionManager.codeActions((io.ballerina.projects.plugins.codeaction.CodeActionContext)codeActionContext);
        }).peek(codeActionResult -> codeActionResult.getErrors().forEach(ex -> clientLogger.logError(LSContextOperation.TXT_CODE_ACTION, "Exception thrown while getting code action: '%s'" + ex.getCodeActionName(), ex.getCause(), new TextDocumentIdentifier(context.fileUri()), new Position[0]))).flatMap(codeActionResult -> codeActionResult.getCodeActions().stream()).map(codeActionInfo -> {
            CodeActionData codeActionData = new CodeActionData(codeActionInfo.getProviderName(), context.fileUri(), new Range(cursorPos, cursorPos), (Object)codeActionInfo.getArguments());
            return CodeActionUtil.createResolvableCodeAction(codeActionInfo.getTitle(), "quickfix", codeActionData);
        }).toList();
    }

    public CodeAction resolve(ResolvableCodeAction codeAction, CodeActionResolveContext context) {
        Optional packageCompilation = context.workspace().waitAndGetPackageCompilation(context.filePath());
        if (packageCompilation.isEmpty() || context.currentDocument().isEmpty() || context.currentSemanticModel().isEmpty()) {
            return codeAction;
        }
        CodeActionData codeActionData = codeAction.getData();
        Optional<Path> filePath = PathUtil.getPathFromURI(codeActionData.getFileUri());
        if (filePath.isEmpty()) {
            return codeAction;
        }
        CodeActionManager codeActionManager = ((PackageCompilation)packageCompilation.get()).getCodeActionManager();
        String providerName = codeActionData.getCodeActionName();
        List actionData = (List)codeActionData.getActionData();
        List<CodeActionArgument> arguments = actionData.stream().map(arg_0 -> ((Gson)this.gson).toJsonTree(arg_0)).map(CodeActionArgument::from).toList();
        CodeActionExecutionContextImpl codeActionContext = CodeActionExecutionContextImpl.from((String)codeActionData.getFileUri(), (Path)filePath.get(), (LinePosition)PositionUtil.getLinePosition(codeActionData.getRange().getStart()), (Document)((Document)context.currentDocument().get()), (SemanticModel)((SemanticModel)context.currentSemanticModel().get()), arguments);
        List docEdits = codeActionManager.executeCodeAction(providerName, (CodeActionExecutionContext)codeActionContext);
        LinkedList edits = new LinkedList();
        docEdits.stream().map(docEdit -> this.toTextDocumentEdit((DocumentEdit)docEdit, context)).filter(Optional::isPresent).forEach(docEdit -> {
            Either either = Either.forLeft((Object)((TextDocumentEdit)docEdit.get()));
            edits.add(either);
        });
        codeAction.setEdit(new WorkspaceEdit(edits));
        return codeAction;
    }

    private Optional<TextDocumentEdit> toTextDocumentEdit(DocumentEdit docEdit, CodeActionResolveContext context) {
        Optional originalST = PathUtil.getPathFromURI(docEdit.getFileUri()).flatMap(editedFilePath -> context.workspace().document(editedFilePath)).flatMap(doc -> Optional.of(doc.syntaxTree()));
        if (originalST.isEmpty()) {
            return Optional.empty();
        }
        TextRange textRange = ((SyntaxTree)originalST.get()).rootNode().textRangeWithMinutiae();
        TextDocument textDocument = ((SyntaxTree)originalST.get()).textDocument();
        LinePosition startPos = textDocument.linePositionFrom(textRange.startOffset());
        LinePosition endPos = textDocument.linePositionFrom(textRange.endOffset());
        LineRange lineRange = LineRange.from((String)((SyntaxTree)originalST.get()).filePath(), (LinePosition)startPos, (LinePosition)endPos);
        Range range = PositionUtil.toRange(LineRange.from((String)docEdit.getFileUri(), (LinePosition)lineRange.startLine(), (LinePosition)lineRange.endLine()));
        TextEdit edit = new TextEdit(range, docEdit.getModifiedSyntaxTree().toSourceCode());
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(docEdit.getFileUri(), null), Collections.singletonList(edit));
        return Optional.of(textDocumentEdit);
    }
}

