/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.ConditionalExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FromClauseNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.tools.text.LineRange;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.PositionUtil;

public class MatchedExpressionNodeResolver
extends NodeTransformer<Optional<ExpressionNode>> {
    Node matchedNode;

    public MatchedExpressionNodeResolver(Node matchedNode) {
        this.matchedNode = matchedNode;
    }

    public Optional<ExpressionNode> findExpression(Node node) {
        if (node == null) {
            return Optional.empty();
        }
        Optional exprNode = (Optional)node.apply((NodeTransformer)this);
        return exprNode == null ? Optional.empty() : exprNode;
    }

    protected Optional<ExpressionNode> transformSyntaxNode(Node node) {
        if (node.parent() == null) {
            return Optional.empty();
        }
        return (Optional)node.parent().apply((NodeTransformer)this);
    }

    public Optional<ExpressionNode> transform(AssignmentStatementNode assignmentStatementNode) {
        return Optional.of(assignmentStatementNode.expression());
    }

    public Optional<ExpressionNode> transform(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        return moduleVariableDeclarationNode.initializer();
    }

    public Optional<ExpressionNode> transform(VariableDeclarationNode variableDeclarationNode) {
        return variableDeclarationNode.initializer();
    }

    public Optional<ExpressionNode> transform(PositionalArgumentNode positionalArgumentNode) {
        return Optional.of(positionalArgumentNode.expression());
    }

    public Optional<ExpressionNode> transform(NamedArgumentNode namedArgumentNode) {
        return Optional.of(namedArgumentNode.expression());
    }

    public Optional<ExpressionNode> transform(SpecificFieldNode specificFieldNode) {
        return specificFieldNode.valueExpr();
    }

    public Optional<ExpressionNode> transform(LetVariableDeclarationNode letVariableDeclarationNode) {
        return Optional.of(letVariableDeclarationNode.expression());
    }

    public Optional<ExpressionNode> transform(FromClauseNode fromClauseNode) {
        return Optional.of(fromClauseNode.expression());
    }

    public Optional<ExpressionNode> transform(BracedExpressionNode node) {
        return Optional.of(node);
    }

    public Optional<ExpressionNode> transform(ImplicitNewExpressionNode implicitNewExpressionNode) {
        return Optional.of(implicitNewExpressionNode);
    }

    public Optional<ExpressionNode> transform(ExplicitNewExpressionNode explicitNewExpressionNode) {
        return Optional.of(explicitNewExpressionNode);
    }

    public Optional<ExpressionNode> transform(ListConstructorExpressionNode listConstructorExpressionNode) {
        Optional<Node> expressionNode = listConstructorExpressionNode.expressions().stream().filter(expression -> this.matchedNode == expression).findFirst();
        if (expressionNode.isPresent() && expressionNode.get() instanceof ExpressionNode) {
            return Optional.of((ExpressionNode)expressionNode.get());
        }
        return Optional.empty();
    }

    public Optional<ExpressionNode> transform(BasicLiteralNode basicLiteralNode) {
        return Optional.of(basicLiteralNode);
    }

    public Optional<ExpressionNode> transform(ReturnStatementNode returnStatementNode) {
        return returnStatementNode.expression();
    }

    public Optional<ExpressionNode> transform(IndexedExpressionNode node) {
        if (PositionUtil.isWithinLineRange(this.matchedNode.lineRange(), node.containerExpression().lineRange())) {
            return Optional.of(node.containerExpression());
        }
        if (!node.keyExpression().isEmpty()) {
            for (ExpressionNode expressionNode : node.keyExpression()) {
                if (!PositionUtil.isWithinLineRange(this.matchedNode.lineRange(), expressionNode.lineRange())) continue;
                return Optional.of(expressionNode);
            }
        }
        return Optional.of(node);
    }

    public Optional<ExpressionNode> transform(ConditionalExpressionNode conditionalExpressionNode) {
        ExpressionNode lhsExpr = conditionalExpressionNode.lhsExpression();
        ExpressionNode middleExpr = conditionalExpressionNode.middleExpression();
        ExpressionNode endExpr = conditionalExpressionNode.endExpression();
        LineRange matchedLineRange = this.matchedNode.lineRange();
        if (PositionUtil.isWithinLineRange(matchedLineRange, lhsExpr.lineRange())) {
            return Optional.of(lhsExpr);
        }
        if (PositionUtil.isWithinLineRange(matchedLineRange, middleExpr.lineRange())) {
            return Optional.of(middleExpr);
        }
        if (PositionUtil.isWithinLineRange(matchedLineRange, endExpr.lineRange())) {
            return Optional.of(endExpr);
        }
        return Optional.of(conditionalExpressionNode);
    }

    public Optional<ExpressionNode> transform(BinaryExpressionNode binaryExpressionNode) {
        return Optional.of(binaryExpressionNode);
    }
}

