/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.langserver.common.ImportsAcceptor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.DefaultValueGenerationUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.model.Name;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public abstract class AbstractImplementMethodCodeAction {
    protected static final int DIAG_PROPERTY_NAME_INDEX = 0;
    protected static final int DIAG_PROPERTY_SYMBOL_INDEX = 1;
    protected static final Set<String> DIAGNOSTIC_CODES = Set.of(DiagnosticErrorCode.UNIMPLEMENTED_REFERENCED_METHOD_IN_CLASS.diagnosticId(), DiagnosticErrorCode.UNIMPLEMENTED_REFERENCED_METHOD_IN_SERVICE_DECL.diagnosticId(), DiagnosticErrorCode.UNIMPLEMENTED_REFERENCED_METHOD_IN_OBJECT_CTOR.diagnosticId());

    public static List<TextEdit> getDiagBasedTextEdits(DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional<String> defaultReturnValueForType;
        TypeSymbol returnTypeSymbol;
        String offsetStr;
        LinePosition editPosition;
        NodeList members;
        Optional methodName = positionDetails.diagnosticProperty(0);
        Optional optionalSymbol = positionDetails.diagnosticProperty(1);
        if (context.currentSyntaxTree().isEmpty() || methodName.isEmpty() || optionalSymbol.isEmpty()) {
            return Collections.emptyList();
        }
        TypeSymbol rawType = CommonUtil.getRawType((TypeSymbol)optionalSymbol.get());
        if (rawType.typeKind() != TypeDescKind.OBJECT) {
            return Collections.emptyList();
        }
        ObjectTypeSymbol classSymbol = (ObjectTypeSymbol)rawType;
        if (!classSymbol.methods().containsKey(((Name)methodName.get()).getValue())) {
            return Collections.emptyList();
        }
        Optional<NonTerminalNode> matchedNode = CommonUtil.findNode((Symbol)classSymbol, (SyntaxTree)context.currentSyntaxTree().get());
        if (matchedNode.isEmpty()) {
            return Collections.emptyList();
        }
        if (matchedNode.get().kind() == SyntaxKind.CLASS_DEFINITION) {
            ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)matchedNode.get();
            members = classDefinitionNode.members();
            editPosition = classDefinitionNode.closeBrace().lineRange().startLine();
        } else if (matchedNode.get().kind() == SyntaxKind.SERVICE_DECLARATION) {
            ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)matchedNode.get();
            members = serviceDeclarationNode.members();
            editPosition = serviceDeclarationNode.closeBraceToken().lineRange().startLine();
        } else if (matchedNode.get().kind() == SyntaxKind.OBJECT_CONSTRUCTOR) {
            ObjectConstructorExpressionNode objConstructor = (ObjectConstructorExpressionNode)matchedNode.get();
            members = objConstructor.members();
            editPosition = objConstructor.closeBraceToken().lineRange().startLine();
        } else {
            return Collections.emptyList();
        }
        MethodSymbol unimplMethod = (MethodSymbol)classSymbol.methods().get(((Name)methodName.get()).getValue());
        List<FunctionDefinitionNode> concreteMethods = members.stream().filter(member -> member.kind() == SyntaxKind.FUNCTION_DEFINITION).map(member -> (FunctionDefinitionNode)member).toList();
        int closeBraceOffset = editPosition.offset();
        Optional<Token> closeBraceToken = AbstractImplementMethodCodeAction.findCloseBraceTokenOfEnclosingNode((Node)matchedNode.get());
        int enclosingNodeOffset = closeBraceToken.map(token -> token.lineRange().startLine().offset()).orElse(0);
        if (!concreteMethods.isEmpty()) {
            FunctionDefinitionNode funcDefNode = concreteMethods.get(0);
            offsetStr = StringUtils.repeat((char)' ', (int)funcDefNode.location().lineRange().endLine().offset());
        } else if (matchedNode.get().kind() == SyntaxKind.OBJECT_CONSTRUCTOR) {
            offsetStr = StringUtils.repeat((char)' ', (int)(enclosingNodeOffset + 8));
            closeBraceOffset = enclosingNodeOffset + 4;
        } else {
            offsetStr = StringUtils.repeat((char)' ', (int)(matchedNode.get().location().lineRange().startLine().offset() + 4));
        }
        ImportsAcceptor importsAcceptor = new ImportsAcceptor((DocumentServiceContext)context);
        String typeName = FunctionGenerator.processModuleIDsInText(importsAcceptor, unimplMethod.signature(), (DocumentServiceContext)context);
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>(importsAcceptor.getNewImportTextEdits());
        Object returnStmt = "";
        if (unimplMethod.typeDescriptor().returnTypeDescriptor().isPresent() && (returnTypeSymbol = (TypeSymbol)unimplMethod.typeDescriptor().returnTypeDescriptor().get()).typeKind() != TypeDescKind.COMPILATION_ERROR && (defaultReturnValueForType = DefaultValueGenerationUtil.getDefaultValueForType(returnTypeSymbol)).isPresent()) {
            String defaultReturnValue = defaultReturnValueForType.get();
            returnStmt = defaultReturnValue.equals("()") ? "return;" : "return " + defaultReturnValue + ";";
        }
        int padding = 4;
        String paddingStr = StringUtils.repeat((String)" ", (int)padding);
        StringBuilder editText = new StringBuilder();
        editText.append(CommonUtil.LINE_SEPARATOR).append(offsetStr).append(typeName).append(" ").append("{").append(CommonUtil.LINE_SEPARATOR).append(offsetStr).append(paddingStr).append((String)returnStmt).append(CommonUtil.LINE_SEPARATOR).append(offsetStr).append("}").append(CommonUtil.LINE_SEPARATOR).append(StringUtils.repeat((char)' ', (int)closeBraceOffset));
        Position editPos = PositionUtil.toPosition(editPosition);
        edits.add(new TextEdit(new Range(editPos, editPos), editText.toString()));
        return edits;
    }

    protected static Optional<Token> findCloseBraceTokenOfEnclosingNode(Node node) {
        for (NonTerminalNode referenceNode = node.parent(); referenceNode != null; referenceNode = referenceNode.parent()) {
            if (referenceNode.kind() == SyntaxKind.FUNCTION_BODY_BLOCK) {
                return Optional.of(((FunctionBodyBlockNode)referenceNode).closeBraceToken());
            }
            if (referenceNode.kind() != SyntaxKind.BLOCK_STATEMENT) continue;
            return Optional.of(((BlockStatementNode)referenceNode).closeBraceToken());
        }
        return Optional.empty();
    }
}

