/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.DefaultValueGenerationUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class AddConditionalDefaultValueCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Add conditional default value";
    public static final String DIAGNOSTIC_CODES = "BCE2066";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return context.currentSemanticModel().isPresent() && DIAGNOSTIC_CODES.equals(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional actualTypeSymbol = positionDetails.diagnosticProperty(1);
        Optional expectedTypeSymbol = positionDetails.diagnosticProperty(0);
        if (expectedTypeSymbol.isEmpty() || actualTypeSymbol.isEmpty() || !this.isOptionalType((TypeSymbol)actualTypeSymbol.get(), context)) {
            return Collections.emptyList();
        }
        Optional<TypeSymbol> typeWithoutOptional = this.getTypeWithoutOptional((TypeSymbol)actualTypeSymbol.get(), context);
        if (typeWithoutOptional.isEmpty() || !typeWithoutOptional.get().subtypeOf((TypeSymbol)expectedTypeSymbol.get())) {
            return Collections.emptyList();
        }
        Optional<String> defaultValue = DefaultValueGenerationUtil.getDefaultValueForType(typeWithoutOptional.get());
        if (defaultValue.isEmpty()) {
            return Collections.emptyList();
        }
        NonTerminalNode matchedNode = positionDetails.matchedNode();
        Position endPosition = PositionUtil.toPosition(matchedNode.lineRange().endLine());
        String editText = " ?: " + defaultValue.get();
        TextEdit textEdit = new TextEdit(new Range(endPosition, endPosition), editText);
        return Collections.singletonList(CodeActionUtil.createCodeAction(NAME, List.of(textEdit), context.fileUri(), "quickfix"));
    }

    private Optional<TypeSymbol> getTypeWithoutOptional(TypeSymbol actualType, CodeActionContext context) {
        Optional semanticModel = context.currentSemanticModel();
        if (actualType.typeKind() != TypeDescKind.UNION || semanticModel.isEmpty()) {
            return Optional.empty();
        }
        List<TypeSymbol> memberTypes = ((UnionTypeSymbol)actualType).memberTypeDescriptors().stream().filter(typeSymbol -> typeSymbol.typeKind() != TypeDescKind.NIL).toList();
        UnionTypeSymbol unionType = ((SemanticModel)semanticModel.get()).types().builder().UNION_TYPE.withMemberTypes((TypeSymbol[])memberTypes.toArray(TypeSymbol[]::new)).build();
        return Optional.of(unionType);
    }

    private boolean isOptionalType(TypeSymbol typeSymbol, CodeActionContext context) {
        TypeSymbol nilType = ((SemanticModel)context.currentSemanticModel().get()).types().NIL;
        return nilType.subtypeOf(typeSymbol);
    }

    public String getName() {
        return NAME;
    }
}

