/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.tools.text.LinePosition;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.ConfigurableFinder;
import org.ballerinalang.langserver.common.utils.ConfigTomlValueGenerationUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class AddToConfigTomlCodeAction
implements RangeBasedCodeActionProvider {
    private static final String CONFIG_TOML = "Config.toml";

    public List<SyntaxKind> getSyntaxKinds() {
        return List.of(SyntaxKind.MODULE_VAR_DECL);
    }

    public boolean validate(CodeActionContext context, RangeBasedPositionDetails positionDetails) {
        return context.currentModule().isPresent() && AddToConfigTomlCodeAction.hasConfigurableQualifier((ModuleVariableDeclarationNode)positionDetails.matchedCodeActionNode());
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        int lastNodeLine;
        if (context.currentModule().isEmpty()) {
            return Collections.emptyList();
        }
        Module module = (Module)context.currentModule().get();
        Project project = module.project();
        if (project.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
            return Collections.emptyList();
        }
        String orgName = project.currentPackage().packageOrg().value();
        SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().get();
        Types types = semanticModel.types();
        TypeBuilder builder = types.builder();
        UnionTypeSymbol basicType = builder.UNION_TYPE.withMemberTypes(new TypeSymbol[]{types.INT, types.STRING, types.BOOLEAN, types.BYTE, types.FLOAT, types.DECIMAL, types.XML}).build();
        UnionTypeSymbol anyDataOrJsonType = builder.UNION_TYPE.withMemberTypes(new TypeSymbol[]{types.ANYDATA, types.JSON}).build();
        Optional confSymbol = semanticModel.symbol((Node)posDetails.matchedCodeActionNode());
        if (confSymbol.isEmpty()) {
            return Collections.emptyList();
        }
        ConfigurableFinder.ModuleConfigDetails moduleConfigDetails = ConfigurableFinder.getModuleConfigDetails(context);
        Map<String, ConfigurableFinder.ConfigVariable> configVarMap = moduleConfigDetails.configVariables();
        VariableSymbol variableSymbol = (VariableSymbol)confSymbol.get();
        ConfigurableFinder.ConfigVariable selectedConf = configVarMap.get(variableSymbol.getName().get());
        Path configTomlPath = context.workspace().projectRoot(context.filePath()).resolve(CONFIG_TOML);
        if (!configTomlPath.toFile().exists()) {
            if (configVarMap.isEmpty()) {
                return Collections.emptyList();
            }
            return AddToConfigTomlCodeAction.withoutConfigTomlCodeActions((TypeSymbol)basicType, (TypeSymbol)anyDataOrJsonType, moduleConfigDetails, selectedConf, configTomlPath);
        }
        Optional<Toml> toml = AddToConfigTomlCodeAction.readToml(configTomlPath);
        if (toml.isEmpty() || configVarMap.isEmpty()) {
            return Collections.emptyList();
        }
        int n = lastNodeLine = module.isDefaultModule() ? AddToConfigTomlCodeAction.rootModuleConfigDiff(toml.get(), orgName, module.moduleName().toString(), configVarMap) : AddToConfigTomlCodeAction.nonRootModuleConfigDiff(toml.get(), orgName, module.moduleName(), configVarMap);
        if (!configVarMap.containsKey(selectedConf.name())) {
            return Collections.emptyList();
        }
        return this.getWithConfigTomlCodeActions((TypeSymbol)basicType, (TypeSymbol)anyDataOrJsonType, moduleConfigDetails, selectedConf, configTomlPath, toml.get(), module, lastNodeLine);
    }

    private List<CodeAction> getWithConfigTomlCodeActions(TypeSymbol basicType, TypeSymbol anyDataOrJsonType, ConfigurableFinder.ModuleConfigDetails moduleConfigDetails, ConfigurableFinder.ConfigVariable selectedConf, Path configTomlPath, Toml toml, Module module, int lastNodeLine) {
        CodeAction codeAction;
        TextEdit textEdit;
        boolean hasAtLeastOneEntry = lastNodeLine > 0;
        Position position = AddToConfigTomlCodeAction.getTomlInsertPosition(toml, module, lastNodeLine);
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        if (selectedConf.isRequired()) {
            textEdit = new TextEdit(new Range(position, position), AddToConfigTomlCodeAction.getEdits(moduleConfigDetails, basicType, anyDataOrJsonType, hasAtLeastOneEntry));
            codeAction = CodeActionUtil.createCodeAction("Add all to Config.toml", List.of(textEdit), configTomlPath.toUri().getPath());
            codeActions.add(codeAction);
        }
        textEdit = new TextEdit(new Range(position, position), AddToConfigTomlCodeAction.getTableEntryEdit(selectedConf, basicType, anyDataOrJsonType));
        codeAction = CodeActionUtil.createCodeAction("Add to Config.toml", List.of(textEdit), configTomlPath.toUri().getPath());
        codeActions.add(codeAction);
        return codeActions;
    }

    private static Position getTomlInsertPosition(Toml toml, Module module, int lastNodeLine) {
        if (lastNodeLine == 0 && !module.isDefaultModule()) {
            Map entries = toml.rootNode().entries();
            for (TopLevelNode node : entries.values()) {
                int nodeLine = node.location().lineRange().endLine().line();
                if (nodeLine <= lastNodeLine) continue;
                lastNodeLine = nodeLine;
            }
            lastNodeLine = lastNodeLine == 0 ? 0 : lastNodeLine + 3;
        } else {
            lastNodeLine = lastNodeLine == 0 ? 0 : lastNodeLine + 1;
        }
        return PositionUtil.toPosition(LinePosition.from((int)lastNodeLine, (int)0));
    }

    private static List<CodeAction> withoutConfigTomlCodeActions(TypeSymbol basicType, TypeSymbol anyDataOrJsonType, ConfigurableFinder.ModuleConfigDetails moduleConfigDetails, ConfigurableFinder.ConfigVariable selectedConf, Path configTomlPath) {
        CodeAction codeAction;
        String newText;
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        if (selectedConf.isRequired()) {
            newText = AddToConfigTomlCodeAction.getEdits(moduleConfigDetails, basicType, anyDataOrJsonType);
            codeAction = CodeActionUtil.createCodeAction("Add all to Config.toml", new Command("Add to Config.toml", "create.config.toml", List.of(configTomlPath.toString(), newText)), "");
            codeActions.add(codeAction);
        }
        newText = AddToConfigTomlCodeAction.getTableEntryEdit(selectedConf, basicType, anyDataOrJsonType);
        codeAction = CodeActionUtil.createCodeAction("Add to Config.toml", new Command("Add to Config.toml", "create.config.toml", List.of(configTomlPath.toString(), newText)), "");
        codeActions.add(codeAction);
        return codeActions;
    }

    private static String getEdits(ConfigurableFinder.ModuleConfigDetails moduleConfigDetails, TypeSymbol basicType, TypeSymbol anydataOrJson) {
        return AddToConfigTomlCodeAction.getEdits(moduleConfigDetails, basicType, anydataOrJson, false);
    }

    private static String getEdits(ConfigurableFinder.ModuleConfigDetails moduleConfigDetails, TypeSymbol basicType, TypeSymbol anydataOrJson, boolean hasAtLeastOneEntry) {
        StringBuilder basicKeyValueBuilder = new StringBuilder();
        StringBuilder complexValueBuilder = new StringBuilder();
        if (!moduleConfigDetails.isDefaultModule() && !hasAtLeastOneEntry) {
            basicKeyValueBuilder.append(String.format("[%s]%n", moduleConfigDetails.moduleName()));
        }
        moduleConfigDetails.configVariables().values().stream().sorted().forEach(variable -> {
            if (variable.isRequired()) {
                ConfigTomlValueGenerationUtil.TomlEntryValue tableEntry = ConfigTomlValueGenerationUtil.getDefaultValueStr(variable.type(), basicType, anydataOrJson, variable.name());
                if (tableEntry.keyValue()) {
                    basicKeyValueBuilder.append(String.format("%s = %s%n", variable.name(), tableEntry.value()));
                } else {
                    complexValueBuilder.append(String.format("%n%s%n", tableEntry.value()));
                }
            }
        });
        basicKeyValueBuilder.append((CharSequence)complexValueBuilder);
        return basicKeyValueBuilder.toString();
    }

    private static String getTableEntryEdit(ConfigurableFinder.ConfigVariable variable, TypeSymbol basicType, TypeSymbol anydataOrJson) {
        ConfigTomlValueGenerationUtil.TomlEntryValue defaultValueStr = ConfigTomlValueGenerationUtil.getDefaultValueStr(variable.type(), basicType, anydataOrJson, variable.name());
        return defaultValueStr.keyValue() ? String.format("%s = %s%n", variable.name(), defaultValueStr.value()) : String.format("%n%s%n", defaultValueStr.value());
    }

    private static int rootModuleConfigDiff(Toml baseToml, String orgName, String moduleName, Map<String, ConfigurableFinder.ConfigVariable> configVariables) {
        String orgModuleKey = orgName + "." + moduleName;
        Optional table = baseToml.getTable(orgModuleKey);
        table.ifPresent(toml -> AddToConfigTomlCodeAction.configDiff(configVariables, toml.rootNode()));
        table = baseToml.getTable(moduleName);
        table.ifPresent(toml -> AddToConfigTomlCodeAction.configDiff(configVariables, toml.rootNode()));
        return AddToConfigTomlCodeAction.configDiff(configVariables, baseToml.rootNode());
    }

    private static int nonRootModuleConfigDiff(Toml baseToml, String orgName, ModuleName moduleName, Map<String, ConfigurableFinder.ConfigVariable> configVariables) {
        String moduleNameStr = moduleName.toString();
        String orgModuleKey = orgName + "." + moduleNameStr;
        Optional table = baseToml.getTable(orgModuleKey);
        table.ifPresent(toml -> AddToConfigTomlCodeAction.configDiff(configVariables, toml.rootNode()));
        table = baseToml.getTable(moduleNameStr);
        table.ifPresent(toml -> AddToConfigTomlCodeAction.configDiff(configVariables, toml.rootNode()));
        table = baseToml.getTable(moduleName.moduleNamePart());
        return table.map(toml -> AddToConfigTomlCodeAction.configDiff(configVariables, toml.rootNode())).orElse(0);
    }

    private static int configDiff(Map<String, ConfigurableFinder.ConfigVariable> configVariables, TomlTableNode moduleNode) {
        int lastNodeLine = 0;
        for (Map.Entry entry : moduleNode.entries().entrySet()) {
            if (((TopLevelNode)entry.getValue()).kind() == TomlType.KEY_VALUE) {
                lastNodeLine = ((TopLevelNode)entry.getValue()).location().lineRange().endLine().line();
            }
            configVariables.remove(entry.getKey());
        }
        return lastNodeLine;
    }

    private static boolean hasConfigurableQualifier(ModuleVariableDeclarationNode node) {
        return node.qualifiers().stream().anyMatch(q -> q.text().equals(Qualifier.CONFIGURABLE.getValue()));
    }

    private static Optional<Toml> readToml(Path path) {
        try {
            return Optional.ofNullable(Toml.read((Path)path));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public String getName() {
        return "Add to Config.toml";
    }
}

