/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class ExtractToConstantCodeAction
implements RangeBasedCodeActionProvider {
    public static final String NAME = "extract to constant";
    private static final String CONSTANT_NAME_PREFIX = "CONST";
    private static final String EXTRACT_COMMAND = "ballerina.action.extract";
    private static final List<TypeDescKind> EXPLICIT_TYPES = List.of(TypeDescKind.DECIMAL, TypeDescKind.FLOAT, TypeDescKind.BYTE);

    public List<SyntaxKind> getSyntaxKinds() {
        return List.of(SyntaxKind.BOOLEAN_LITERAL, SyntaxKind.NUMERIC_LITERAL, SyntaxKind.STRING_LITERAL, SyntaxKind.BINARY_EXPRESSION, SyntaxKind.UNARY_EXPRESSION);
    }

    public boolean validate(CodeActionContext context, RangeBasedPositionDetails positionDetails) {
        NonTerminalNode node = positionDetails.matchedCodeActionNode();
        SyntaxKind parentKind = node.parent().kind();
        return context.currentSyntaxTree().isPresent() && context.currentSemanticModel().isPresent() && parentKind != SyntaxKind.CONST_DECLARATION && parentKind != SyntaxKind.INVALID_EXPRESSION_STATEMENT && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        NonTerminalNode node = posDetails.matchedCodeActionNode();
        BasicLiteralNodeValidator nodeValidator = new BasicLiteralNodeValidator();
        node.accept((NodeVisitor)nodeValidator);
        if (nodeValidator.getInvalidNode().booleanValue()) {
            return Collections.emptyList();
        }
        String constName = this.getConstantName(context);
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return Collections.emptyList();
        }
        Optional typeSymbol = ((SemanticModel)semanticModel.get()).typeOf((Node)node);
        if (typeSymbol.isEmpty() || ((TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.COMPILATION_ERROR || ((TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return Collections.emptyList();
        }
        ConstantData constantData = this.getConstantData(context);
        Position constDeclPosition = constantData.getPosition();
        boolean addNewLineAtStart = constantData.isAddNewLineAtStart();
        List<TextEdit> textEdits = this.getTextEdits((Node)node, (TypeSymbol)typeSymbol.get(), constName, constDeclPosition, addNewLineAtStart);
        LSClientCapabilities lsClientCapabilities = (LSClientCapabilities)context.languageServercontext().get(LSClientCapabilities.class);
        if (ExtractToConstantCodeAction.isRange(context.range()) || !lsClientCapabilities.getInitializationOptions().isQuickPickSupported()) {
            CodeAction codeAction = CodeActionUtil.createCodeAction("Extract to constant", textEdits, context.fileUri(), "refactor.extract");
            CodeActionUtil.addRenamePopup(context, codeAction, "Rename constant", this.getRenamePosition(textEdits.get(1).getRange(), addNewLineAtStart));
            return Collections.singletonList(codeAction);
        }
        List<Node> nodeList = this.getPossibleExpressionNodes((Node)node, nodeValidator);
        if (nodeList.size() == 1) {
            CodeAction codeAction = CodeActionUtil.createCodeAction("Extract to constant", textEdits, context.fileUri(), "refactor.extract");
            CodeActionUtil.addRenamePopup(context, codeAction, "Rename constant", this.getRenamePosition(textEdits.get(1).getRange(), addNewLineAtStart));
            return Collections.singletonList(codeAction);
        }
        LinkedHashMap textEditMap = new LinkedHashMap();
        nodeList.forEach(extractableNode -> textEditMap.put(extractableNode.toSourceCode().strip(), this.getTextEdits((Node)extractableNode, (TypeSymbol)typeSymbol.get(), constName, constDeclPosition, addNewLineAtStart)));
        if (lsClientCapabilities.getInitializationOptions().isPositionalRefactorRenameSupported()) {
            LinkedHashMap renamePositionMap = new LinkedHashMap();
            nodeList.forEach(extractableNode -> renamePositionMap.put(extractableNode.toSourceCode().strip(), this.getRenamePosition(PositionUtil.toRange(extractableNode.lineRange()), addNewLineAtStart)));
            return Collections.singletonList(CodeActionUtil.createCodeAction("Extract to constant", new Command(NAME, EXTRACT_COMMAND, List.of(NAME, context.filePath().toString(), textEditMap, renamePositionMap)), "refactor.extract"));
        }
        return Collections.singletonList(CodeActionUtil.createCodeAction("Extract to constant", new Command(NAME, EXTRACT_COMMAND, List.of(NAME, context.filePath().toString(), textEditMap)), "refactor.extract"));
    }

    private List<Node> getPossibleExpressionNodes(Node node, BasicLiteralNodeValidator nodeValidator) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        while (node != null && !this.isExpressionNode(node) && node.kind() != SyntaxKind.OBJECT_FIELD && !nodeValidator.getInvalidNode().booleanValue()) {
            nodeList.add(node);
            node = node.parent();
            node.accept((NodeVisitor)nodeValidator);
        }
        return nodeList;
    }

    private boolean isExpressionNode(Node node) {
        return node instanceof StatementNode || node instanceof ModuleMemberDeclarationNode;
    }

    private Position getRenamePosition(Range range, boolean addNewLineAtStart) {
        int line = range.getEnd().getLine() + 1;
        if (addNewLineAtStart) {
            ++line;
        }
        return new Position(line, range.getStart().getCharacter());
    }

    public String getName() {
        return NAME;
    }

    private List<TextEdit> getTextEdits(Node node, TypeSymbol typeSymbol, String constName, Position constDeclPos, boolean newLineAtStart) {
        Object typeName = "";
        int index = EXPLICIT_TYPES.indexOf(typeSymbol.typeKind());
        if (index != -1) {
            typeName = EXPLICIT_TYPES.get(index).getName() + " ";
        }
        String value = node.toSourceCode().strip();
        LineRange replaceRange = node.lineRange();
        Object constDeclStr = "";
        if (newLineAtStart) {
            constDeclStr = (String)constDeclStr + String.format("%n", new Object[0]);
        }
        constDeclStr = String.format((String)constDeclStr + "const %s%s = %s;%n", typeName, constName, value);
        TextEdit constDeclEdit = new TextEdit(new Range(constDeclPos, constDeclPos), (String)constDeclStr);
        TextEdit replaceEdit = new TextEdit(new Range(PositionUtil.toPosition(replaceRange.startLine()), PositionUtil.toPosition(replaceRange.endLine())), constName);
        return List.of(constDeclEdit, replaceEdit);
    }

    private static boolean isRange(Range range) {
        return !range.getStart().equals((Object)range.getEnd());
    }

    private String getConstantName(CodeActionContext context) {
        Position pos = context.range().getEnd();
        Set<String> allNames = context.visibleSymbols(new Position(pos.getLine(), pos.getCharacter())).stream().map(Symbol::getName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        return NameUtil.generateTypeName(CONSTANT_NAME_PREFIX, allNames);
    }

    private ConstantData getConstantData(CodeActionContext context) {
        ModulePartNode modulePartNode = (ModulePartNode)((SyntaxTree)context.currentSyntaxTree().get()).rootNode();
        NodeList importsList = modulePartNode.imports();
        ConstantDeclarationNode declarationNode = null;
        for (Node node : modulePartNode.children()) {
            if (node.kind() != SyntaxKind.CONST_DECLARATION) continue;
            declarationNode = (ConstantDeclarationNode)node;
            break;
        }
        if (importsList.isEmpty()) {
            return new ConstantData(PositionUtil.toPosition(modulePartNode.lineRange().startLine()), false);
        }
        if (declarationNode == null) {
            ImportDeclarationNode lastImport = (ImportDeclarationNode)importsList.get(importsList.size() - 1);
            return new ConstantData(new Position(lastImport.lineRange().endLine().line() + 1, 0), true);
        }
        return new ConstantData(new Position(declarationNode.lineRange().startLine().line(), 0), !declarationNode.toString().startsWith(System.lineSeparator()));
    }

    static class BasicLiteralNodeValidator
    extends NodeVisitor {
        private boolean invalidNode = false;

        BasicLiteralNodeValidator() {
        }

        public void visit(BinaryExpressionNode node) {
            node.lhsExpr().accept((NodeVisitor)this);
            node.rhsExpr().accept((NodeVisitor)this);
        }

        public void visit(BasicLiteralNode node) {
        }

        public void visit(UnaryExpressionNode node) {
        }

        protected void visitSyntaxNode(Node node) {
            this.invalidNode = true;
        }

        public Boolean getInvalidNode() {
            return this.invalidNode;
        }
    }

    private static class ConstantData {
        Position position;
        boolean addNewLineAtStart;

        public ConstantData(Position position, boolean addNewLineAtStart) {
            this.position = position;
            this.addNewLineAtStart = addNewLineAtStart;
        }

        public Position getPosition() {
            return this.position;
        }

        public boolean isAddNewLineAtStart() {
            return this.addNewLineAtStart;
        }
    }
}

