/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.ExpressionNodeValidator;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class ExtractToLocalVarCodeAction
implements RangeBasedCodeActionProvider {
    public static final String NAME = "Extract To Local Variable";
    private static final String VARIABLE_NAME_PREFIX = "var";

    public List<SyntaxKind> getSyntaxKinds() {
        return List.of(SyntaxKind.BOOLEAN_LITERAL, SyntaxKind.NUMERIC_LITERAL, SyntaxKind.STRING_LITERAL, SyntaxKind.BINARY_EXPRESSION, SyntaxKind.BRACED_EXPRESSION, SyntaxKind.XML_TEMPLATE_EXPRESSION, SyntaxKind.FUNCTION_CALL, SyntaxKind.QUALIFIED_NAME_REFERENCE, SyntaxKind.INDEXED_EXPRESSION, SyntaxKind.FIELD_ACCESS, SyntaxKind.METHOD_CALL, SyntaxKind.CHECK_EXPRESSION, SyntaxKind.LET_EXPRESSION, SyntaxKind.MAPPING_CONSTRUCTOR, SyntaxKind.TYPEOF_EXPRESSION, SyntaxKind.UNARY_EXPRESSION, SyntaxKind.TYPE_TEST_EXPRESSION, SyntaxKind.TRAP_EXPRESSION, SyntaxKind.LIST_CONSTRUCTOR, SyntaxKind.TYPE_CAST_EXPRESSION, SyntaxKind.TABLE_CONSTRUCTOR, SyntaxKind.IMPLICIT_NEW_EXPRESSION, SyntaxKind.EXPLICIT_NEW_EXPRESSION, SyntaxKind.ERROR_CONSTRUCTOR, SyntaxKind.QUERY_EXPRESSION);
    }

    public boolean validate(CodeActionContext context, RangeBasedPositionDetails positionDetails) {
        NonTerminalNode node = positionDetails.matchedCodeActionNode();
        NonTerminalNode parentNode = node.parent();
        SyntaxKind nodeKind = node.kind();
        SyntaxKind parentKind = parentNode.kind();
        return !(!context.currentSyntaxTree().isPresent() || !context.currentSemanticModel().isPresent() || nodeKind == SyntaxKind.MAPPING_CONSTRUCTOR && parentKind == SyntaxKind.TABLE_CONSTRUCTOR || nodeKind == SyntaxKind.FUNCTION_CALL && parentKind == SyntaxKind.LOCAL_VAR_DECL || (nodeKind == SyntaxKind.FUNCTION_CALL || nodeKind == SyntaxKind.METHOD_CALL) && parentKind == SyntaxKind.CALL_STATEMENT || parentKind == SyntaxKind.CONST_DECLARATION || parentKind == SyntaxKind.ASSIGNMENT_STATEMENT && ((AssignmentStatementNode)parentNode).varRef().equals(node) || nodeKind == SyntaxKind.QUALIFIED_NAME_REFERENCE && parentKind == SyntaxKind.FUNCTION_CALL || parentKind == SyntaxKind.RECORD_FIELD_WITH_DEFAULT_VALUE || parentKind == SyntaxKind.ENUM_MEMBER || nodeKind == SyntaxKind.FUNCTION_CALL && parentKind == SyntaxKind.START_ACTION || parentKind == SyntaxKind.MATCH_CLAUSE || !CodeActionNodeValidator.validate(context.nodeAtRange()));
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        NonTerminalNode node = posDetails.matchedCodeActionNode();
        if (this.isNotExtractable((Node)node, context)) {
            return Collections.emptyList();
        }
        Optional typeSymbol = ((SemanticModel)context.currentSemanticModel().get()).typeOf((Node)node);
        if (typeSymbol.isEmpty() || ((TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.COMPILATION_ERROR) {
            return Collections.emptyList();
        }
        Node statementNode = this.getStatementNode((Node)node);
        if (statementNode == null || statementNode.kind() == SyntaxKind.OBJECT_FIELD) {
            return Collections.emptyList();
        }
        LSClientCapabilities lsClientCapabilities = (LSClientCapabilities)context.languageServercontext().get(LSClientCapabilities.class);
        if (CodeActionUtil.isRangeSelection(context.range()) || !lsClientCapabilities.getInitializationOptions().isQuickPickSupported()) {
            List<TextEdit> textEdits = this.getTextEdits(context, (TypeSymbol)typeSymbol.get(), (Node)node, statementNode);
            CodeAction codeAction = CodeActionUtil.createCodeAction("Extract to local variable", textEdits, context.fileUri(), "refactor.extract");
            CodeActionUtil.addRenamePopup(context, codeAction, "Rename variable", this.getRenamePosition(textEdits.get(1).getRange()));
            return Collections.singletonList(codeAction);
        }
        ExpressionNodeValidator nodeValidator = new ExpressionNodeValidator();
        node.accept((NodeVisitor)nodeValidator);
        if (nodeValidator.isInvalidNode().booleanValue()) {
            return Collections.emptyList();
        }
        List<Node> nodeList = ExtractToLocalVarCodeAction.getPossibleExpressionNodes((Node)node);
        LinkedHashMap textEditMap = new LinkedHashMap();
        LinkedHashMap renamePositionMap = new LinkedHashMap();
        nodeList.forEach(extractableNode -> {
            Optional tSymbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf(extractableNode));
            if (tSymbol.isEmpty() || ((TypeSymbol)tSymbol.get()).typeKind() == TypeDescKind.COMPILATION_ERROR) {
                return;
            }
            String key = extractableNode.toSourceCode().strip();
            textEditMap.put(key, this.getTextEdits(context, (TypeSymbol)tSymbol.get(), (Node)extractableNode, statementNode));
            renamePositionMap.put(key, this.getRenamePosition(PositionUtil.toRange(extractableNode.lineRange())));
        });
        if (lsClientCapabilities.getInitializationOptions().isPositionalRefactorRenameSupported()) {
            return Collections.singletonList(CodeActionUtil.createCodeAction("Extract to local variable", new Command(NAME, "ballerina.action.extract", List.of(NAME, context.filePath().toString(), textEditMap, renamePositionMap)), "refactor.extract"));
        }
        return Collections.singletonList(CodeActionUtil.createCodeAction("Extract to local variable", new Command(NAME, "ballerina.action.extract", List.of(NAME, context.filePath().toString(), textEditMap)), "refactor.extract"));
    }

    private List<TextEdit> getTextEdits(CodeActionContext context, TypeSymbol typeSymbol, Node matchedNode, Node statementNode) {
        String varName = this.getLocalVarName(context);
        String value = matchedNode.toSourceCode().strip();
        LineRange replaceRange = matchedNode.lineRange();
        String paddingStr = StringUtils.repeat((String)" ", (int)statementNode.lineRange().startLine().offset());
        String typeDescriptor = FunctionGenerator.getReturnTypeAsString((DocumentServiceContext)context, typeSymbol.signature());
        String varDeclStr = String.format("%s %s = %s;%n%s", typeDescriptor, varName, value, paddingStr);
        Position varDeclPos = new Position(statementNode.lineRange().startLine().line(), statementNode.lineRange().startLine().offset());
        TextEdit varDeclEdit = new TextEdit(new Range(varDeclPos, varDeclPos), varDeclStr);
        TextEdit replaceEdit = new TextEdit(new Range(PositionUtil.toPosition(replaceRange.startLine()), PositionUtil.toPosition(replaceRange.endLine())), varName);
        return List.of(varDeclEdit, replaceEdit);
    }

    private Position getRenamePosition(Range range) {
        return new Position(range.getEnd().getLine() + 1, range.getStart().getCharacter());
    }

    private static List<Node> getPossibleExpressionNodes(Node node) {
        ExpressionNodeValidator nodeValidator = new ExpressionNodeValidator();
        ArrayList<Node> nodeList = new ArrayList<Node>();
        while (node != null && !ExtractToLocalVarCodeAction.isStatementOrModuleDeclaration(node) && node.kind() != SyntaxKind.OBJECT_FIELD && !nodeValidator.isInvalidNode().booleanValue()) {
            nodeList.add(node);
            node = node.parent();
            node.accept((NodeVisitor)nodeValidator);
        }
        return nodeList;
    }

    private static boolean isStatementOrModuleDeclaration(Node node) {
        return node instanceof StatementNode || node instanceof ModuleMemberDeclarationNode;
    }

    public String getName() {
        return NAME;
    }

    private Node getStatementNode(Node node) {
        Node statementNode;
        for (statementNode = node; statementNode != null && !(statementNode instanceof StatementNode) && !(statementNode instanceof ModuleMemberDeclarationNode) && statementNode.kind() != SyntaxKind.OBJECT_FIELD; statementNode = statementNode.parent()) {
        }
        return statementNode;
    }

    private String getLocalVarName(CodeActionContext context) {
        Set<String> allNames = context.visibleSymbols(context.range().getEnd()).stream().map(Symbol::getName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        return NameUtil.generateTypeName(VARIABLE_NAME_PREFIX, allNames);
    }

    private boolean isNotExtractable(Node matchedNode, CodeActionContext context) {
        List<Symbol> symbolsWithinRange = this.getVisibleSymbols(context, PositionUtil.toPosition(matchedNode.lineRange().endLine())).stream().filter(symbol -> (symbol.kind() == SymbolKind.VARIABLE || symbol.kind() == SymbolKind.PARAMETER) && ((SemanticModel)context.currentSemanticModel().get()).references(symbol).stream().anyMatch(location -> PositionUtil.isWithinLineRange(location.lineRange(), matchedNode.lineRange()))).filter(symbol -> symbol.getLocation().isPresent() && PositionUtil.isWithinLineRange(((Location)symbol.getLocation().get()).lineRange(), this.getStatementNode(matchedNode).lineRange())).toList();
        if (symbolsWithinRange.isEmpty()) {
            return false;
        }
        return symbolsWithinRange.stream().noneMatch(symbol -> symbol.getLocation().isPresent() && PositionUtil.isWithinLineRange(((Location)symbol.getLocation().get()).lineRange(), matchedNode.lineRange()));
    }

    @Deprecated(forRemoval=true)
    private List<Symbol> getVisibleSymbols(CodeActionContext context, Position position) {
        return ((SemanticModel)context.currentSemanticModel().get()).visibleSymbols((Document)context.currentDocument().get(), PositionUtil.getLinePosition(position));
    }
}

