/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.common.utils.RecordUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class ExtractToTransformFunctionCodeAction
implements RangeBasedCodeActionProvider {
    private static final String NAME = "extract to transform function";
    private static final String EXTRACTED_PREFIX = "transform";

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        Document currentDocument;
        Node enclosingNode;
        OutputRecord outputRecord;
        InputType inputType;
        SemanticModel semanticModel;
        ExpressionNode valueExprNode;
        try {
            SpecificFieldNode specificFieldNode;
            NonTerminalNode matchedCodeActionNode = posDetails.matchedCodeActionNode();
            if (matchedCodeActionNode.kind() == SyntaxKind.SPECIFIC_FIELD) {
                specificFieldNode = (SpecificFieldNode)matchedCodeActionNode;
                valueExprNode = (ExpressionNode)specificFieldNode.valueExpr().orElseThrow();
            } else {
                specificFieldNode = (SpecificFieldNode)matchedCodeActionNode.parent();
                valueExprNode = (ExpressionNode)matchedCodeActionNode;
            }
            semanticModel = (SemanticModel)context.currentSemanticModel().orElseThrow();
            TypeSymbol matchedTypeSymbol = posDetails.matchedTopLevelTypeSymbol();
            TypeSymbol inputSymbol = matchedTypeSymbol == null ? (Symbol)semanticModel.symbol(context.nodeAtRange()).orElseThrow() : matchedTypeSymbol;
            inputType = ExtractToTransformFunctionCodeAction.getInputRecord(context, (Symbol)inputSymbol).orElseThrow();
            Symbol outputRecordSymbol = (Symbol)semanticModel.symbol(specificFieldNode.fieldName()).orElseThrow();
            outputRecord = ExtractToTransformFunctionCodeAction.getOutputRecord(context, outputRecordSymbol).orElseThrow();
            enclosingNode = CommonUtil.getMatchingNode((Node)specificFieldNode, node -> node.parent().kind() == SyntaxKind.MODULE_PART).orElseThrow();
            currentDocument = (Document)context.currentDocument().orElseThrow();
        }
        catch (RuntimeException e) {
            return Collections.emptyList();
        }
        LinePosition functionEndLine = enclosingNode.lineRange().endLine();
        Range extractedRange = PositionUtil.toRange(valueExprNode.lineRange());
        List visibleSymbols = semanticModel.visibleSymbols(currentDocument, functionEndLine);
        String functionName = FunctionGenerator.generateFunctionName(EXTRACTED_PREFIX, visibleSymbols);
        String extractedFunction = ExtractToTransformFunctionCodeAction.getFunction(functionName, outputRecord, inputType, (NonTerminalNode)valueExprNode, visibleSymbols);
        String functionCall = functionName + "(" + valueExprNode.toSourceCode().stripTrailing() + ")";
        List<TextEdit> textEdits = List.of(new TextEdit(PositionUtil.toRange(functionEndLine), extractedFunction), new TextEdit(extractedRange, functionCall));
        CodeAction codeAction = CodeActionUtil.createCodeAction("Extract to transform function", textEdits, context.fileUri(), "refactor.extract");
        CodeActionUtil.addRenamePopup(context, codeAction, "Rename function", extractedRange.getStart());
        return Collections.singletonList(codeAction);
    }

    public List<SyntaxKind> getSyntaxKinds() {
        return List.of(SyntaxKind.FIELD_ACCESS, SyntaxKind.SPECIFIC_FIELD, SyntaxKind.INDEXED_EXPRESSION, SyntaxKind.FUNCTION_CALL, SyntaxKind.METHOD_CALL, SyntaxKind.CHECK_EXPRESSION, SyntaxKind.TYPE_CAST_EXPRESSION);
    }

    public boolean validate(CodeActionContext context, RangeBasedPositionDetails positionDetails) {
        NonTerminalNode matchedCodeActionNode = positionDetails.matchedCodeActionNode();
        return (matchedCodeActionNode.parent().kind() == SyntaxKind.SPECIFIC_FIELD || matchedCodeActionNode.kind() == SyntaxKind.SPECIFIC_FIELD) && CodeActionNodeValidator.validate((Node)matchedCodeActionNode);
    }

    private static Optional<OutputRecord> getOutputRecord(CodeActionContext context, Symbol outputRecordSymbol) {
        try {
            TypeSymbol typeSymbol = ExtractToTransformFunctionCodeAction.getTypeSymbol(outputRecordSymbol).orElseThrow();
            TypeReferenceTypeSymbol typeRefTypeSymbol = (TypeReferenceTypeSymbol)typeSymbol;
            String name = CodeActionUtil.getPossibleType((TypeSymbol)typeRefTypeSymbol, context).orElseThrow();
            return Optional.of(new OutputRecord((RecordTypeSymbol)typeRefTypeSymbol.typeDescriptor(), name));
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    private static Optional<InputType> getInputRecord(CodeActionContext context, Symbol inputSymbol) {
        try {
            TypeSymbol typeSymbol = ExtractToTransformFunctionCodeAction.getTypeSymbol(inputSymbol).orElseThrow();
            String name = CodeActionUtil.getPossibleType(typeSymbol, context).orElseThrow();
            return Optional.of(new InputType(ExtractToTransformFunctionCodeAction.getTypeSymbol((Symbol)typeSymbol).orElseThrow(), name));
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    private static String getFunction(String functionName, OutputRecord outputRecord, InputType inputType, NonTerminalNode matchedNode, List<Symbol> visibleSymbols) {
        String generatedFunction;
        block2: {
            ParameterNameFinder parameterNameFinder = new ParameterNameFinder();
            matchedNode.accept((NodeVisitor)parameterNameFinder);
            Set<String> visibleSymbolNames = visibleSymbols.stream().map(Symbol::getName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            String fieldName = NameUtil.generateParameterName(parameterNameFinder.getParameterName(), 0, inputType.typeSymbol(), visibleSymbolNames);
            Map recordFieldSymbolMap = outputRecord.typeSymbol().fieldDescriptors();
            String bodyText = recordFieldSymbolMap.isEmpty() ? "" : RecordUtil.getFillAllRecordFieldInsertText(recordFieldSymbolMap);
            String parameterName = inputType.typeName() + " " + fieldName;
            generatedFunction = String.format("%s %s %s%s%s returns %s %s %s%n    %s%n%s", "function", functionName, "(", parameterName, ")", outputRecord.typeName(), "=>", "{", bodyText, "};");
            try {
                generatedFunction = Formatter.format((String)generatedFunction);
            }
            catch (FormatterException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"FormatterException should not be thrown");
            }
        }
        return CommonUtil.LINE_SEPARATOR + CommonUtil.LINE_SEPARATOR + generatedFunction;
    }

    private static Optional<TypeSymbol> getTypeSymbol(Symbol symbol) {
        TypeSymbol typeSymbol;
        switch (symbol.kind()) {
            case RECORD_FIELD: {
                typeSymbol = ((RecordFieldSymbol)symbol).typeDescriptor();
                break;
            }
            case PARAMETER: {
                typeSymbol = ((ParameterSymbol)symbol).typeDescriptor();
                break;
            }
            case VARIABLE: {
                typeSymbol = ((VariableSymbol)symbol).typeDescriptor();
                break;
            }
            case TYPE: {
                typeSymbol = (TypeSymbol)symbol;
                break;
            }
            default: {
                assert (false) : "Unconsidered symbol type found: " + String.valueOf(symbol.kind());
                return Optional.empty();
            }
        }
        return typeSymbol.typeKind() == TypeDescKind.COMPILATION_ERROR ? Optional.empty() : Optional.of(typeSymbol);
    }

    public String getName() {
        return NAME;
    }

    private record InputType(TypeSymbol typeSymbol, String typeName) {
    }

    private record OutputRecord(RecordTypeSymbol typeSymbol, String typeName) {
    }

    private static class ParameterNameFinder
    extends NodeVisitor {
        private String parameterName;

        private ParameterNameFinder() {
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public void visit(SimpleNameReferenceNode simpleNameReferenceNode) {
            this.parameterName = simpleNameReferenceNode.name().text();
        }

        public void visit(FieldAccessExpressionNode fieldAccessExpressionNode) {
            fieldAccessExpressionNode.fieldName().accept((NodeVisitor)this);
        }

        public void visit(FunctionCallExpressionNode functionCallExpressionNode) {
            this.parameterName = "";
        }
    }
}

