/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.text.LinePosition;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class ExtractTypeCodeAction
implements RangeBasedCodeActionProvider {
    private static final String RECORD_NAME_PREFIX = "Record";

    public List<SyntaxKind> getSyntaxKinds() {
        return List.of(SyntaxKind.RECORD_TYPE_DESC);
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        if (posDetails.matchedCodeActionNode().kind() != SyntaxKind.RECORD_TYPE_DESC) {
            return Collections.emptyList();
        }
        RecordTypeDescriptorNode node = (RecordTypeDescriptorNode)posDetails.matchedCodeActionNode();
        if (node.parent().kind() == SyntaxKind.TYPE_DEFINITION || context.currentSyntaxTree().isEmpty()) {
            return Collections.emptyList();
        }
        RecordTypeDescriptorNode tlNode = node;
        while (tlNode.parent().kind() != SyntaxKind.MODULE_PART) {
            tlNode = tlNode.parent();
        }
        LinePosition lastTypeDefPosition = tlNode.lineRange().endLine();
        SyntaxTree syntaxTree = (SyntaxTree)context.currentSyntaxTree().get();
        ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
        for (ModuleMemberDeclarationNode member : modulePartNode.members()) {
            if (member.kind() != SyntaxKind.TYPE_DEFINITION) continue;
            lastTypeDefPosition = member.lineRange().endLine();
        }
        Set<String> visibleSymbolNames = context.visibleSymbols(context.cursorPosition()).stream().map(Symbol::getName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        String typeName = NameUtil.generateTypeName(RECORD_NAME_PREFIX, visibleSymbolNames);
        Range extractedRecordRange = new Range(PositionUtil.toPosition(lastTypeDefPosition), PositionUtil.toPosition(lastTypeDefPosition));
        Range originalNodeRange = new Range(PositionUtil.toPosition(node.lineRange().startLine()), PositionUtil.toPosition(node.lineRange().endLine()));
        String typeDesc = String.format("type %s %s;", typeName, node.toSourceCode());
        try {
            typeDesc = Formatter.format((String)typeDesc);
        }
        catch (FormatterException e) {
            LSClientLogger.getInstance(context.languageServercontext()).logError(LSContextOperation.TXT_CODE_ACTION, "Failed to format extracted source: " + typeDesc, e, null, new Position[]{null});
            return Collections.emptyList();
        }
        typeDesc = String.format("%n%n%s", typeDesc);
        TextEdit typeDescEdit = new TextEdit(extractedRecordRange, typeDesc);
        TextEdit replaceEdit = new TextEdit(originalNodeRange, typeName);
        CodeAction codeAction = CodeActionUtil.createCodeAction("Extract type", List.of(typeDescEdit, replaceEdit), context.fileUri(), "refactor.extract");
        return List.of(codeAction);
    }

    public String getName() {
        return "ExtractType";
    }
}

