/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.common.utils.RawTypeSymbolWrapper;
import org.ballerinalang.langserver.common.utils.RecordUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class FillRecordFieldsCodeAction
implements RangeBasedCodeActionProvider {
    public static final String NAME = "Fill Record Fields";
    public static final String DIAGNOSTIC_CODE = "BCE2520";

    public List<SyntaxKind> getSyntaxKinds() {
        return List.of(SyntaxKind.MAPPING_CONSTRUCTOR, SyntaxKind.STRING_LITERAL, SyntaxKind.NUMERIC_LITERAL, SyntaxKind.BINARY_EXPRESSION, SyntaxKind.UNARY_EXPRESSION, SyntaxKind.SPECIFIC_FIELD);
    }

    public boolean validate(CodeActionContext context, RangeBasedPositionDetails positionDetails) {
        return context.diagnostics(context.filePath()).stream().filter(diag -> PositionUtil.isRangeWithinRange(context.range(), PositionUtil.toRange(diag.location().lineRange()))).anyMatch(diagnostic -> diagnostic.diagnosticInfo().code().equals(DIAGNOSTIC_CODE)) && (Boolean)positionDetails.matchedCodeActionNode().apply((NodeTransformer)new ExtendedCodeActionNodeValidator()) != false;
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        Node node = context.nodeAtRange();
        Optional<Node> evalNode = CommonUtil.getMappingContextEvalNode(node);
        if (evalNode.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<MappingConstructorExpressionNode> expressionNode = FillRecordFieldsCodeAction.getMappingConstructorNode(evalNode.get());
        if (expressionNode.isEmpty()) {
            return Collections.emptyList();
        }
        LinePosition startPosition = expressionNode.get().lineRange().startLine();
        if (context.currentSemanticModel().isEmpty() && context.currentDocument().isEmpty()) {
            return Collections.emptyList();
        }
        Optional typeSymbol = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), startPosition);
        if (typeSymbol.isEmpty()) {
            return Collections.emptyList();
        }
        List<RawTypeSymbolWrapper<RecordTypeSymbol>> recordTypeSymbols = RecordUtil.getRecordTypeSymbols((TypeSymbol)typeSymbol.get());
        List<String> existingFields = this.getFields(expressionNode.get());
        ArrayList<Object> validFields = new ArrayList<Object>();
        Map<Object, Object> fields = new HashMap();
        String detail = "";
        for (RawTypeSymbolWrapper<RecordTypeSymbol> symbol : recordTypeSymbols) {
            fields = RecordUtil.getRecordFields(symbol, existingFields);
            validFields.addAll(fields.values());
            detail = NameUtil.getRecordTypeName((DocumentServiceContext)context, symbol);
        }
        if (validFields.isEmpty() && fields.values().isEmpty()) {
            return Collections.emptyList();
        }
        SeparatedNodeList fieldsList = expressionNode.get().fields();
        Object editText = fieldsList.isEmpty() || ((MappingFieldNode)fieldsList.get(fieldsList.size() - 1)).toSourceCode().isEmpty() ? RecordUtil.getFillAllRecordFieldInsertText(fields) : "," + RecordUtil.getFillAllRecordFieldInsertText(fields);
        LinePosition linePosition = expressionNode.get().closeBrace().lineRange().startLine();
        Position position = PositionUtil.toPosition(linePosition);
        TextEdit textEdit = new TextEdit(new Range(position, position), (String)editText);
        String commandTitle = String.format("Fill '%s' required fields", detail);
        return Collections.singletonList(CodeActionUtil.createCodeAction(commandTitle, List.of(textEdit), context.fileUri(), "quickfix"));
    }

    protected List<String> getFields(MappingConstructorExpressionNode node) {
        return node.fields().stream().filter(field -> !field.isMissing() && field.kind() == SyntaxKind.SPECIFIC_FIELD && ((SpecificFieldNode)field).fieldName().kind() == SyntaxKind.IDENTIFIER_TOKEN).map(field -> ((IdentifierToken)((SpecificFieldNode)field).fieldName()).text()).toList();
    }

    private static Optional<MappingConstructorExpressionNode> getMappingConstructorNode(Node node) {
        while (node != null && node.kind() != SyntaxKind.MAPPING_CONSTRUCTOR) {
            node = node.parent();
        }
        return Optional.ofNullable((MappingConstructorExpressionNode)node);
    }

    public String getName() {
        return NAME;
    }

    static class ExtendedCodeActionNodeValidator
    extends CodeActionNodeValidator {
        ExtendedCodeActionNodeValidator() {
        }

        @Override
        public Boolean transform(SpecificFieldNode node) {
            return super.transform(node) != false || node.colon().isEmpty() && (!node.fieldName().toSourceCode().isEmpty() || node.valueExpr().isEmpty());
        }
    }
}

