/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.providers.AbstractImplementMethodCodeAction;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.TextEdit;

public class ImplementAllCodeAction
extends AbstractImplementMethodCodeAction
implements RangeBasedCodeActionProvider {
    public static final String NAME = "Implement All";

    public List<SyntaxKind> getSyntaxKinds() {
        return Arrays.asList(SyntaxKind.CLASS_DEFINITION, SyntaxKind.SERVICE_DECLARATION, SyntaxKind.OBJECT_METHOD_DEFINITION, SyntaxKind.OBJECT_CONSTRUCTOR, SyntaxKind.MODULE_VAR_DECL, SyntaxKind.METHOD_DECLARATION, SyntaxKind.LOCAL_VAR_DECL);
    }

    public boolean validate(CodeActionContext context, RangeBasedPositionDetails positionDetails) {
        NonTerminalNode node = positionDetails.matchedCodeActionNode();
        return CodeActionNodeValidator.validate(context.nodeAtRange()) && (node.kind() == SyntaxKind.CLASS_DEFINITION || node.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION || node.kind() == SyntaxKind.OBJECT_CONSTRUCTOR || node.kind() == SyntaxKind.MODULE_VAR_DECL || node.kind() == SyntaxKind.LOCAL_VAR_DECL || node.kind() == SyntaxKind.SERVICE_DECLARATION);
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        if (posDetails.matchedCodeActionNode().kind() != SyntaxKind.CLASS_DEFINITION && posDetails.matchedCodeActionNode().kind() != SyntaxKind.OBJECT_METHOD_DEFINITION && posDetails.matchedCodeActionNode().kind() != SyntaxKind.OBJECT_CONSTRUCTOR && posDetails.matchedCodeActionNode().kind() != SyntaxKind.MODULE_VAR_DECL && posDetails.matchedCodeActionNode().kind() != SyntaxKind.LOCAL_VAR_DECL && posDetails.matchedCodeActionNode().kind() != SyntaxKind.SERVICE_DECLARATION) {
            return Collections.emptyList();
        }
        List<Diagnostic> diags = context.diagnostics(context.filePath()).stream().filter(diag -> PositionUtil.isRangeWithinRange(context.range(), PositionUtil.toRange(diag.location().lineRange()))).filter(diagnostic -> DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code())).toList();
        if (diags.isEmpty() || diags.size() == 1) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = (SyntaxTree)context.workspace().syntaxTree(context.filePath()).orElseThrow();
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        diags.forEach(diagnostic -> {
            DiagBasedPositionDetails positionDetails = CodeActionUtil.computePositionDetails(syntaxTree, diagnostic, context);
            edits.addAll(ImplementAllCodeAction.getDiagBasedTextEdits(positionDetails, context));
        });
        CodeAction quickFixCodeAction = CodeActionUtil.createCodeAction("Implement all", edits, context.fileUri(), "quickfix");
        quickFixCodeAction.setDiagnostics(CodeActionUtil.toDiagnostics(diags));
        return Collections.singletonList(quickFixCodeAction);
    }

    public String getName() {
        return NAME;
    }
}

