/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class MakeConstructPublicCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Make Construct Public";
    public static final String DIAGNOSTIC_CODE = "BCE20022";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODE.equals(diagnostic.diagnosticInfo().code()) && context.currentSyntaxTree().isPresent() && context.currentSemanticModel().isPresent() && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Range diagnosticRange = PositionUtil.toRange(diagnostic.location().lineRange());
        if (!DIAGNOSTIC_CODE.equals(diagnostic.diagnosticInfo().code()) || context.currentSyntaxTree().isEmpty() || context.currentSemanticModel().isEmpty()) {
            return Collections.emptyList();
        }
        NonTerminalNode nonTerminalNode = CommonUtil.findNode(diagnosticRange, (SyntaxTree)context.currentSyntaxTree().get());
        Optional symbol = ((SemanticModel)context.currentSemanticModel().get()).symbol((Node)nonTerminalNode);
        if (symbol.isEmpty() || ((Symbol)symbol.get()).getModule().isEmpty()) {
            return Collections.emptyList();
        }
        Optional project = context.workspace().project(context.filePath());
        if (project.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<Path> filePath = PathUtil.getFilePathForSymbol((Symbol)symbol.get(), (Project)project.get(), (DocumentServiceContext)context);
        if (filePath.isEmpty() || context.workspace().syntaxTree(filePath.get()).isEmpty()) {
            return Collections.emptyList();
        }
        URI uri = filePath.get().toUri();
        Optional<NonTerminalNode> node = CommonUtil.findNode((Symbol)symbol.get(), (SyntaxTree)context.workspace().syntaxTree(filePath.get()).get());
        if (node.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<Position> position = MakeConstructPublicCodeAction.getStartPosition((Node)node.get());
        if (position.isEmpty()) {
            return Collections.emptyList();
        }
        Range range = new Range(position.get(), position.get());
        String editText = SyntaxKind.PUBLIC_KEYWORD.stringValue() + " ";
        TextEdit textEdit = new TextEdit(range, editText);
        List<TextEdit> editList = List.of(textEdit);
        String commandTitle = String.format("Convert '%s' to public", ((Symbol)symbol.get()).getName().orElse(""));
        return List.of(CodeActionUtil.createCodeAction(commandTitle, editList, uri.toString(), "quickfix"));
    }

    private static Optional<Position> getStartPosition(Node node) {
        SyntaxKind typeKind = node.kind();
        if (typeKind.equals((Object)SyntaxKind.TYPE_DEFINITION)) {
            TypeDefinitionNode typeDefinitionNode = (TypeDefinitionNode)node;
            return Optional.of(PositionUtil.toPosition(typeDefinitionNode.typeKeyword().lineRange().startLine()));
        }
        if (typeKind.equals((Object)SyntaxKind.CLASS_DEFINITION)) {
            ClassDefinitionNode classDefinitionNode = (ClassDefinitionNode)node;
            Position startPosition = classDefinitionNode.classTypeQualifiers().isEmpty() ? PositionUtil.toPosition(classDefinitionNode.classKeyword().lineRange().startLine()) : PositionUtil.toPosition(((Token)classDefinitionNode.classTypeQualifiers().get(0)).lineRange().startLine());
            return Optional.of(startPosition);
        }
        return Optional.empty();
    }

    public String getName() {
        return NAME;
    }
}

