/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.changetype;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.DefaultValueGenerationUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class ChangeParameterTypeCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Change Parameter Type";
    public static final Set<String> DIAGNOSTIC_CODES = Set.of("BCE2066", "BCE2068");

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        VariableDeclarationNode localVarNode = this.getVariableDeclarationNode(positionDetails.matchedNode());
        if (localVarNode == null) {
            return Collections.emptyList();
        }
        Optional typeSymbol = positionDetails.diagnosticProperty(0);
        if (typeSymbol.isEmpty()) {
            return Collections.emptyList();
        }
        Optional initializer = localVarNode.initializer();
        if (initializer.isEmpty() || ((ExpressionNode)initializer.get()).kind() == SyntaxKind.FIELD_ACCESS) {
            return Collections.emptyList();
        }
        SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().orElseThrow();
        Optional optParamSymbol = semanticModel.symbol((Node)initializer.get());
        if (optParamSymbol.isEmpty() || ((Symbol)optParamSymbol.get()).kind() != SymbolKind.PARAMETER) {
            return Collections.emptyList();
        }
        ParameterSymbol paramSymbol = (ParameterSymbol)optParamSymbol.get();
        Optional<FunctionDefinitionNode> funcDefNode = CodeActionUtil.getEnclosedFunction((Node)localVarNode);
        if (funcDefNode.isEmpty()) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = (SyntaxTree)context.currentSyntaxTree().orElseThrow();
        Optional<NonTerminalNode> node = CommonUtil.findNode((Symbol)paramSymbol, syntaxTree);
        if (node.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<Range> paramTypeRange = this.getParameterTypeRange(node.get());
        if (paramTypeRange.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        ArrayList<TextEdit> importEdits = new ArrayList<TextEdit>();
        Map<TypeSymbol, String> types = CodeActionUtil.getPossibleTypeSymbols((TypeSymbol)typeSymbol.get(), importEdits, context);
        for (Map.Entry<TypeSymbol, String> entry : types.entrySet()) {
            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
            edits.add(new TextEdit(paramTypeRange.get(), entry.getValue()));
            if (node.get().kind() == SyntaxKind.DEFAULTABLE_PARAM) {
                Range defaultValRange = PositionUtil.toRange(((DefaultableParameterNode)node.get()).expression().lineRange());
                edits.add(new TextEdit(defaultValRange, DefaultValueGenerationUtil.getDefaultValueForType(entry.getKey()).orElse("")));
            }
            String commandTitle = String.format("Change parameter '%s' type to '%s'", paramSymbol.getName().get(), entry.getValue());
            actions.add(CodeActionUtil.createCodeAction(commandTitle, edits, context.fileUri(), "quickfix"));
        }
        return actions;
    }

    public String getName() {
        return NAME;
    }

    private VariableDeclarationNode getVariableDeclarationNode(NonTerminalNode node) {
        while (node != null && node.kind() != SyntaxKind.LOCAL_VAR_DECL) {
            node = node.parent();
        }
        return node != null ? (VariableDeclarationNode)node : null;
    }

    private Optional<Range> getParameterTypeRange(NonTerminalNode parameterNode) {
        if (parameterNode == null) {
            return Optional.empty();
        }
        if (parameterNode.kind() == SyntaxKind.REQUIRED_PARAM) {
            RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
            return Optional.of(PositionUtil.toRange(requiredParameterNode.typeName().lineRange()));
        }
        if (parameterNode.kind() == SyntaxKind.DEFAULTABLE_PARAM) {
            DefaultableParameterNode defaultableParameterNode = (DefaultableParameterNode)parameterNode;
            return Optional.of(PositionUtil.toRange(defaultableParameterNode.typeName().lineRange()));
        }
        if (parameterNode.kind() == SyntaxKind.REST_PARAM) {
            RestParameterNode restParameterNode = (RestParameterNode)parameterNode;
            return Optional.of(new Range(PositionUtil.toPosition(restParameterNode.typeName().lineRange().startLine()), PositionUtil.toPosition(restParameterNode.ellipsisToken().lineRange().endLine())));
        }
        return Optional.empty();
    }
}

