/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.changetype;

import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.SingletonTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeDescTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.providers.changetype.TypeCastCodeAction;
import org.ballerinalang.langserver.common.ImportsAcceptor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.TextEdit;

public class ChangeVariableTypeCodeAction
extends TypeCastCodeAction {
    public static final String NAME = "Change Variable Type";
    public static final Set<String> DIAGNOSTIC_CODES = Set.of("BCE2066", "BCE2068", "BCE2652", "BCE3931");
    private static final String UNDERSCORE = "_";

    @Override
    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    @Override
    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        List<String> types;
        Optional<NonTerminalNode> variableNode;
        Optional optionalFoundType = "BCE2068".equals(diagnostic.diagnosticInfo().code()) ? positionDetails.diagnosticProperty(CodeActionUtil.getDiagPropertyFilterFunction(1)) : positionDetails.diagnosticProperty(1);
        if (optionalFoundType.isEmpty() || !this.isValidType((TypeSymbol)optionalFoundType.get())) {
            return Collections.emptyList();
        }
        TypeSymbol foundType = (TypeSymbol)optionalFoundType.get();
        if (foundType.typeKind() == TypeDescKind.SINGLETON) {
            foundType = ((SingletonTypeSymbol)foundType).originalType();
        }
        if ((variableNode = this.getVariableOrObjectFieldNode(positionDetails.matchedNode())).isEmpty()) {
            return Collections.emptyList();
        }
        Optional<Node> typeNode = this.getTypeNode((Node)variableNode.get(), context);
        Optional<String> variableName = this.getVariableName((Node)variableNode.get());
        if (typeNode.isEmpty() || variableName.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<String> typeNodeStr = this.getTypeNodeStr(typeNode.get());
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        ArrayList<TextEdit> importEdits = new ArrayList<TextEdit>();
        if ("BCE3931".equals(diagnostic.diagnosticInfo().code())) {
            Optional typeSymbol = ((TypeDescTypeSymbol)foundType).typeParameter();
            if (typeSymbol.isEmpty()) {
                return Collections.emptyList();
            }
            types = Collections.singletonList(((TypeSymbol)typeSymbol.get()).signature());
        } else {
            types = CodeActionUtil.getPossibleTypes(foundType, importEdits, context);
        }
        for (String type : types) {
            String typeName = FunctionGenerator.processModuleIDsInText(new ImportsAcceptor((DocumentServiceContext)context), type, (DocumentServiceContext)context);
            if (typeNodeStr.isPresent() && typeNodeStr.get().equals(typeName)) continue;
            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
            edits.add(new TextEdit(PositionUtil.toRange(typeNode.get().lineRange()), typeName));
            String commandTitle = variableNode.get().kind() == SyntaxKind.CONST_DECLARATION ? String.format("Change constant '%s' type to '%s'", variableName.get(), typeName) : String.format("Change variable '%s' type to '%s'", variableName.get(), typeName);
            edits.addAll(importEdits);
            actions.add(CodeActionUtil.createCodeAction(commandTitle, edits, context.fileUri(), "quickfix"));
        }
        return actions;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private Optional<NonTerminalNode> getVariableOrObjectFieldNode(NonTerminalNode sNode) {
        if (this.isVariableNode(sNode) || sNode.kind() == SyntaxKind.OBJECT_FIELD) {
            return Optional.of(sNode);
        }
        if (this.isVariableNode(sNode.parent()) || sNode.parent().kind() == SyntaxKind.OBJECT_FIELD) {
            return Optional.of(sNode.parent());
        }
        if (sNode.parent().kind() == SyntaxKind.COLLECT_CLAUSE && sNode.parent().parent().kind() == SyntaxKind.QUERY_EXPRESSION && this.isVariableNode(sNode.parent().parent().parent())) {
            return Optional.of(sNode.parent().parent().parent());
        }
        return Optional.empty();
    }

    boolean isVariableNode(NonTerminalNode sNode) {
        if (sNode == null || sNode.kind() == SyntaxKind.POSITIONAL_ARG || sNode.kind() == SyntaxKind.NAMED_ARG) {
            return false;
        }
        return sNode.kind() == SyntaxKind.LOCAL_VAR_DECL || sNode.kind() == SyntaxKind.MODULE_VAR_DECL || sNode.kind() == SyntaxKind.ASSIGNMENT_STATEMENT || sNode.kind() == SyntaxKind.CONST_DECLARATION || sNode.kind() == SyntaxKind.LET_VAR_DECL || sNode.kind() == SyntaxKind.LET_EXPRESSION;
    }

    private Optional<String> getTypeNodeStr(Node node) {
        if (node.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            SimpleNameReferenceNode sRefNode = (SimpleNameReferenceNode)node;
            return Optional.of(sRefNode.name().text());
        }
        if (node.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qnRefNode = (QualifiedNameReferenceNode)node;
            return Optional.of(qnRefNode.modulePrefix().text() + ":" + qnRefNode.identifier().text());
        }
        if (node instanceof BuiltinSimpleNameReferenceNode) {
            BuiltinSimpleNameReferenceNode refNode = (BuiltinSimpleNameReferenceNode)node;
            return Optional.of(refNode.name().text());
        }
        return Optional.empty();
    }

    private Optional<Node> getTypeNode(Node matchedNode, CodeActionContext context) {
        switch (matchedNode.kind()) {
            case LOCAL_VAR_DECL: {
                return this.getLocalVarTypeNode((VariableDeclarationNode)matchedNode);
            }
            case MODULE_VAR_DECL: {
                return this.getModuleVarTypeNode((ModuleVariableDeclarationNode)matchedNode);
            }
            case ASSIGNMENT_STATEMENT: {
                Optional<VariableSymbol> optVariableSymbol = this.getVariableSymbol(context, matchedNode);
                if (optVariableSymbol.isEmpty()) {
                    return Optional.empty();
                }
                SyntaxTree syntaxTree = (SyntaxTree)context.currentSyntaxTree().orElseThrow();
                Optional<NonTerminalNode> node = CommonUtil.findNode((Symbol)optVariableSymbol.get(), syntaxTree);
                if (node.isPresent() && node.get().kind() == SyntaxKind.TYPED_BINDING_PATTERN) {
                    return Optional.of(((TypedBindingPatternNode)node.get()).typeDescriptor());
                }
                return Optional.empty();
            }
            case CONST_DECLARATION: {
                ConstantDeclarationNode constDecl = (ConstantDeclarationNode)matchedNode;
                return Optional.ofNullable(constDecl.typeDescriptor().orElse(null));
            }
            case OBJECT_FIELD: {
                return this.getObjectFieldTypeNode((ObjectFieldNode)matchedNode);
            }
            case LET_VAR_DECL: {
                return this.getLetVarDeclTypeNode((LetVariableDeclarationNode)matchedNode);
            }
            case LET_EXPRESSION: {
                NonTerminalNode parent = matchedNode.parent();
                return switch (parent.kind()) {
                    case SyntaxKind.LOCAL_VAR_DECL -> this.getLocalVarTypeNode((VariableDeclarationNode)parent);
                    case SyntaxKind.MODULE_VAR_DECL -> this.getModuleVarTypeNode((ModuleVariableDeclarationNode)parent);
                    case SyntaxKind.OBJECT_FIELD -> this.getObjectFieldTypeNode((ObjectFieldNode)parent);
                    case SyntaxKind.LET_VAR_DECL -> this.getLetVarDeclTypeNode((LetVariableDeclarationNode)parent);
                    default -> Optional.empty();
                };
            }
        }
        return Optional.empty();
    }

    private Optional<Node> getLocalVarTypeNode(VariableDeclarationNode node) {
        return Optional.of(node.typedBindingPattern().typeDescriptor());
    }

    private Optional<Node> getModuleVarTypeNode(ModuleVariableDeclarationNode node) {
        return Optional.of(node.typedBindingPattern().typeDescriptor());
    }

    private Optional<Node> getObjectFieldTypeNode(ObjectFieldNode node) {
        return Optional.of(node.typeName());
    }

    private Optional<Node> getLetVarDeclTypeNode(LetVariableDeclarationNode node) {
        return Optional.ofNullable(node.typedBindingPattern().typeDescriptor());
    }

    private Optional<String> getVariableName(Node matchedNode) {
        return switch (matchedNode.kind()) {
            case SyntaxKind.LOCAL_VAR_DECL -> this.getVarNameFromBindingPattern(((VariableDeclarationNode)matchedNode).typedBindingPattern().bindingPattern());
            case SyntaxKind.MODULE_VAR_DECL -> this.getVarNameFromBindingPattern(((ModuleVariableDeclarationNode)matchedNode).typedBindingPattern().bindingPattern());
            case SyntaxKind.ASSIGNMENT_STATEMENT -> {
                AssignmentStatementNode assignmentStmtNode = (AssignmentStatementNode)matchedNode;
                Node varRef = assignmentStmtNode.varRef();
                if (varRef.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                    yield Optional.of(((SimpleNameReferenceNode)varRef).name().text());
                }
                if (varRef.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                    yield Optional.of(((QualifiedNameReferenceNode)varRef).identifier().text());
                }
                yield Optional.empty();
            }
            case SyntaxKind.CONST_DECLARATION -> {
                ConstantDeclarationNode constantDecl = (ConstantDeclarationNode)matchedNode;
                yield Optional.of(constantDecl.variableName().text());
            }
            case SyntaxKind.OBJECT_FIELD -> this.getObjectFieldName((ObjectFieldNode)matchedNode);
            case SyntaxKind.LET_VAR_DECL -> this.getLetVarName((LetVariableDeclarationNode)matchedNode);
            case SyntaxKind.LET_EXPRESSION -> {
                NonTerminalNode parent = matchedNode.parent();
                switch (parent.kind()) {
                    case LOCAL_VAR_DECL: {
                        yield this.getVarNameFromBindingPattern(((VariableDeclarationNode)parent).typedBindingPattern().bindingPattern());
                    }
                    case MODULE_VAR_DECL: {
                        yield this.getVarNameFromBindingPattern(((ModuleVariableDeclarationNode)parent).typedBindingPattern().bindingPattern());
                    }
                    case OBJECT_FIELD: {
                        yield this.getObjectFieldName((ObjectFieldNode)parent);
                    }
                    case LET_VAR_DECL: {
                        yield this.getLetVarName((LetVariableDeclarationNode)parent);
                    }
                }
                yield Optional.empty();
            }
            default -> Optional.empty();
        };
    }

    private Optional<String> getVarNameFromBindingPattern(BindingPatternNode bindingPatternNode) {
        if (bindingPatternNode.kind() == SyntaxKind.WILDCARD_BINDING_PATTERN) {
            return Optional.of(UNDERSCORE);
        }
        if (bindingPatternNode.kind() == SyntaxKind.CAPTURE_BINDING_PATTERN) {
            return Optional.of(((CaptureBindingPatternNode)bindingPatternNode).variableName().text());
        }
        return Optional.empty();
    }

    private Optional<String> getObjectFieldName(ObjectFieldNode node) {
        return Optional.of(node.fieldName().text());
    }

    private Optional<String> getLetVarName(LetVariableDeclarationNode node) {
        BindingPatternNode bindingPatternNode = node.typedBindingPattern().bindingPattern();
        return Optional.of(((CaptureBindingPatternNode)bindingPatternNode).variableName().text());
    }

    private boolean isValidType(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.COMPILATION_ERROR || typeSymbol.typeKind() == TypeDescKind.NONE) {
            return false;
        }
        if (typeSymbol.typeKind() == TypeDescKind.MAP) {
            return ((MapTypeSymbol)typeSymbol).typeParam().typeKind() != TypeDescKind.COMPILATION_ERROR;
        }
        if (typeSymbol.typeKind() == TypeDescKind.TABLE) {
            return ((TableTypeSymbol)typeSymbol).rowTypeParameter().typeKind() != TypeDescKind.COMPILATION_ERROR;
        }
        return true;
    }
}

