/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.changetype;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.MatchedExpressionNodeResolver;
import org.ballerinalang.langserver.codeaction.providers.changetype.TypeCastCodeAction;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.TextEdit;

public class TypeCastBinaryExpressionCodeAction
extends TypeCastCodeAction {
    public static final String NAME = "Type Cast Numeric Expression";
    public static final Set<String> DIAGNOSTIC_CODES = Set.of("BCE4026", "BCE2070");

    @Override
    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    @Override
    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Node castExprNode;
        String typeName;
        Optional operatorKind = positionDetails.diagnosticProperty(CodeActionUtil.getDiagPropertyFilterFunction(0));
        Optional lhsOperand = positionDetails.diagnosticProperty(CodeActionUtil.getDiagPropertyFilterFunction(1));
        Optional rhsOperand = positionDetails.diagnosticProperty(CodeActionUtil.getDiagPropertyFilterFunction(2));
        MatchedExpressionNodeResolver expressionResolver = new MatchedExpressionNodeResolver((Node)positionDetails.matchedNode());
        Optional<ExpressionNode> expressionNode = expressionResolver.findExpression((Node)positionDetails.matchedNode());
        if (operatorKind.isEmpty() || lhsOperand.isEmpty() || rhsOperand.isEmpty() || expressionNode.isEmpty() || expressionNode.get().kind() != SyntaxKind.BINARY_EXPRESSION) {
            return Collections.emptyList();
        }
        BinaryExpressionNode binaryExpressionNode = (BinaryExpressionNode)expressionNode.get();
        LinePosition position = binaryExpressionNode.lineRange().startLine();
        Optional contextType = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            contextType = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), position);
        }
        if (contextType.isEmpty()) {
            return Collections.emptyList();
        }
        if (((TypeSymbol)contextType.get()).typeKind() == ((TypeSymbol)lhsOperand.get()).typeKind()) {
            typeName = NameUtil.getModifiedTypeName((DocumentServiceContext)context, (TypeSymbol)lhsOperand.get());
            castExprNode = binaryExpressionNode.rhsExpr();
        } else if (((TypeSymbol)contextType.get()).typeKind() == ((TypeSymbol)rhsOperand.get()).typeKind()) {
            typeName = NameUtil.getModifiedTypeName((DocumentServiceContext)context, (TypeSymbol)rhsOperand.get());
            castExprNode = binaryExpressionNode.lhsExpr();
        } else if (this.isNumericType((TypeSymbol)contextType.get()) && this.isNumericType((TypeSymbol)lhsOperand.get()) && this.isNumericType((TypeSymbol)rhsOperand.get())) {
            typeName = NameUtil.getModifiedTypeName((DocumentServiceContext)context, (TypeSymbol)contextType.get());
            castExprNode = binaryExpressionNode.rhsExpr();
        } else if (this.isStringType((TypeSymbol)contextType.get()) && this.isStringType((TypeSymbol)lhsOperand.get()) && this.isStringType((TypeSymbol)rhsOperand.get())) {
            typeName = NameUtil.getModifiedTypeName((DocumentServiceContext)context, (TypeSymbol)contextType.get());
            castExprNode = binaryExpressionNode.rhsExpr();
        } else {
            return Collections.emptyList();
        }
        String exprSourceCode = castExprNode.toSourceCode().strip();
        if (typeName.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>(this.getTextEdits(castExprNode, typeName));
        String commandTitle = String.format("Add type cast to '%s'", exprSourceCode);
        return Collections.singletonList(CodeActionUtil.createCodeAction(commandTitle, edits, context.fileUri(), "quickfix"));
    }

    private boolean isNumericType(TypeSymbol typeSymbol) {
        TypeDescKind typeKind = typeSymbol.typeKind();
        return typeKind.isIntegerType() || typeKind == TypeDescKind.DECIMAL || typeKind == TypeDescKind.FLOAT;
    }

    private boolean isStringType(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind().isStringType()) {
            return true;
        }
        return typeSymbol.typeKind() == TypeDescKind.UNION && ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors().stream().anyMatch(t -> t.typeKind().isStringType());
    }

    @Override
    public String getName() {
        return NAME;
    }
}

