/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.createvar;

import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.providers.createvar.CreateVariableCodeAction;
import org.ballerinalang.langserver.common.ImportsAcceptor;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class ErrorHandleInsideCodeAction
extends CreateVariableCodeAction {
    public static final String NAME = "Error Handle Inside";

    @Override
    public int priority() {
        return 997;
    }

    @Override
    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return diagnostic.message().contains("variable assignment is required") && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    @Override
    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional<TypeSymbol> typeDescriptor = this.getExpectedTypeSymbol(positionDetails);
        if (typeDescriptor.isEmpty() || typeDescriptor.get().typeKind() != TypeDescKind.UNION || this.isCompilationErrorTyped((UnionTypeSymbol)typeDescriptor.get())) {
            return Collections.emptyList();
        }
        String uri = context.fileUri();
        UnionTypeSymbol unionType = (UnionTypeSymbol)typeDescriptor.get();
        Range range = PositionUtil.toRange(diagnostic.location().lineRange());
        CreateVariableCodeAction.CreateVariableOut createVarTextEdits = this.getCreateVariableTextEdits(range, positionDetails, typeDescriptor.get(), context, new ImportsAcceptor((DocumentServiceContext)context));
        String commandTitle = "Create variable and type guard";
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        edits.add(createVarTextEdits.edits.get(0));
        edits.addAll(CodeActionUtil.getTypeGuardCodeActionEdits(createVarTextEdits.name, range, unionType, context));
        createVarTextEdits.imports.stream().filter(edit -> !edits.contains(edit)).forEach(edits::add);
        CodeAction codeAction = CodeActionUtil.createCodeAction(commandTitle, edits, uri, "quickfix");
        this.addRenamePopup(context, codeAction, createVarTextEdits.varRenamePosition.get(0), createVarTextEdits.imports.size());
        return Collections.singletonList(codeAction);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

