/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.docs;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.command.docs.DocumentationGenerator;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;

public class AddDocumentationCodeAction
implements RangeBasedCodeActionProvider {
    public static final String NAME = "Add Documentation";

    public List<SyntaxKind> getSyntaxKinds() {
        return Arrays.asList(SyntaxKind.FUNCTION_DEFINITION, SyntaxKind.OBJECT_TYPE_DESC, SyntaxKind.CLASS_DEFINITION, SyntaxKind.SERVICE_DECLARATION, SyntaxKind.RESOURCE_ACCESSOR_DEFINITION, SyntaxKind.RECORD_TYPE_DESC, SyntaxKind.METHOD_DECLARATION, SyntaxKind.OBJECT_METHOD_DEFINITION, SyntaxKind.ANNOTATION_DECLARATION, SyntaxKind.MODULE_VAR_DECL, SyntaxKind.ENUM_DECLARATION, SyntaxKind.CONST_DECLARATION, SyntaxKind.UNION_TYPE_DESC, SyntaxKind.NIL_TYPE_DESC, SyntaxKind.ARRAY_TYPE_DESC, SyntaxKind.INT_TYPE_DESC, SyntaxKind.BYTE_TYPE_DESC, SyntaxKind.FLOAT_TYPE_DESC, SyntaxKind.DECIMAL_TYPE_DESC, SyntaxKind.STRING_TYPE_DESC, SyntaxKind.BOOLEAN_TYPE_DESC, SyntaxKind.XML_TYPE_DESC, SyntaxKind.JSON_TYPE_DESC, SyntaxKind.HANDLE_TYPE_DESC, SyntaxKind.ANY_TYPE_DESC, SyntaxKind.ANYDATA_TYPE_DESC, SyntaxKind.NEVER_TYPE_DESC, SyntaxKind.MAP_TYPE_DESC, SyntaxKind.ERROR_TYPE_DESC, SyntaxKind.STREAM_TYPE_DESC, SyntaxKind.TABLE_TYPE_DESC, SyntaxKind.FUNCTION_TYPE_DESC, SyntaxKind.TUPLE_TYPE_DESC, SyntaxKind.READONLY_TYPE_DESC, SyntaxKind.FUTURE_TYPE_DESC, SyntaxKind.SINGLETON_TYPE_DESC, SyntaxKind.INTERSECTION_TYPE_DESC, SyntaxKind.QUALIFIED_NAME_REFERENCE, SyntaxKind.SIMPLE_NAME_REFERENCE, SyntaxKind.TYPEDESC_TYPE_DESC, SyntaxKind.DISTINCT_TYPE_DESC, SyntaxKind.OPTIONAL_TYPE_DESC, SyntaxKind.PARENTHESISED_TYPE_DESC);
    }

    public int priority() {
        return 999;
    }

    public boolean validate(CodeActionContext context, RangeBasedPositionDetails positionDetails) {
        return positionDetails.matchedDocumentableNode().isPresent() && !DocumentationGenerator.hasDocs((NonTerminalNode)positionDetails.matchedDocumentableNode().get()) && CodeActionNodeValidator.validate((Node)positionDetails.matchedCodeActionNode());
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        String docUri = context.fileUri();
        Optional documentableNode = posDetails.matchedDocumentableNode();
        CommandArgument docUriArg = CommandArgument.from((String)"doc.uri", (Object)docUri);
        CommandArgument lineStart = CommandArgument.from((String)"node.range", (Object)PositionUtil.toRange(((NonTerminalNode)documentableNode.get()).lineRange()));
        ArrayList<CommandArgument> args = new ArrayList<CommandArgument>(Arrays.asList(docUriArg, lineStart));
        CodeAction action = new CodeAction("Document this");
        Command command = new Command("Document this", "ADD_DOC", args);
        action.setCommand(command);
        return Collections.singletonList(action);
    }

    public String getName() {
        return NAME;
    }
}

