/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.docs;

import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;

public class UpdateDocumentationCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Update Documentation";
    private static final List<String> DIAGNOSTIC_IDS = Arrays.asList(DiagnosticWarningCode.UNDOCUMENTED_PARAMETER.diagnosticId(), DiagnosticWarningCode.NO_SUCH_DOCUMENTABLE_PARAMETER.diagnosticId(), DiagnosticWarningCode.PARAMETER_ALREADY_DOCUMENTED.diagnosticId(), DiagnosticWarningCode.UNDOCUMENTED_FIELD.diagnosticId(), DiagnosticWarningCode.NO_SUCH_DOCUMENTABLE_FIELD.diagnosticId(), DiagnosticWarningCode.FIELD_ALREADY_DOCUMENTED.diagnosticId(), DiagnosticWarningCode.UNDOCUMENTED_VARIABLE.diagnosticId(), DiagnosticWarningCode.NO_SUCH_DOCUMENTABLE_VARIABLE.diagnosticId(), DiagnosticWarningCode.VARIABLE_ALREADY_DOCUMENTED.diagnosticId(), DiagnosticWarningCode.UNDOCUMENTED_RETURN_PARAMETER.diagnosticId(), DiagnosticWarningCode.NO_DOCUMENTABLE_RETURN_PARAMETER.diagnosticId(), DiagnosticWarningCode.INVALID_DOCUMENTATION_REFERENCE.diagnosticId(), DiagnosticWarningCode.INVALID_USAGE_OF_PARAMETER_REFERENCE.diagnosticId(), DiagnosticWarningCode.NO_SUCH_DOCUMENTABLE_ATTRIBUTE.diagnosticId(), DiagnosticWarningCode.INVALID_USE_OF_ENDPOINT_DOCUMENTATION_ATTRIBUTE.diagnosticId(), DiagnosticWarningCode.DUPLICATE_DOCUMENTED_ATTRIBUTE.diagnosticId(), DiagnosticWarningCode.USAGE_OF_DEPRECATED_CONSTRUCT.diagnosticId(), DiagnosticWarningCode.DEPRECATION_DOCUMENTATION_SHOULD_BE_AVAILABLE.diagnosticId());

    public boolean isEnabled(LanguageServerContext serverContext) {
        return false;
    }

    public int priority() {
        return 998;
    }

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        String code = diagnostic.diagnosticInfo().code();
        return DIAGNOSTIC_IDS.stream().anyMatch(id -> id.equals(code)) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        String docUri = context.fileUri();
        SyntaxTree syntaxTree = (SyntaxTree)context.currentSyntaxTree().orElseThrow();
        Optional<NonTerminalNode> topLevelNode = CodeActionUtil.getTopLevelNode(context.range(), syntaxTree);
        if (topLevelNode.isEmpty()) {
            return Collections.emptyList();
        }
        if (topLevelNode.get().kind() == SyntaxKind.SERVICE_DECLARATION) {
            return Collections.emptyList();
        }
        NonTerminalNode node = topLevelNode.get();
        if (node.kind() == SyntaxKind.MARKDOWN_DOCUMENTATION) {
            node = node.parent().parent();
        }
        CommandArgument docUriArg = CommandArgument.from((String)"doc.uri", (Object)docUri);
        CommandArgument lineStart = CommandArgument.from((String)"node.range", (Object)PositionUtil.toRange(node.lineRange()));
        ArrayList<CommandArgument> args = new ArrayList<CommandArgument>(Arrays.asList(docUriArg, lineStart));
        String commandTitle = "Update documentation";
        Command command = new Command(commandTitle, "UPDATE_DOC", args);
        CodeAction action = CodeActionUtil.createCodeAction(commandTitle, command, "quickfix");
        action.setDiagnostics(CodeActionUtil.toDiagnostics(Collections.singletonList(diagnostic)));
        return Collections.singletonList(action);
    }

    public String getName() {
        return NAME;
    }
}

