/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.imports;

import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.Project;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.SeparatedNodeList;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.LSPackageLoader;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.toml.common.TomlSyntaxTreeUtil;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class AddModuleToBallerinaTomlCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Add Module to Ballerina.toml";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return diagnostic.diagnosticInfo().code().equals(DiagnosticErrorCode.MODULE_NOT_FOUND.diagnosticId());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional project = context.workspace().project(context.filePath());
        if (project.isEmpty()) {
            return Collections.emptyList();
        }
        Optional toml = ((Project)project.get()).currentPackage().ballerinaToml();
        if (toml.isEmpty()) {
            return Collections.emptyList();
        }
        Optional msg = positionDetails.diagnosticProperty(0);
        if (msg.isEmpty()) {
            return Collections.emptyList();
        }
        String[] orgAndRest = ((String)msg.get()).split("/");
        if (orgAndRest.length != 2) {
            return Collections.emptyList();
        }
        String org = orgAndRest[0];
        String[] moduleAndPrefix = orgAndRest[1].split(" as ");
        ArrayList<PackageVersion> loadedPackageVersions = new ArrayList<PackageVersion>();
        String pkg = this.resolvePackageVersionsAndName(LSPackageLoader.getInstance(context.languageServercontext()), (Project)project.get(), org, moduleAndPrefix[0], loadedPackageVersions);
        if (loadedPackageVersions.isEmpty()) {
            return Collections.emptyList();
        }
        Position dependencyStart = new Position(this.getDependencyStartLine((BallerinaToml)toml.get()), 0);
        String dependency = String.format("[[dependency]]%norg = \"%s\"%nname = \"%s\"%nversion = \"%s\"%nrepository = \"local\"%n%n", org, pkg, this.getLatestVersion(loadedPackageVersions));
        TextEdit textEdit = new TextEdit(new Range(dependencyStart, dependencyStart), dependency);
        CodeAction action = CodeActionUtil.createCodeAction("Add module to Ballerina.toml", List.of(textEdit), ((Project)project.get()).sourceRoot().resolve("Ballerina.toml").toString(), "quickfix");
        return Collections.singletonList(action);
    }

    private String resolvePackageVersionsAndName(LSPackageLoader lsPackageLoader, Project project, String org, String moduleName, List<PackageVersion> versions) {
        String packageName = moduleName;
        do {
            int i;
            if ((i = packageName.lastIndexOf(".")) == -1) {
                versions.addAll(this.getAvailablePackageVersionsFromLocalRepo(lsPackageLoader, project, org, packageName));
                if (!versions.isEmpty()) {
                    return packageName;
                }
                versions.addAll(this.getAvailablePackageVersionsFromLocalRepo(lsPackageLoader, project, org, moduleName));
                return moduleName;
            }
            packageName = packageName.substring(0, i);
            versions.addAll(this.getAvailablePackageVersionsFromLocalRepo(lsPackageLoader, project, org, packageName));
        } while (versions.isEmpty());
        return packageName;
    }

    public String getName() {
        return NAME;
    }

    private List<PackageVersion> getAvailablePackageVersionsFromLocalRepo(LSPackageLoader lsPackageLoader, Project project, String orgName, String pkgName) {
        List<LSPackageLoader.ModuleInfo> modules = lsPackageLoader.getLocalRepoModules();
        ArrayList<PackageVersion> versions = new ArrayList<PackageVersion>();
        for (LSPackageLoader.ModuleInfo mod : modules) {
            if (!mod.packageOrg().equals(orgName) || !mod.packageName().equals(pkgName)) continue;
            versions.add(PackageVersion.from((String)mod.packageVersion()));
        }
        return versions;
    }

    private String getLatestVersion(List<PackageVersion> versions) {
        PackageVersion latestVersion = versions.get(0);
        for (int i = 1; i < versions.size(); ++i) {
            PackageVersion version = versions.get(i);
            if (!version.value().greaterThanOrEqualTo(latestVersion.value())) continue;
            latestVersion = version;
        }
        return latestVersion.toString();
    }

    private int getDependencyStartLine(BallerinaToml toml) {
        DocumentNode tomlSyntaxTree = (DocumentNode)toml.tomlDocument().syntaxTree().rootNode();
        return tomlSyntaxTree.members().stream().filter(member -> member.kind().equals((Object)SyntaxKind.TABLE) && TomlSyntaxTreeUtil.toQualifiedName((SeparatedNodeList)((TableNode)member).identifier().value()).equals("package")).findFirst().map(member -> member.lineRange().endLine().line() + 2).orElse(0);
    }
}

