/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.imports;

import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class OptimizeImportsCodeAction
implements RangeBasedCodeActionProvider {
    public static final String NAME = "Optimize Imports";
    public static final String UNUSED_IMPORT_DIAGNOSTIC_CODE = "BCE2002";
    public static final String REDECLARED_IMPORT_DIAGNOSTIC_CODE = "BCE2004";

    public List<SyntaxKind> getSyntaxKinds() {
        return Collections.singletonList(SyntaxKind.IMPORT_DECLARATION);
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        String uri = context.fileUri();
        SyntaxTree syntaxTree = (SyntaxTree)context.currentSyntaxTree().orElseThrow();
        ArrayList<ImportDeclarationNode> fileImports = new ArrayList<ImportDeclarationNode>();
        ((ModulePartNode)syntaxTree.rootNode()).imports().stream().forEach(fileImports::add);
        List toBeRemovedImportsLocations = context.diagnostics(context.filePath()).stream().filter(diag -> UNUSED_IMPORT_DIAGNOSTIC_CODE.equals(diag.diagnosticInfo().code())).map(diag -> diag.location().lineRange()).collect(Collectors.toList());
        if (fileImports.isEmpty() || fileImports.size() <= 1 && toBeRemovedImportsLocations.isEmpty()) {
            return actions;
        }
        int importSLine = ((ImportDeclarationNode)fileImports.get(0)).lineRange().startLine().line();
        int importELine = ((ImportDeclarationNode)fileImports.get(0)).lineRange().endLine().line();
        block0: for (int i = 0; i < fileImports.size(); ++i) {
            ImportDeclarationNode importPkg = (ImportDeclarationNode)fileImports.get(i);
            LineRange pos = importPkg.lineRange();
            if (importSLine > pos.startLine().line()) {
                importSLine = pos.startLine().line();
            }
            if (importELine < pos.endLine().line()) {
                importELine = pos.endLine().line();
            }
            for (int j = 0; j < toBeRemovedImportsLocations.size(); ++j) {
                LineRange prefixLineRange;
                LineRange rmLineRange = (LineRange)toBeRemovedImportsLocations.get(j);
                LineRange lineRange = prefixLineRange = importPkg.prefix().isPresent() ? ((ImportPrefixNode)importPkg.prefix().get()).prefix().lineRange() : ((IdentifierToken)importPkg.moduleName().get(importPkg.moduleName().size() - 1)).lineRange();
                if (!prefixLineRange.equals((Object)rmLineRange)) continue;
                fileImports.remove(i);
                toBeRemovedImportsLocations.remove(j);
                --i;
                continue block0;
            }
        }
        this.processFileImports(fileImports, context);
        StringBuilder editText = new StringBuilder();
        this.organizeFileImports(fileImports).forEach(importNode -> OptimizeImportsCodeAction.buildEditText(editText, importNode));
        Position importStart = new Position(importSLine, 0);
        Position importEnd = new Position(importELine + 1, 0);
        TextEdit textEdit = new TextEdit(new Range(importStart, importEnd), editText.toString());
        List<TextEdit> edits = Collections.singletonList(textEdit);
        actions.add(CodeActionUtil.createCodeAction(this.getCodeActionTitle(), edits, uri, this.getCodeActionKind()));
        return actions;
    }

    protected void processFileImports(List<ImportDeclarationNode> fileImports, CodeActionContext context) {
        List<LineRange> reDeclaredImportLocations = context.diagnostics(context.filePath()).stream().filter(diag -> REDECLARED_IMPORT_DIAGNOSTIC_CODE.equals(diag.diagnosticInfo().code())).map(diag -> diag.location().lineRange()).toList();
        Iterator<ImportDeclarationNode> iterator = fileImports.iterator();
        while (iterator.hasNext()) {
            ImportDeclarationNode importDeclarationNode = iterator.next();
            boolean redeclared = reDeclaredImportLocations.stream().anyMatch(lineRange -> lineRange.equals((Object)importDeclarationNode.location().lineRange()));
            if (!redeclared) continue;
            iterator.remove();
        }
    }

    protected String getCodeActionKind() {
        return "source.organizeImports";
    }

    protected String getCodeActionTitle() {
        return "Optimize all imports";
    }

    public String getName() {
        return NAME;
    }

    protected List<ImportDeclarationNode> organizeFileImports(List<ImportDeclarationNode> fileImports) {
        return fileImports.stream().sorted(Comparator.comparing(o -> o.orgName().isPresent() ? ((ImportOrgNameNode)o.orgName().get()).orgName().text() : o.moduleName().stream().map(Token::text).collect(Collectors.joining("."))).thenComparing(o -> o.moduleName().stream().map(Token::text).collect(Collectors.joining("."))).thenComparing(o -> o.prefix().isPresent() ? ((ImportPrefixNode)o.prefix().get()).prefix().text() : "")).toList();
    }

    protected static void buildEditText(StringBuilder editText, ImportDeclarationNode importNode) {
        MinutiaeList leadingMinutiae = NodeFactory.createEmptyMinutiaeList();
        MinutiaeList trailingMinutiae = importNode.importKeyword().trailingMinutiae();
        Token modifiedImportKeyword = importNode.importKeyword().modify(leadingMinutiae, trailingMinutiae);
        ImportDeclarationNode.ImportDeclarationNodeModifier importModifier = importNode.modify();
        importModifier.withImportKeyword(modifiedImportKeyword);
        if (importNode.orgName().isPresent()) {
            importModifier.withOrgName((ImportOrgNameNode)importNode.orgName().get());
        }
        importModifier.withModuleName(importNode.moduleName());
        if (importNode.prefix().isPresent()) {
            importModifier.withPrefix((ImportPrefixNode)importNode.prefix().get());
        }
        importNode.semicolon();
        importModifier.withSemicolon(importNode.semicolon());
        editText.append(importModifier.apply().toSourceCode());
    }
}

