/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codelenses;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.codelenses.spi.LSCodeLensesProvider;
import org.ballerinalang.langserver.config.ClientConfigListener;
import org.ballerinalang.langserver.config.LSClientConfig;
import org.ballerinalang.langserver.config.LSClientConfigHolder;

public class LSCodeLensesProviderHolder {
    private static final List<LSCodeLensesProvider> codeLenses = new ArrayList<LSCodeLensesProvider>();
    private static final LanguageServerContext.Key<LSCodeLensesProviderHolder> CODE_LENSES_PROVIDER_HOLDER_KEY = new LanguageServerContext.Key();
    private final LanguageServerContext serverContext;
    private boolean isEnabled = true;

    private LSCodeLensesProviderHolder(LanguageServerContext serverContext) {
        serverContext.put(CODE_LENSES_PROVIDER_HOLDER_KEY, (Object)this);
        this.loadServices();
        LSClientConfigHolder.getInstance(serverContext).register(new ClientConfigListener(){

            @Override
            public void didChangeConfig(LSClientConfig oldConfig, LSClientConfig newConfig) {
                LSCodeLensesProviderHolder.this.isEnabled = newConfig.getCodeLens().getAll().isEnabled();
            }
        });
        this.serverContext = serverContext;
    }

    private void loadServices() {
        if (!codeLenses.isEmpty()) {
            return;
        }
        ServiceLoader<LSCodeLensesProvider> providers = ServiceLoader.load(LSCodeLensesProvider.class);
        for (LSCodeLensesProvider codeLens : providers) {
            if (codeLens == null) continue;
            codeLenses.add(codeLens);
        }
    }

    public static LSCodeLensesProviderHolder getInstance(LanguageServerContext serverContext) {
        LSCodeLensesProviderHolder lsCodeLensesProviderHolder = (LSCodeLensesProviderHolder)serverContext.get(CODE_LENSES_PROVIDER_HOLDER_KEY);
        if (lsCodeLensesProviderHolder == null) {
            lsCodeLensesProviderHolder = new LSCodeLensesProviderHolder(serverContext);
        }
        return lsCodeLensesProviderHolder;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public List<LSCodeLensesProvider> getProviders() {
        ArrayList<LSCodeLensesProvider> activeProviders = new ArrayList<LSCodeLensesProvider>();
        for (LSCodeLensesProvider provider : codeLenses) {
            if (provider == null || !provider.isEnabled(this.serverContext)) continue;
            activeProviders.add(provider);
        }
        return activeProviders;
    }
}

