/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.docs;

import io.ballerina.compiler.api.symbols.Documentation;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.eclipse.lsp4j.Position;

public class DocAttachmentInfo
implements Documentation {
    private final String description;
    private final Map<String, String> parameters;
    private final String returnDesc;
    private final String deprecatedDesc;
    private final Position docStart;
    private final String padding;

    public DocAttachmentInfo(String description, LinkedHashMap<String, String> parameters, String returnDesc, String deprecatedDesc, Position docStart, String padding) {
        this.description = description;
        this.parameters = parameters;
        this.returnDesc = returnDesc;
        this.deprecatedDesc = deprecatedDesc;
        this.docStart = docStart;
        this.padding = padding;
    }

    public DocAttachmentInfo(String description, Position docStart, String padding) {
        this.description = description;
        this.parameters = new LinkedHashMap<String, String>();
        this.returnDesc = null;
        this.deprecatedDesc = null;
        this.docStart = docStart;
        this.padding = padding;
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public Map<String, String> parameterMap() {
        return this.parameters;
    }

    public Optional<String> returnDescription() {
        return Optional.ofNullable(this.returnDesc);
    }

    public Optional<String> deprecatedDescription() {
        return Optional.ofNullable(this.deprecatedDesc);
    }

    public Map<String, String> deprecatedParametersMap() {
        return Collections.emptyMap();
    }

    public Position getDocStartPos() {
        return this.docStart;
    }

    public DocAttachmentInfo mergeDocAttachment(Documentation other) {
        String description = other.description().orElse(this.description);
        LinkedHashMap<String, String> newParamsMap = new LinkedHashMap<String, String>();
        if (!this.parameters.isEmpty()) {
            this.parameters.forEach((key, value) -> newParamsMap.put((String)key, other.parameterMap().getOrDefault(key, value)));
        }
        String returnValueDescription = null;
        if (this.returnDesc != null) {
            returnValueDescription = other.returnDescription().orElse(this.returnDesc);
        }
        String deprecatedDescription = null;
        if (this.deprecatedDesc != null) {
            deprecatedDescription = other.deprecatedDescription().orElse(this.deprecatedDesc);
        }
        return new DocAttachmentInfo(description, newParamsMap, returnValueDescription, deprecatedDescription, this.docStart, this.padding);
    }

    public String getDocumentationString() {
        return this.getDocumentationString(true);
    }

    public String getDocumentationString(boolean newlineAtEnd) {
        String[] descriptionLines;
        StringBuilder result = new StringBuilder();
        for (String descriptionLine : descriptionLines = this.description.trim().split("(\r)?\n")) {
            result.append(String.format("%s# %s%n", this.padding, descriptionLine.trim()));
        }
        if (!this.parameters.isEmpty()) {
            StringJoiner paramJoiner = new StringJoiner(CommonUtil.MD_LINE_SEPARATOR);
            for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
                String[] parameterLines = parameter.getValue().trim().split("(\r)?\n");
                paramJoiner.add(String.format("%s# + %s - %s", this.padding, parameter.getKey(), parameterLines[0].trim()));
                for (String parameterLine : Arrays.copyOfRange(parameterLines, 1, parameterLines.length)) {
                    paramJoiner.add(String.format("%s# %s", this.padding, parameterLine.trim()));
                }
            }
            result.append(String.format("%s#%n%s%n", this.padding, paramJoiner.toString()));
        }
        if (this.returnDesc != null) {
            String[] returnDescLines = this.returnDesc.trim().split("(\r)?\n");
            result.append(String.format("%s# + return - %s%n", this.padding, returnDescLines[0].trim()));
            for (String returnDescLine : Arrays.copyOfRange(returnDescLines, 1, returnDescLines.length)) {
                result.append(String.format("%s# %s%n", this.padding, returnDescLine.trim()));
            }
        }
        if (this.deprecatedDesc != null) {
            String[] deprecatedDescLines;
            result.append(String.format("%s# # Deprecated%n", this.padding));
            for (String deprecatedLine : deprecatedDescLines = this.deprecatedDesc.trim().split("(\r)?\n")) {
                result.append(String.format("%s# %s%n", this.padding, deprecatedLine));
            }
        }
        if (newlineAtEnd) {
            return result.toString().trim() + CommonUtil.LINE_SEPARATOR + this.padding;
        }
        return result.toString().trim();
    }
}

