/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors;

import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.command.docs.DocAttachmentInfo;
import org.ballerinalang.langserver.command.docs.DocumentationGenerator;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.commons.ExecuteCommandContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;

public class AddAllDocumentationExecutor
implements LSCommandExecutor {
    public static final String COMMAND = "ADD_ALL_DOC";

    public Object execute(ExecuteCommandContext context) {
        String documentUri = "";
        VersionedTextDocumentIdentifier textDocumentIdentifier = new VersionedTextDocumentIdentifier();
        for (CommandArgument arg : context.getArguments()) {
            if (!"doc.uri".equals(arg.key())) continue;
            documentUri = (String)arg.valueAs(String.class);
            textDocumentIdentifier.setUri(documentUri);
        }
        Optional<Path> filePath = PathUtil.getPathFromURI(documentUri);
        if (filePath.isEmpty()) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = (SyntaxTree)context.workspace().syntaxTree(filePath.get()).orElseThrow();
        ArrayList textEdits = new ArrayList();
        ((ModulePartNode)syntaxTree.rootNode()).members().stream().filter(node -> !DocumentationGenerator.hasDocs((NonTerminalNode)node)).forEach(member -> DocumentationGenerator.getDocumentationEditForNode((NonTerminalNode)member, syntaxTree).ifPresent(docs -> textEdits.add(AddAllDocumentationExecutor.getTextEdit(docs))));
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(textDocumentIdentifier, textEdits);
        ExtendedLanguageClient languageClient = context.getLanguageClient();
        return CommandUtil.applyWorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)), (LanguageClient)languageClient);
    }

    public String getCommand() {
        return COMMAND;
    }

    private static TextEdit getTextEdit(DocAttachmentInfo attachmentInfo) {
        Range range = new Range(attachmentInfo.getDocStartPos(), attachmentInfo.getDocStartPos());
        return new TextEdit(range, attachmentInfo.getDocumentationString());
    }
}

