/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors;

import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.commons.ExecuteCommandContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;

public class MessageExecutor
implements LSCommandExecutor {
    public static final String COMMAND = "MESSAGE";

    public Object execute(ExecuteCommandContext context) {
        MessageType messageType = null;
        String message = "";
        for (CommandArgument arg : context.getArguments()) {
            switch (arg.key()) {
                case "message.type": {
                    messageType = MessageType.forValue((int)((Integer)arg.valueAs(Integer.class)));
                    break;
                }
                case "message": {
                    message = (String)arg.valueAs(String.class);
                    break;
                }
            }
        }
        if (messageType == null || message.isEmpty()) {
            return new Object();
        }
        ExtendedLanguageClient client = context.getLanguageClient();
        client.showMessage(new MessageParams());
        CommandUtil.notifyClient((LanguageClient)client, messageType, message);
        return new Object();
    }

    public String getCommand() {
        return COMMAND;
    }
}

