/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.visitors;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.FutureTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.api.symbols.WorkerSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.CompoundAssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ConditionalExpressionNode;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FailStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.GroupingKeyVarDeclarationNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.LetExpressionNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.PanicStatementNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.SelectClauseNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StartActionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;

public class FunctionCallExpressionTypeFinder
extends NodeVisitor {
    private final SemanticModel semanticModel;
    private final FunctionCallExpressionNode functionCallExpr;
    private TypeSymbol returnTypeSymbol;
    private boolean resultFound = false;

    public FunctionCallExpressionTypeFinder(SemanticModel semanticModel, FunctionCallExpressionNode functionCallExpr) {
        this.semanticModel = semanticModel;
        this.functionCallExpr = functionCallExpr;
    }

    public void visit(ObjectFieldNode objectFieldNode) {
        Symbol symbol = this.semanticModel.symbol((Node)objectFieldNode).orElse(null);
        TypeSymbol typeDescriptor = SymbolUtil.getTypeDescriptor(symbol).orElse(null);
        this.checkAndSetTypeResult(typeDescriptor);
    }

    public void visit(RecordFieldWithDefaultValueNode recordFieldWithDefaultValueNode) {
        Symbol symbol = this.semanticModel.symbol((Node)recordFieldWithDefaultValueNode).orElse(null);
        TypeSymbol typeDescriptor = SymbolUtil.getTypeDescriptor(symbol).orElse(null);
        this.checkAndSetTypeResult(typeDescriptor);
    }

    public void visit(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        this.visitVariableDeclaration((Node)moduleVariableDeclarationNode, moduleVariableDeclarationNode.typedBindingPattern());
    }

    public void visit(AssignmentStatementNode assignmentStatementNode) {
        Symbol symbol = this.semanticModel.symbol((Node)assignmentStatementNode).orElse(null);
        TypeSymbol typeDescriptor = SymbolUtil.getTypeDescriptor(symbol).orElse(null);
        this.checkAndSetTypeResult(typeDescriptor);
        if (this.resultFound) {
            return;
        }
        assignmentStatementNode.varRef().accept((NodeVisitor)this);
    }

    public void visit(CompoundAssignmentStatementNode compoundAssignmentNode) {
        TypeSymbol typeSymbol = this.semanticModel.typeOf((Node)compoundAssignmentNode.lhsExpression()).orElse(null);
        this.checkAndSetTypeResult(typeSymbol);
    }

    public void visit(VariableDeclarationNode variableDeclarationNode) {
        this.visitVariableDeclaration((Node)variableDeclarationNode, variableDeclarationNode.typedBindingPattern());
    }

    public void visit(SpecificFieldNode specificFieldNode) {
        this.semanticModel.symbol((Node)specificFieldNode).map(symbol -> (RecordFieldSymbol)symbol).ifPresent(recordFieldSymbol -> this.checkAndSetTypeResult(recordFieldSymbol.typeDescriptor()));
    }

    public void visit(BinaryExpressionNode binaryExpressionNode) {
        TypeSymbol typeSymbol = this.semanticModel.typeOf(binaryExpressionNode.lhsExpr()).orElse(null);
        this.checkAndSetTypeResult(typeSymbol);
        if (this.resultFound) {
            return;
        }
        typeSymbol = this.semanticModel.typeOf(binaryExpressionNode.rhsExpr()).orElse(null);
        if (binaryExpressionNode.operator().kind().name().equals("ELVIS_TOKEN")) {
            Types types = this.semanticModel.types();
            TypeBuilder builder = types.builder();
            UnionTypeSymbol unionTypeSymbol = builder.UNION_TYPE.withMemberTypes(new TypeSymbol[]{typeSymbol, types.NIL}).build();
            this.checkAndSetTypeResult((TypeSymbol)unionTypeSymbol);
            return;
        }
        this.checkAndSetTypeResult(typeSymbol);
    }

    public void visit(LetExpressionNode letExpressionNode) {
        TypeSymbol typeSymbol = this.semanticModel.typeOf((Node)letExpressionNode).orElse(null);
        this.checkAndSetTypeResult(typeSymbol);
        if (this.resultFound) {
            return;
        }
        letExpressionNode.parent().accept((NodeVisitor)this);
    }

    public void visit(LetVariableDeclarationNode letVariableDeclarationNode) {
        Optional symbol1 = this.semanticModel.symbol((Node)letVariableDeclarationNode);
        symbol1.map(symbol -> (VariableSymbol)symbol).map(VariableSymbol::typeDescriptor).ifPresent(this::checkAndSetTypeResult);
    }

    public void visit(StartActionNode startActionNode) {
        startActionNode.parent().accept((NodeVisitor)this);
        if (this.resultFound && this.returnTypeSymbol.typeKind() == TypeDescKind.FUTURE) {
            FutureTypeSymbol futureTypeSymbol = (FutureTypeSymbol)this.returnTypeSymbol;
            TypeSymbol typeSymbol = futureTypeSymbol.typeParameter().orElse(null);
            this.checkAndSetTypeResult(typeSymbol);
        } else {
            TypeSymbol nilTypeSymbol = this.semanticModel.types().NIL;
            this.checkAndSetTypeResult(nilTypeSymbol);
        }
    }

    public void visit(FunctionCallExpressionNode fnCallExprNode) {
        fnCallExprNode.functionName().accept((NodeVisitor)this);
        if (this.resultFound) {
            return;
        }
        TypeSymbol typeSymbol = this.semanticModel.typeOf((Node)fnCallExprNode).orElse(null);
        this.checkAndSetTypeResult(typeSymbol);
        if (this.resultFound) {
            return;
        }
        fnCallExprNode.parent().accept((NodeVisitor)this);
    }

    public void visit(MethodCallExpressionNode methodCallExpressionNode) {
        methodCallExpressionNode.methodName().accept((NodeVisitor)this);
        if (this.resultFound) {
            return;
        }
        TypeSymbol typeSymbol = this.semanticModel.typeOf((Node)methodCallExpressionNode).orElse(null);
        this.checkAndSetTypeResult(typeSymbol);
    }

    public void visit(RemoteMethodCallActionNode remoteMethodCallActionNode) {
        remoteMethodCallActionNode.methodName().accept((NodeVisitor)this);
        if (this.resultFound) {
            return;
        }
        TypeSymbol typeSymbol = this.semanticModel.typeOf((Node)remoteMethodCallActionNode).orElse(null);
        this.checkAndSetTypeResult(typeSymbol);
    }

    public void visit(SimpleNameReferenceNode simpleNameReferenceNode) {
        this.semanticModel.symbol((Node)simpleNameReferenceNode).flatMap(SymbolUtil::getTypeDescriptor).ifPresent(this::checkAndSetTypeResult);
    }

    public void visit(ErrorConstructorExpressionNode errorConstructorExpressionNode) {
        this.semanticModel.typeOf((Node)errorConstructorExpressionNode).map(CommonUtil::getRawType).ifPresent(this::checkAndSetTypeResult);
    }

    public void visit(PositionalArgumentNode positionalArgumentNode) {
        SeparatedNodeList arguments;
        positionalArgumentNode.parent().accept((NodeVisitor)this);
        if (!this.resultFound) {
            return;
        }
        if (this.returnTypeSymbol.typeKind() == TypeDescKind.ERROR) {
            this.checkAndSetTypeResult(this.semanticModel.types().STRING);
            return;
        }
        Optional<List<ParameterSymbol>> params = this.getParameterSymbols();
        if (params.isEmpty() || params.get().isEmpty()) {
            return;
        }
        switch (positionalArgumentNode.parent().kind()) {
            case METHOD_CALL: {
                MethodCallExpressionNode methodCallExpressionNode = (MethodCallExpressionNode)positionalArgumentNode.parent();
                arguments = methodCallExpressionNode.arguments();
                break;
            }
            case FUNCTION_CALL: {
                FunctionCallExpressionNode functionCallExpressionNode = (FunctionCallExpressionNode)positionalArgumentNode.parent();
                arguments = functionCallExpressionNode.arguments();
                break;
            }
            case REMOTE_METHOD_CALL_ACTION: {
                RemoteMethodCallActionNode remoteMethodCallActionNode = (RemoteMethodCallActionNode)positionalArgumentNode.parent();
                arguments = remoteMethodCallActionNode.arguments();
                break;
            }
            case PARENTHESIZED_ARG_LIST: {
                ParenthesizedArgList parenthesizedArgList = (ParenthesizedArgList)positionalArgumentNode.parent();
                arguments = parenthesizedArgList.arguments();
                break;
            }
            default: {
                return;
            }
        }
        if (arguments != null) {
            int argIndex = -1;
            for (int i = 0; i < arguments.size(); ++i) {
                if (!((FunctionArgumentNode)arguments.get(i)).equals(positionalArgumentNode)) continue;
                argIndex = i;
                break;
            }
            if (argIndex < 0 || params.get().size() < argIndex + 1) {
                return;
            }
            ParameterSymbol parameterSymbol = params.get().get(argIndex);
            this.checkAndSetTypeResult(parameterSymbol.typeDescriptor());
        }
    }

    public void visit(NamedArgumentNode namedArgumentNode) {
        namedArgumentNode.parent().accept((NodeVisitor)this);
        if (!this.resultFound) {
            return;
        }
        if (this.returnTypeSymbol.typeKind() == TypeDescKind.ERROR) {
            ErrorTypeSymbol errorTypeSymbol = (ErrorTypeSymbol)this.returnTypeSymbol;
            TypeSymbol detailType = CommonUtil.getRawType(errorTypeSymbol.detailTypeDescriptor());
            if (detailType.typeKind() != TypeDescKind.RECORD) {
                this.checkAndSetTypeResult(this.semanticModel.types().ANYDATA);
                return;
            }
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)detailType;
            RecordFieldSymbol fieldSymbol = (RecordFieldSymbol)recordTypeSymbol.fieldDescriptors().get(namedArgumentNode.argumentName().name().text());
            if (fieldSymbol == null) {
                this.resetResult();
                return;
            }
            this.checkAndSetTypeResult(fieldSymbol.typeDescriptor());
            return;
        }
        Optional<List<ParameterSymbol>> params = this.getParameterSymbols();
        if (params.isEmpty()) {
            return;
        }
        params.get().stream().filter(param -> param.getName().isPresent() && ((String)param.getName().get()).equals(namedArgumentNode.argumentName().name().text())).findFirst().ifPresent(parameterSymbol -> this.checkAndSetTypeResult(parameterSymbol.typeDescriptor()));
    }

    private Optional<List<ParameterSymbol>> getParameterSymbols() {
        FunctionTypeSymbol functionTypeSymbol;
        if (this.returnTypeSymbol.typeKind() == TypeDescKind.FUNCTION) {
            functionTypeSymbol = (FunctionTypeSymbol)this.returnTypeSymbol;
        } else if (this.returnTypeSymbol.kind() == SymbolKind.CLASS) {
            Optional methodSymbol = ((ClassSymbol)this.returnTypeSymbol).initMethod();
            if (methodSymbol.isEmpty()) {
                return Optional.empty();
            }
            functionTypeSymbol = ((MethodSymbol)methodSymbol.get()).typeDescriptor();
        } else {
            return Optional.empty();
        }
        return functionTypeSymbol.params();
    }

    public void visit(ParenthesizedArgList parenthesizedArgList) {
        parenthesizedArgList.parent().accept((NodeVisitor)this);
    }

    public void visit(ExplicitNewExpressionNode explicitNewExpressionNode) {
        this.semanticModel.typeOf((Node)explicitNewExpressionNode).flatMap(typeSymbol -> Optional.of(CommonUtil.getRawType(typeSymbol))).stream().findFirst().ifPresent(this::checkAndSetTypeResult);
    }

    public void visit(ImplicitNewExpressionNode implicitNewExpressionNode) {
        this.semanticModel.typeOf((Node)implicitNewExpressionNode).flatMap(typeSymbol -> Optional.of(CommonUtil.getRawType(typeSymbol))).stream().findFirst().ifPresent(this::checkAndSetTypeResult);
    }

    public void visit(FunctionDefinitionNode node) {
        this.semanticModel.symbol((Node)node).flatMap(SymbolUtil::getTypeDescriptor).ifPresent(this::checkAndSetTypeResult);
    }

    public void visit(FunctionBodyBlockNode node) {
        node.parent().accept((NodeVisitor)this);
    }

    public void visit(BlockStatementNode node) {
        node.parent().accept((NodeVisitor)this);
    }

    public void visit(NamedWorkerDeclarationNode namedWorkerDeclarationNode) {
        this.semanticModel.symbol((Node)namedWorkerDeclarationNode).ifPresent(value -> this.checkAndSetTypeResult(((WorkerSymbol)value).returnType()));
    }

    public void visit(ReturnStatementNode returnStatementNode) {
        this.semanticModel.typeOf((Node)returnStatementNode).ifPresent(this::checkAndSetTypeResult);
        if (this.resultFound) {
            return;
        }
        returnStatementNode.parent().accept((NodeVisitor)this);
        if (!this.resultFound) {
            this.resetResult();
            return;
        }
        if (this.returnTypeSymbol.typeKind() == TypeDescKind.FUNCTION) {
            FunctionTypeSymbol functionTypeSymbol = (FunctionTypeSymbol)this.returnTypeSymbol;
            functionTypeSymbol.returnTypeDescriptor().ifPresentOrElse(this::checkAndSetTypeResult, this::resetResult);
        }
    }

    public void visit(UnaryExpressionNode unaryExpressionNode) {
        this.semanticModel.typeOf((Node)unaryExpressionNode).ifPresent(this::checkAndSetTypeResult);
        if (!this.resultFound) {
            this.checkAndSetTypeResult(this.semanticModel.types().BOOLEAN);
        }
    }

    public void visit(IfElseStatementNode node) {
        if (PositionUtil.isWithinLineRange(this.functionCallExpr.lineRange(), node.condition().lineRange())) {
            this.checkAndSetTypeResult(this.semanticModel.types().BOOLEAN);
            return;
        }
        node.parent().accept((NodeVisitor)this);
    }

    public void visit(FailStatementNode failStatementNode) {
        this.checkAndSetTypeResult(this.semanticModel.types().ERROR);
    }

    public void visit(WhileStatementNode whileStatementNode) {
        if (PositionUtil.isWithinLineRange(this.functionCallExpr.lineRange(), whileStatementNode.condition().lineRange())) {
            this.checkAndSetTypeResult(this.semanticModel.types().BOOLEAN);
            return;
        }
        whileStatementNode.parent().accept((NodeVisitor)this);
    }

    public void visit(ConditionalExpressionNode conditionalExpressionNode) {
        if (!conditionalExpressionNode.lhsExpression().isMissing() && PositionUtil.isWithinLineRange(this.functionCallExpr.lineRange(), conditionalExpressionNode.lhsExpression().lineRange())) {
            this.checkAndSetTypeResult(this.semanticModel.types().BOOLEAN);
            return;
        }
        Optional<TypeSymbol> typeSymbol = this.semanticModel.typeOf((Node)conditionalExpressionNode.middleExpression()).filter(type -> type.typeKind() != TypeDescKind.COMPILATION_ERROR).or(() -> this.semanticModel.typeOf((Node)conditionalExpressionNode.endExpression()).filter(type -> type.typeKind() != TypeDescKind.COMPILATION_ERROR));
        if (typeSymbol.isPresent()) {
            this.checkAndSetTypeResult(typeSymbol.get());
        } else {
            conditionalExpressionNode.parent().accept((NodeVisitor)this);
        }
    }

    public void visit(CheckExpressionNode checkExpressionNode) {
        if (checkExpressionNode.parent().kind() == SyntaxKind.CALL_STATEMENT) {
            this.checkAndSetTypeResult(this.semanticModel.types().ERROR);
        } else {
            checkExpressionNode.parent().accept((NodeVisitor)this);
        }
    }

    public void visit(GroupingKeyVarDeclarationNode groupingKeyVarDeclarationNode) {
        Symbol symbol = this.semanticModel.symbol((Node)groupingKeyVarDeclarationNode.typeDescriptor()).orElse(null);
        TypeSymbol typeDescriptor = SymbolUtil.getTypeDescriptor(symbol).orElse(null);
        this.checkAndSetTypeResult(typeDescriptor);
    }

    public void visit(SelectClauseNode selectClauseNode) {
        selectClauseNode.parent().parent().accept((NodeVisitor)this);
        if (this.resultFound) {
            TypeDescKind kind = this.returnTypeSymbol.typeKind();
            if (kind == TypeDescKind.ARRAY) {
                this.checkAndSetTypeResult(((ArrayTypeSymbol)this.returnTypeSymbol).memberTypeDescriptor());
            } else if (kind == TypeDescKind.STREAM) {
                this.checkAndSetTypeResult(((StreamTypeSymbol)this.returnTypeSymbol).typeParameter());
            }
        }
    }

    public void visit(ImplicitAnonymousFunctionExpressionNode expr) {
        TypeSymbol ts;
        Optional typeSymbol = this.semanticModel.typeOf((Node)expr);
        if (typeSymbol.isPresent() && (ts = (TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.FUNCTION) {
            ((FunctionTypeSymbol)ts).returnTypeDescriptor().ifPresent(this::checkAndSetTypeResult);
        }
    }

    public void visit(ExplicitAnonymousFunctionExpressionNode explicitAnonymousFunctionExpressionNode) {
        this.semanticModel.typeOf((Node)explicitAnonymousFunctionExpressionNode).ifPresent(this::checkAndSetTypeResult);
    }

    public void visit(PanicStatementNode panicStatementNode) {
        this.checkAndSetTypeResult(this.semanticModel.types().ERROR);
    }

    protected void visitSyntaxNode(Node node) {
    }

    private void checkAndSetTypeResult(TypeSymbol typeSymbol) {
        if (typeSymbol == null) {
            return;
        }
        this.returnTypeSymbol = typeSymbol;
        if (typeSymbol.typeKind() != TypeDescKind.COMPILATION_ERROR) {
            this.resultFound = true;
        }
    }

    private void resetResult() {
        this.returnTypeSymbol = null;
        this.resultFound = false;
    }

    public Optional<TypeSymbol> getReturnTypeSymbol() {
        return Optional.ofNullable(this.returnTypeSymbol);
    }

    private void visitVariableDeclaration(Node variableDeclarationNode, TypedBindingPatternNode typedBindingNode) {
        Symbol symbol = this.semanticModel.symbol(variableDeclarationNode).orElse(null);
        Optional<TypeSymbol> typeDescriptor = SymbolUtil.getTypeDescriptor(symbol);
        TypeSymbol ts = null;
        if (typeDescriptor.isPresent() && (ts = typeDescriptor.get()).typeKind() == TypeDescKind.COMPILATION_ERROR && typedBindingNode.typeDescriptor().kind() == SyntaxKind.VAR_TYPE_DESC) {
            Types types = this.semanticModel.types();
            ts = types.builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{types.ANY, types.ERROR}).build();
        }
        this.checkAndSetTypeResult(ts);
    }
}

