/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.RawTypeSymbolWrapper;
import org.ballerinalang.langserver.common.utils.RecordUtil;

public final class ConfigTomlValueGenerationUtil {
    private ConfigTomlValueGenerationUtil() {
    }

    public static TomlEntryValue getDefaultValueStr(TypeSymbol type, TypeSymbol basicType, TypeSymbol anydataOrJson, String confName) {
        switch (type.typeKind()) {
            case BOOLEAN: {
                return new TomlEntryValue("false", true);
            }
            case BYTE: 
            case INT: 
            case INT_SIGNED8: 
            case INT_SIGNED32: 
            case INT_UNSIGNED8: 
            case INT_UNSIGNED16: 
            case INT_UNSIGNED32: 
            case INT_SIGNED16: {
                return new TomlEntryValue("0", true);
            }
            case FLOAT: 
            case DECIMAL: {
                return new TomlEntryValue("0.0", true);
            }
            case STRING: 
            case XML: 
            case ANYDATA: 
            case JSON: 
            case SINGLETON: {
                return new TomlEntryValue("\"\"", true);
            }
            case TUPLE: {
                return new TomlEntryValue("[]", true);
            }
            case ARRAY: {
                ArrayTypeSymbol arrayTypeSymbol = (ArrayTypeSymbol)type;
                TypeSymbol memberType = CommonUtil.getRawType(arrayTypeSymbol.memberTypeDescriptor());
                if (memberType.typeKind() == TypeDescKind.UNION) {
                    memberType = (TypeSymbol)((UnionTypeSymbol)memberType).memberTypeDescriptors().get(0);
                }
                if (memberType.subtypeOf(basicType) || basicType.subtypeOf(anydataOrJson)) {
                    return new TomlEntryValue("[]", true);
                }
                return new TomlEntryValue(String.format("[[%s]]%n", confName), false);
            }
            case MAP: {
                return new TomlEntryValue(String.format("[%s]%n", confName), false);
            }
            case RECORD: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.format("[%s]%n", confName));
                ConfigTomlValueGenerationUtil.getRecordFields((RecordTypeSymbol)type, stringBuilder, "");
                return new TomlEntryValue(stringBuilder.toString(), false);
            }
            case TABLE: {
                return new TomlEntryValue(String.format("[[%s]]%n", confName), false);
            }
            case UNION: {
                return ConfigTomlValueGenerationUtil.getDefaultValueStr((TypeSymbol)((UnionTypeSymbol)type).memberTypeDescriptors().get(0), basicType, anydataOrJson, confName);
            }
            case TYPE_REFERENCE: {
                return ConfigTomlValueGenerationUtil.getDefaultValueStr(CommonUtil.getRawType(type), basicType, anydataOrJson, confName);
            }
        }
        return new TomlEntryValue("", true);
    }

    private static StringBuilder getRecordFields(RecordTypeSymbol recordTypeSymbol, StringBuilder builder, String prefix) {
        List<RawTypeSymbolWrapper<RecordTypeSymbol>> recordTypeSymbols = RecordUtil.getRecordTypeSymbols((TypeSymbol)recordTypeSymbol);
        ArrayList<RecordFieldSymbol> validFields = new ArrayList<RecordFieldSymbol>();
        for (RawTypeSymbolWrapper<RecordTypeSymbol> symbol : recordTypeSymbols) {
            validFields.addAll(RecordUtil.getRecordFields(symbol, Collections.emptyList()).values());
        }
        for (RecordFieldSymbol recordFieldSymbol : validFields) {
            TypeSymbol typeSymbol = CommonUtil.getRawType(recordFieldSymbol.typeDescriptor());
            if (typeSymbol.typeKind() == TypeDescKind.RECORD) {
                String nestedPrefix = prefix + (String)recordFieldSymbol.getName().get() + ".";
                ConfigTomlValueGenerationUtil.getRecordFields((RecordTypeSymbol)typeSymbol, builder, nestedPrefix);
                continue;
            }
            builder.append(String.format("%s%s = %s%n", prefix, recordFieldSymbol.getName().get(), ConfigTomlValueGenerationUtil.getValueForObjectKey(typeSymbol)));
        }
        return builder;
    }

    private static String getValueForObjectKey(TypeSymbol type) {
        switch (type.typeKind()) {
            case BOOLEAN: {
                return "false";
            }
            case BYTE: 
            case INT: 
            case INT_SIGNED8: 
            case INT_SIGNED32: 
            case INT_UNSIGNED8: 
            case INT_UNSIGNED16: 
            case INT_UNSIGNED32: 
            case INT_SIGNED16: {
                return "0";
            }
            case FLOAT: 
            case DECIMAL: {
                return "0.0";
            }
            case STRING: 
            case XML: 
            case ANYDATA: 
            case JSON: 
            case SINGLETON: {
                return "\"\"";
            }
            case TUPLE: 
            case ARRAY: 
            case TABLE: {
                return "[]";
            }
            case MAP: {
                return "{}";
            }
        }
        return "";
    }

    public record TomlEntryValue(String value, boolean keyValue) {
    }
}

