/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.LSPackageLoader;
import org.ballerinalang.langserver.codeaction.CodeActionModuleId;
import org.ballerinalang.langserver.common.ImportsAcceptor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.wso2.ballerinalang.compiler.util.Names;

public final class ModuleUtil {
    private ModuleUtil() {
    }

    public static Optional<TypeSymbol> getTypeFromModule(BallerinaCompletionContext context, String alias, String typeName) {
        Optional<ModuleSymbol> module = ModuleUtil.searchModuleForAlias((PositionedOperationContext)context, alias);
        if (module.isEmpty()) {
            return Optional.empty();
        }
        ModuleSymbol moduleSymbol = module.get();
        for (TypeDefinitionSymbol typeDefinitionSymbol : moduleSymbol.typeDefinitions()) {
            if (!typeDefinitionSymbol.getName().isPresent() || !((String)typeDefinitionSymbol.getName().get()).equals(typeName)) continue;
            return Optional.of(typeDefinitionSymbol.typeDescriptor());
        }
        for (ClassSymbol clazz : moduleSymbol.classes()) {
            if (!clazz.getName().isPresent() || !((String)clazz.getName().get()).equals(typeName)) continue;
            return Optional.of(clazz);
        }
        return Optional.empty();
    }

    public static Optional<ModuleSymbol> searchModuleForAlias(PositionedOperationContext context, String alias) {
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        for (Symbol symbol : visibleSymbols) {
            if (symbol.kind() != SymbolKind.MODULE || !Objects.equals(symbol.getName().orElse(null), alias)) continue;
            return Optional.of((ModuleSymbol)symbol);
        }
        return Optional.empty();
    }

    public static String getModulePrefix(ImportsAcceptor importsAcceptor, ModuleID currentModuleId, ModuleID moduleID, DocumentServiceContext context) {
        String pkgPrefix = "";
        if (!moduleID.equals((Object)currentModuleId)) {
            boolean preDeclaredLangLib = moduleID.orgName().equals("ballerina") && CommonUtil.PRE_DECLARED_LANG_LIBS.contains(moduleID.moduleName());
            String escapeModuleName = ModuleUtil.escapeModuleName(moduleID.orgName() + "/" + moduleID.moduleName());
            String[] moduleParts = escapeModuleName.split("/");
            String orgName = moduleParts[0];
            String moduleName = moduleParts[1];
            pkgPrefix = moduleName.replaceAll(".*\\.", "");
            pkgPrefix = !preDeclaredLangLib && CommonUtil.BALLERINA_KEYWORDS.contains(pkgPrefix) ? "'" + pkgPrefix : pkgPrefix;
            List<ImportDeclarationNode> existingModuleImports = context.currentDocImportsMap().keySet().stream().filter(importDeclarationNode -> CodeActionModuleId.from(importDeclarationNode).moduleName().equals(moduleID.moduleName())).toList();
            if (existingModuleImports.size() == 1) {
                ImportDeclarationNode importDeclarationNode2 = existingModuleImports.get(0);
                if (importDeclarationNode2.prefix().isPresent()) {
                    pkgPrefix = ((ImportPrefixNode)importDeclarationNode2.prefix().get()).prefix().text();
                }
            } else if (existingModuleImports.isEmpty() && context instanceof PositionedOperationContext) {
                PositionedOperationContext positionedOperationContext = (PositionedOperationContext)context;
                pkgPrefix = NameUtil.getValidatedSymbolName(positionedOperationContext, pkgPrefix);
            }
            CodeActionModuleId codeActionModuleId = CodeActionModuleId.from(orgName, moduleName, pkgPrefix, moduleID.version());
            if (importsAcceptor != null && !preDeclaredLangLib) {
                importsAcceptor.getAcceptor(context).accept(orgName, codeActionModuleId);
            }
            return pkgPrefix + ":";
        }
        return pkgPrefix;
    }

    public static String getModulePrefix(DocumentServiceContext context, String orgName, String modName) {
        Project project = (Project)context.workspace().project(context.filePath()).orElseThrow();
        String currentProjectOrg = project.currentPackage().packageOrg().value();
        boolean isCurrentOrg = currentProjectOrg.equals(orgName);
        Optional currentModule = context.currentModule();
        String evalOrgName = isCurrentOrg ? "" : orgName;
        Optional<ImportDeclarationNode> matchedImport = ModuleUtil.matchingImportedModule(context, evalOrgName, modName);
        if (currentModule.isPresent() && modName.equals(ModuleUtil.getQualifiedModuleName((Module)currentModule.get()))) {
            return "";
        }
        if (matchedImport.isPresent()) {
            Optional prefix = matchedImport.get().prefix();
            if (prefix.isPresent()) {
                return ((ImportPrefixNode)prefix.get()).prefix().text();
            }
            SeparatedNodeList moduleComponents = matchedImport.get().moduleName();
            return ((IdentifierToken)moduleComponents.get(moduleComponents.size() - 1)).text();
        }
        String[] modNameComponents = modName.split("\\.");
        return modNameComponents[modNameComponents.length - 1];
    }

    public static String escapeModuleName(String qualifiedModuleName) {
        String[] moduleNameParts = qualifiedModuleName.split("/");
        if (moduleNameParts.length > 1) {
            boolean preDeclaredLangLib;
            String orgName = moduleNameParts[0];
            Object alias = moduleNameParts[1];
            String[] aliasParts = moduleNameParts[1].split("\\.");
            boolean bl = preDeclaredLangLib = "ballerina".equals(orgName) && CommonUtil.PRE_DECLARED_LANG_LIBS.contains(alias);
            if (aliasParts.length > 1) {
                Object aliasLastPart = aliasParts[aliasParts.length - 1];
                if (CommonUtil.BALLERINA_KEYWORDS.contains(aliasLastPart) && !preDeclaredLangLib) {
                    aliasLastPart = "'" + (String)aliasLastPart;
                }
                String aliasPart = Arrays.stream(aliasParts, 0, aliasParts.length - 1).collect(Collectors.joining("."));
                alias = aliasPart + "." + (String)aliasLastPart;
            } else if (CommonUtil.BALLERINA_KEYWORDS.contains(alias) && !preDeclaredLangLib) {
                alias = "'" + (String)alias;
            }
            return orgName + "/" + (String)alias;
        }
        return qualifiedModuleName;
    }

    public static Optional<ImportDeclarationNode> matchingImportedModule(CompletionContext context, LSPackageLoader.ModuleInfo module) {
        String name = module.packageName();
        String orgName = module.packageOrg();
        Map currentDocImports = context.currentDocImportsMap();
        return currentDocImports.keySet().stream().filter(importPkg -> importPkg.orgName().isPresent() && ((ImportOrgNameNode)importPkg.orgName().get()).orgName().text().equals(orgName) && ModuleUtil.getPackageNameComponentsCombined(importPkg).equals(name)).findFirst();
    }

    public static Optional<ImportDeclarationNode> matchingImportedModule(DocumentServiceContext context, String orgName, String modName) {
        Map currentDocImports = context.currentDocImportsMap();
        return currentDocImports.keySet().stream().filter(importPkg -> (importPkg.orgName().isEmpty() || ((ImportOrgNameNode)importPkg.orgName().get()).orgName().text().equals(orgName)) && ModuleUtil.getPackageNameComponentsCombined(importPkg).equals(modName)).findFirst();
    }

    public static String getPackageNameComponentsCombined(ImportDeclarationNode importNode) {
        return importNode.moduleName().stream().map(Token::text).collect(Collectors.joining("."));
    }

    private static String getQualifiedModuleName(Module module) {
        if (module.isDefaultModule()) {
            return module.moduleName().packageName().value();
        }
        return module.moduleName().packageName().value() + Names.DOT.getValue() + module.moduleName().moduleNamePart();
    }
}

