/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import java.util.Optional;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class PositionUtil {
    private PositionUtil() {
    }

    public static Range toRange(LineRange lineRange) {
        return new Range(PositionUtil.toPosition(lineRange.startLine()), PositionUtil.toPosition(lineRange.endLine()));
    }

    public static Range toRange(LinePosition linePosition) {
        return new Range(PositionUtil.toPosition(linePosition), PositionUtil.toPosition(linePosition));
    }

    public static Position toPosition(LinePosition linePosition) {
        return new Position(linePosition.line(), linePosition.offset());
    }

    public static Range toRange(int startOffset, int endOffset, TextDocument document) {
        LinePosition startPos = document.linePositionFrom(startOffset);
        LinePosition endPos = document.linePositionFrom(endOffset);
        return new Range(PositionUtil.toPosition(startPos), PositionUtil.toPosition(endPos));
    }

    public static boolean isWithinLineRange(Position pos, LineRange lineRange) {
        int sLine = lineRange.startLine().line();
        int sCol = lineRange.startLine().offset();
        int eLine = lineRange.endLine().line();
        int eCol = lineRange.endLine().offset();
        return sLine == eLine && pos.getLine() == sLine && pos.getCharacter() >= sCol && pos.getCharacter() <= eCol || sLine != eLine && (pos.getLine() > sLine && pos.getLine() < eLine || pos.getLine() == eLine && pos.getCharacter() <= eCol || pos.getLine() == sLine && pos.getCharacter() >= sCol);
    }

    public static boolean isWithinLineRange(LineRange lineRange, LineRange enclosingRange) {
        Position start = PositionUtil.toPosition(lineRange.startLine());
        Position end = PositionUtil.toPosition(lineRange.endLine());
        return PositionUtil.isWithinLineRange(start, enclosingRange) && PositionUtil.isWithinLineRange(end, enclosingRange);
    }

    public static boolean isWithinRange(Position pos, Range range) {
        int sLine = range.getStart().getLine();
        int sCol = range.getStart().getCharacter();
        int eLine = range.getEnd().getLine();
        int eCol = range.getEnd().getCharacter();
        return sLine == eLine && pos.getLine() == sLine && pos.getCharacter() >= sCol && pos.getCharacter() <= eCol || sLine != eLine && (pos.getLine() > sLine && pos.getLine() < eLine || pos.getLine() == eLine && pos.getCharacter() <= eCol || pos.getLine() == sLine && pos.getCharacter() >= sCol);
    }

    public static boolean isRangeWithinRange(Range range, Range enclosingRange) {
        return PositionUtil.isWithinRange(range.getStart(), enclosingRange) && PositionUtil.isWithinRange(range.getEnd(), enclosingRange);
    }

    public static boolean isWithInRange(Node node, int offset) {
        return node.textRange().startOffset() <= offset && offset <= node.textRange().endOffset();
    }

    public static Optional<Token> findTokenAtPosition(DocumentServiceContext context, Position position) {
        Optional document = context.currentDocument();
        if (document.isEmpty()) {
            return Optional.empty();
        }
        TextDocument textDocument = ((Document)document.get()).textDocument();
        int txtPos = textDocument.textPositionFrom(LinePosition.from((int)position.getLine(), (int)position.getCharacter()));
        Token tokenAtPosition = ((ModulePartNode)((Document)document.get()).syntaxTree().rootNode()).findToken(txtPos, true);
        return Optional.ofNullable(tokenAtPosition);
    }

    public static int getPositionOffset(Position position, SyntaxTree syntaxTree) {
        LinePosition linePos = LinePosition.from((int)position.getLine(), (int)position.getCharacter());
        return syntaxTree.textDocument().textPositionFrom(linePos);
    }

    public static Range getRangeFromLineRange(LineRange lineRange) {
        return new Range(PositionUtil.toPosition(lineRange.startLine()), PositionUtil.toPosition(lineRange.endLine()));
    }

    public static LinePosition getLinePosition(Position position) {
        return LinePosition.from((int)position.getLine(), (int)position.getCharacter());
    }
}

