/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ClassFieldSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ObjectFieldSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.completions.CompletionSearchProvider;

public final class SymbolUtil {
    public static final String SELF_KW = "self";

    private SymbolUtil() {
    }

    @Deprecated(forRemoval=true)
    public static boolean isObject(Symbol symbol) {
        ClassSymbol typeDescriptor;
        switch (symbol.kind()) {
            case TYPE_DEFINITION: {
                typeDescriptor = ((TypeDefinitionSymbol)symbol).typeDescriptor();
                break;
            }
            case VARIABLE: {
                typeDescriptor = ((VariableSymbol)symbol).typeDescriptor();
                break;
            }
            case PARAMETER: {
                typeDescriptor = ((ParameterSymbol)symbol).typeDescriptor();
                break;
            }
            case CLASS: {
                typeDescriptor = (ClassSymbol)symbol;
                break;
            }
            case TYPE: {
                typeDescriptor = (TypeSymbol)symbol;
                break;
            }
            default: {
                return false;
            }
        }
        return CommonUtil.getRawType((TypeSymbol)typeDescriptor).typeKind() == TypeDescKind.OBJECT;
    }

    @Deprecated(forRemoval=true)
    public static boolean isClass(Symbol symbol) {
        TypeSymbol typeDescriptor;
        switch (symbol.kind()) {
            case TYPE: {
                typeDescriptor = ((TypeDefinitionSymbol)symbol).typeDescriptor();
                break;
            }
            case VARIABLE: {
                typeDescriptor = ((VariableSymbol)symbol).typeDescriptor();
                break;
            }
            case CLASS: {
                return true;
            }
            default: {
                return false;
            }
        }
        return CommonUtil.getRawType(typeDescriptor).kind() == SymbolKind.CLASS;
    }

    public static boolean isClassDefinition(Symbol symbol) {
        if (symbol.kind() == SymbolKind.CLASS) {
            return true;
        }
        if (symbol.kind() == SymbolKind.TYPE_DEFINITION) {
            return CommonUtil.getRawType(((TypeDefinitionSymbol)symbol).typeDescriptor()).kind() == SymbolKind.CLASS;
        }
        return false;
    }

    public static boolean isClassVariable(Symbol variableSymbol) {
        if (variableSymbol.kind() != SymbolKind.VARIABLE) {
            return false;
        }
        TypeSymbol typeSymbol = ((VariableSymbol)variableSymbol).typeDescriptor();
        return CommonUtil.getRawType(typeSymbol).kind() == SymbolKind.CLASS;
    }

    @Deprecated(forRemoval=true)
    public static boolean isRecord(Symbol symbol) {
        TypeSymbol typeDescriptor;
        switch (symbol.kind()) {
            case TYPE_DEFINITION: {
                typeDescriptor = ((TypeDefinitionSymbol)symbol).typeDescriptor();
                break;
            }
            case VARIABLE: {
                typeDescriptor = ((VariableSymbol)symbol).typeDescriptor();
                break;
            }
            default: {
                return false;
            }
        }
        return CommonUtil.getRawType(typeDescriptor).typeKind() == TypeDescKind.RECORD;
    }

    public static boolean isRecordTypeDefinition(Symbol symbol) {
        if (symbol.kind() != SymbolKind.TYPE_DEFINITION) {
            return false;
        }
        TypeSymbol typeDescriptor = ((TypeDefinitionSymbol)symbol).typeDescriptor();
        return CommonUtil.getRawType(typeDescriptor).typeKind() == TypeDescKind.RECORD;
    }

    public static boolean isRecordVariable(Symbol variableSymbol) {
        if (variableSymbol.kind() != SymbolKind.VARIABLE) {
            return false;
        }
        TypeSymbol typeSymbol = ((VariableSymbol)variableSymbol).typeDescriptor();
        return CommonUtil.getRawType(typeSymbol).typeKind() == TypeDescKind.RECORD;
    }

    public static Optional<TypeSymbol> getTypeDescriptor(Symbol symbol) {
        if (symbol == null) {
            return Optional.empty();
        }
        return switch (symbol.kind()) {
            case SymbolKind.TYPE_DEFINITION -> Optional.ofNullable(((TypeDefinitionSymbol)symbol).typeDescriptor());
            case SymbolKind.VARIABLE -> Optional.ofNullable(((VariableSymbol)symbol).typeDescriptor());
            case SymbolKind.PARAMETER -> Optional.ofNullable(((ParameterSymbol)symbol).typeDescriptor());
            case SymbolKind.ANNOTATION -> ((AnnotationSymbol)symbol).typeDescriptor();
            case SymbolKind.FUNCTION, SymbolKind.METHOD -> Optional.ofNullable(((FunctionSymbol)symbol).typeDescriptor());
            case SymbolKind.CONSTANT, SymbolKind.ENUM_MEMBER -> Optional.ofNullable(((ConstantSymbol)symbol).typeDescriptor());
            case SymbolKind.CLASS -> Optional.of((ClassSymbol)symbol);
            case SymbolKind.RECORD_FIELD -> Optional.ofNullable(((RecordFieldSymbol)symbol).typeDescriptor());
            case SymbolKind.OBJECT_FIELD -> Optional.of(((ObjectFieldSymbol)symbol).typeDescriptor());
            case SymbolKind.CLASS_FIELD -> Optional.of(((ClassFieldSymbol)symbol).typeDescriptor());
            case SymbolKind.TYPE -> Optional.of((TypeSymbol)symbol);
            default -> Optional.empty();
        };
    }

    public static ObjectTypeSymbol getTypeDescForObjectSymbol(Symbol symbol) {
        Optional<TypeSymbol> typeDescriptor = SymbolUtil.getTypeDescriptor(symbol);
        if (typeDescriptor.isEmpty() || !SymbolUtil.isObject(symbol)) {
            throw new UnsupportedOperationException("Cannot find a valid type descriptor");
        }
        return (ObjectTypeSymbol)CommonUtil.getRawType(typeDescriptor.get());
    }

    public static ClassSymbol getTypeDescForClassSymbol(Symbol symbol) {
        Optional<TypeSymbol> typeDescriptor = SymbolUtil.getTypeDescriptor(symbol);
        if (typeDescriptor.isEmpty() || !SymbolUtil.isObject(symbol)) {
            throw new UnsupportedOperationException("Cannot find a valid type descriptor");
        }
        return (ClassSymbol)CommonUtil.getRawType(typeDescriptor.get());
    }

    public static RecordTypeSymbol getTypeDescForRecordSymbol(Symbol symbol) {
        Optional<TypeSymbol> typeDescriptor = SymbolUtil.getTypeDescriptor(symbol);
        if (typeDescriptor.isEmpty() || !SymbolUtil.isRecord(symbol)) {
            throw new UnsupportedOperationException("Cannot find a valid type descriptor");
        }
        return (RecordTypeSymbol)CommonUtil.getRawType(typeDescriptor.get());
    }

    public static boolean isListener(Symbol symbol) {
        Optional<TypeSymbol> symbolTypeDesc = SymbolUtil.getTypeDescriptor(symbol);
        if (symbolTypeDesc.isEmpty() || CommonUtil.getRawType(symbolTypeDesc.get()).kind() != SymbolKind.CLASS) {
            return false;
        }
        Map attachedMethods = ((ClassSymbol)CommonUtil.getRawType(symbolTypeDesc.get())).methods();
        return attachedMethods.containsKey("start") && attachedMethods.containsKey("immediateStop") && attachedMethods.containsKey("attach");
    }

    public static boolean isClient(Symbol symbol) {
        if (!SymbolUtil.isObject(symbol)) {
            return false;
        }
        ObjectTypeSymbol typeDesc = SymbolUtil.getTypeDescForObjectSymbol(symbol);
        return typeDesc.qualifiers().contains(Qualifier.CLIENT);
    }

    @Deprecated(forRemoval=true)
    public static boolean isError(Symbol symbol) {
        if (symbol.kind() != SymbolKind.VARIABLE) {
            return false;
        }
        TypeSymbol typeDescriptor = ((VariableSymbol)symbol).typeDescriptor();
        return typeDescriptor.typeKind() == TypeDescKind.ERROR;
    }

    @Deprecated(forRemoval=true)
    public static Optional<TypeDescKind> getTypeKind(Symbol symbol) {
        if (symbol.kind() != SymbolKind.VARIABLE) {
            return Optional.empty();
        }
        return Optional.ofNullable(((VariableSymbol)symbol).typeDescriptor().typeKind());
    }

    public static Predicate<Symbol> isOfType(TypeDescKind typeDescKind) {
        return symbol -> symbol.kind() == SymbolKind.TYPE_DEFINITION && CommonUtil.getRawType(((TypeDefinitionSymbol)symbol).typeDescriptor()).typeKind() == typeDescKind;
    }

    public static boolean isOfType(Symbol symbol, TypeDescKind typeDescKind) {
        return symbol.kind() == SymbolKind.TYPE_DEFINITION && CommonUtil.getRawType(((TypeDefinitionSymbol)symbol).typeDescriptor()).typeKind() == typeDescKind;
    }

    public static boolean isSelfClassSymbol(Symbol symbol, PositionedOperationContext context, @Nonnull ModuleMemberDeclarationNode enclosedModuleMember) {
        Optional name = symbol.getName();
        if (enclosedModuleMember.kind() != SyntaxKind.CLASS_DEFINITION || symbol.kind() != SymbolKind.VARIABLE || name.isEmpty() || !((String)name.get()).equals(SELF_KW)) {
            return false;
        }
        Optional memberSymbol = context.workspace().semanticModel(context.filePath()).flatMap(semanticModel -> semanticModel.symbol((Node)enclosedModuleMember));
        if (memberSymbol.isEmpty() || ((Symbol)memberSymbol.get()).kind() != SymbolKind.CLASS) {
            return false;
        }
        ClassSymbol classSymbol = (ClassSymbol)memberSymbol.get();
        VariableSymbol selfSymbol = (VariableSymbol)symbol;
        TypeSymbol varTypeSymbol = CommonUtil.getRawType(selfSymbol.typeDescriptor());
        return classSymbol.equals((Object)varTypeSymbol);
    }

    public static boolean isSelfObjectSymbol(Symbol symbol, Node nodeAtCursor) {
        Node currentNode;
        for (currentNode = nodeAtCursor; currentNode != null && currentNode.kind() != SyntaxKind.OBJECT_CONSTRUCTOR; currentNode = currentNode.parent()) {
        }
        return currentNode != null && currentNode.kind() == SyntaxKind.OBJECT_CONSTRUCTOR && symbol.getName().orElse("").equals(SELF_KW);
    }

    public static List<Symbol> filterSymbolsByPrefix(List<Symbol> symbolList, BallerinaCompletionContext context, String prefix, ModuleID moduleId) {
        if (prefix.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Symbol> symbolMapWithoutPrefix = new HashMap<String, Symbol>();
        HashMap<String, Symbol> symbolMapWithPrefix = new HashMap<String, Symbol>();
        for (Symbol symbol2 : symbolList) {
            if (symbol2.getName().isEmpty()) continue;
            String symbolName = (String)symbol2.getName().get();
            symbolMapWithoutPrefix.put(symbolName, symbol2);
            if (moduleId.modulePrefix().isEmpty()) {
                symbolMapWithPrefix.put(moduleId.moduleName() + ":" + symbolName, symbol2);
                continue;
            }
            symbolMapWithPrefix.put(moduleId.modulePrefix() + ":" + symbolName, symbol2);
        }
        CompletionSearchProvider completionSearchProvider = CompletionSearchProvider.getInstance(context.languageServercontext());
        if (!completionSearchProvider.checkModuleIndexed(moduleId)) {
            completionSearchProvider.indexModuleAndModuleSymbolNames(moduleId, symbolList.stream().map(symbol -> (String)symbol.getName().get()).toList(), new ArrayList<String>(symbolMapWithPrefix.keySet()));
        }
        List<String> stringList = completionSearchProvider.getSuggestions(prefix);
        if (symbolMapWithoutPrefix.entrySet().stream().anyMatch(stringSymbolEntry -> stringList.contains(((String)stringSymbolEntry.getKey()).toLowerCase()))) {
            return SymbolUtil.getFilteredList(symbolMapWithoutPrefix, stringList);
        }
        return SymbolUtil.getFilteredList(symbolMapWithPrefix, stringList);
    }

    private static List<Symbol> getFilteredList(Map<String, Symbol> symbolMap, List<String> stringList) {
        return symbolMap.entrySet().stream().filter(stringSymbolEntry -> stringList.contains(((String)stringSymbolEntry.getKey()).toLowerCase())).map(Map.Entry::getValue).toList();
    }
}

