/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.projects.CompletionManager;
import io.ballerina.projects.CompletionResult;
import io.ballerina.projects.Document;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.plugins.completion.CompletionContext;
import io.ballerina.projects.plugins.completion.CompletionContextImpl;
import io.ballerina.projects.plugins.completion.CompletionItem;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CompletionExtension;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class CompilerPluginCompletionExtension
implements CompletionExtension {
    public boolean validate(CompletionParams inputParams) {
        return inputParams.getTextDocument().getUri().endsWith(".bal");
    }

    public List<CompletionItem> execute(CompletionParams inputParams, org.ballerinalang.langserver.commons.CompletionContext context, LanguageServerContext serverContext) {
        return Collections.emptyList();
    }

    public List<CompletionItem> execute(CompletionParams inputParams, org.ballerinalang.langserver.commons.CompletionContext context, LanguageServerContext serverContext, CancelChecker cancelChecker) {
        CompletionContextImpl completionContextImp;
        Optional packageCompilation = context.workspace().waitAndGetPackageCompilation(context.filePath());
        if (packageCompilation.isEmpty() || context.currentDocument().isEmpty() || context.currentSemanticModel().isEmpty()) {
            return Collections.emptyList();
        }
        LSClientLogger clientLogger = LSClientLogger.getInstance(context.languageServercontext());
        CompletionManager completionManager = ((PackageCompilation)packageCompilation.get()).getCompletionManager();
        CompletionResult result = completionManager.completions((CompletionContext)(completionContextImp = CompilerPluginCompletionExtension.getCompletionContext(context)));
        if (!result.getErrors().isEmpty()) {
            result.getErrors().forEach(ex -> clientLogger.logError(LSContextOperation.TXT_COMPLETION, "Exception thrown while getting completion items from: " + ex.getProviderName(), ex.getCause(), new TextDocumentIdentifier(context.fileUri()), new Position[0]));
        }
        return result.getCompletionItems().stream().map(completionItem -> {
            CompletionItem item = new CompletionItem();
            item.setLabel(completionItem.getLabel());
            item.setDetail("Snippet");
            item.setInsertText(completionItem.getInsertText());
            item.setKind(CompletionItemKind.Snippet);
            item.setInsertTextFormat(InsertTextFormat.Snippet);
            if (completionItem.getPriority() == CompletionItem.Priority.HIGH) {
                item.setSortText(SortingUtil.genSortText(1) + SortingUtil.genSortText(16));
            } else {
                item.setSortText(SortingUtil.genSortText(16));
            }
            if (completionItem.getAdditionalTextEdits() != null) {
                item.setAdditionalTextEdits(completionItem.getAdditionalTextEdits().stream().map(textEdit -> {
                    TextRange textRange = textEdit.range();
                    Range range = PositionUtil.toRange(textRange.startOffset(), textRange.endOffset(), ((Document)context.currentDocument().get()).textDocument());
                    TextEdit lsp4jTextEdit = new TextEdit();
                    lsp4jTextEdit.setNewText(textEdit.text());
                    lsp4jTextEdit.setRange(range);
                    return lsp4jTextEdit;
                }).toList());
            }
            return item;
        }).toList();
    }

    public List<String> handledCustomURISchemes(CompletionParams inputParams, org.ballerinalang.langserver.commons.CompletionContext context, LanguageServerContext serverContext) {
        return Collections.singletonList("expr");
    }

    public static CompletionContextImpl getCompletionContext(org.ballerinalang.langserver.commons.CompletionContext context) {
        Optional document = context.currentDocument();
        if (document.isEmpty()) {
            throw new RuntimeException("Could not find a valid document/token");
        }
        TextDocument textDocument = ((Document)document.get()).textDocument();
        Position position = context.getCursorPosition();
        int txtPos = textDocument.textPositionFrom(LinePosition.from((int)position.getLine(), (int)position.getCharacter()));
        context.setCursorPositionInTree(txtPos);
        TextRange range = TextRange.from((int)txtPos, (int)0);
        NonTerminalNode nodeAtCursor = ((ModulePartNode)((Document)document.get()).syntaxTree().rootNode()).findNode(range);
        Position cursorPos = context.getCursorPosition();
        int cursorPosInTree = context.getCursorPositionInTree();
        LinePosition linePosition = LinePosition.from((int)cursorPos.getLine(), (int)cursorPos.getCharacter());
        SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().get();
        return CompletionContextImpl.from((String)context.fileUri(), (Path)context.filePath(), (LinePosition)linePosition, (int)cursorPosInTree, (Node)nodeAtCursor, (Document)((Document)document.get()), (SemanticModel)semanticModel);
    }
}

