/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions;

import io.ballerina.compiler.api.ModuleID;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.ballerinalang.langserver.common.Trie;
import org.ballerinalang.langserver.commons.LanguageServerContext;

public class CompletionSearchProvider {
    private final Trie trie;
    private final Set<ModuleID> indexedModules = new HashSet<ModuleID>();
    public static final LanguageServerContext.Key<CompletionSearchProvider> SEARCH_PROVIDER_KEY = new LanguageServerContext.Key();

    public static CompletionSearchProvider getInstance(LanguageServerContext context) {
        CompletionSearchProvider completionSearchProvider = (CompletionSearchProvider)context.get(SEARCH_PROVIDER_KEY);
        if (completionSearchProvider == null) {
            completionSearchProvider = new CompletionSearchProvider(context);
        }
        return completionSearchProvider;
    }

    private CompletionSearchProvider(LanguageServerContext context) {
        this.trie = new Trie(Collections.emptyList());
        context.put(SEARCH_PROVIDER_KEY, (Object)this);
    }

    public List<String> getSuggestions(String prefix) {
        return this.trie.suggest(prefix);
    }

    public void indexModuleAndModuleSymbolNames(ModuleID moduleName, List<String> stringList, List<String> namesWithModulePrefix) {
        this.indexedModules.add(moduleName);
        this.indexNames(stringList);
        this.indexNames(namesWithModulePrefix);
    }

    public boolean checkModuleIndexed(ModuleID moduleName) {
        return this.indexedModules.contains(moduleName);
    }

    public void indexNames(List<String> names) {
        names.forEach(s -> this.trie.root.insert(s.toLowerCase(Locale.ENGLISH)));
    }
}

