/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions;

import io.ballerina.compiler.syntax.tree.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.ballerinalang.langserver.commons.completion.spi.BallerinaCompletionProvider;

public class ProviderFactory {
    private static final Map<Class<?>, BallerinaCompletionProvider<Node>> providers = new HashMap();
    private static final ProviderFactory INSTANCE = new ProviderFactory();

    private ProviderFactory() {
        ServiceLoader<BallerinaCompletionProvider> providerServices = ServiceLoader.load(BallerinaCompletionProvider.class);
        for (BallerinaCompletionProvider provider : providerServices) {
            if (provider == null) continue;
            for (Class attachmentPoint : provider.getAttachmentPoints()) {
                if (providers.containsKey(attachmentPoint) && (providers.get(attachmentPoint).getPrecedence() != BallerinaCompletionProvider.Precedence.LOW || provider.getPrecedence() != BallerinaCompletionProvider.Precedence.HIGH)) continue;
                providers.put(attachmentPoint, (BallerinaCompletionProvider<Node>)provider);
            }
        }
    }

    public static ProviderFactory instance() {
        return INSTANCE;
    }

    public void register(BallerinaCompletionProvider<Node> provider) {
        for (Class attachmentPoint : provider.getAttachmentPoints()) {
            providers.put(attachmentPoint, provider);
        }
    }

    public void unregister(BallerinaCompletionProvider<?> provider) {
        for (Class attachmentPoint : provider.getAttachmentPoints()) {
            providers.remove(attachmentPoint, provider);
        }
    }

    public Map<Class<?>, BallerinaCompletionProvider<Node>> getProviders() {
        return providers;
    }

    public BallerinaCompletionProvider<?> getProvider(Class<?> key) {
        return providers.get(key);
    }
}

