/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions;

import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.completion.AbstractLSCompletionItem;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.builder.FieldCompletionItemBuilder;
import org.eclipse.lsp4j.CompletionItem;

public class RecordFieldCompletionItem
extends AbstractLSCompletionItem {
    private final RecordFieldSymbol fieldSymbol;

    public RecordFieldCompletionItem(BallerinaCompletionContext context, RecordFieldSymbol fieldSymbol, CompletionItem completionItem) {
        super(context, completionItem, LSCompletionItem.CompletionItemType.RECORD_FIELD);
        this.fieldSymbol = fieldSymbol;
        if (!FieldCompletionItemBuilder.hasNilType(fieldSymbol) && fieldSymbol.isOptional()) {
            completionItem.setDetail(NameUtil.getModifiedTypeName((DocumentServiceContext)context, fieldSymbol.typeDescriptor()) + "?");
        } else {
            completionItem.setDetail(NameUtil.getModifiedTypeName((DocumentServiceContext)context, fieldSymbol.typeDescriptor()));
        }
    }

    public RecordFieldCompletionItem(BallerinaCompletionContext context, RecordFieldSymbol fieldSymbol, CompletionItem completionItem, String detail) {
        super(context, completionItem, LSCompletionItem.CompletionItemType.RECORD_FIELD);
        this.fieldSymbol = fieldSymbol;
        completionItem.setDetail(detail);
    }

    public RecordFieldSymbol getFieldSymbol() {
        return this.fieldSymbol;
    }
}

