/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import io.ballerina.compiler.api.symbols.ObjectFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.Collections;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.completions.builder.OptionalFieldAccessWriteAmbiguityResolver;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public final class FieldCompletionItemBuilder {
    private FieldCompletionItemBuilder() {
    }

    private static CompletionItem getCompletionItem(Symbol symbol) {
        String recordFieldName = (String)symbol.getName().orElseThrow();
        CompletionItem completionItem = new CompletionItem();
        completionItem.setLabel(recordFieldName);
        completionItem.setInsertText(CommonUtil.escapeSpecialCharsInInsertText(recordFieldName));
        completionItem.setKind(CompletionItemKind.Field);
        return completionItem;
    }

    public static CompletionItem build(RecordFieldSymbol symbol, BallerinaCompletionContext context) {
        Optional<TextEdit> recordFieldAdditionalTextEdit;
        String recordFieldName = (String)symbol.getName().orElseThrow();
        CompletionItem completionItem = new CompletionItem();
        completionItem.setLabel(recordFieldName);
        completionItem.setKind(CompletionItemKind.Field);
        OptionalFieldAccessWriteAmbiguityResolver resolver = new OptionalFieldAccessWriteAmbiguityResolver(context);
        Boolean readableContext = (Boolean)context.getNodeAtCursor().apply((NodeTransformer)resolver);
        Object insertText = recordFieldName;
        if (readableContext != null && readableContext.booleanValue() && (recordFieldAdditionalTextEdit = FieldCompletionItemBuilder.getRecordFieldAdditionalTextEdit(symbol, context)).isPresent()) {
            insertText = "?." + recordFieldName;
            completionItem.setAdditionalTextEdits(Collections.singletonList(recordFieldAdditionalTextEdit.get()));
        }
        completionItem.setInsertText(CommonUtil.escapeSpecialCharsInInsertText((String)insertText));
        return completionItem;
    }

    public static CompletionItem build(ObjectFieldSymbol objectFieldSymbol, boolean withSelfPrefix) {
        if (withSelfPrefix) {
            String label = String.format("self.%s", objectFieldSymbol.getName().orElse(""));
            String insertText = "self." + CommonUtil.escapeSpecialCharsInInsertText(objectFieldSymbol.getName().orElse(""));
            CompletionItem item = new CompletionItem();
            item.setLabel(label);
            item.setInsertText(insertText);
            item.setKind(CompletionItemKind.Field);
            return item;
        }
        return FieldCompletionItemBuilder.build(objectFieldSymbol);
    }

    private static CompletionItem build(ObjectFieldSymbol symbol) {
        return FieldCompletionItemBuilder.getCompletionItem((Symbol)symbol);
    }

    private static Optional<TextEdit> getRecordFieldAdditionalTextEdit(RecordFieldSymbol recordFieldSymbol, BallerinaCompletionContext context) {
        LineRange dotTokenLineRange;
        if (!recordFieldSymbol.isOptional()) {
            return Optional.empty();
        }
        NonTerminalNode evalNode = context.getNodeAtCursor();
        if (evalNode.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            evalNode = evalNode.parent();
        }
        if (!FieldCompletionItemBuilder.hasNilType(recordFieldSymbol)) {
            return Optional.empty();
        }
        if (evalNode.kind() == SyntaxKind.FIELD_ACCESS) {
            dotTokenLineRange = ((FieldAccessExpressionNode)evalNode).dotToken().lineRange();
        } else if (evalNode.kind() == SyntaxKind.METHOD_CALL) {
            dotTokenLineRange = ((MethodCallExpressionNode)evalNode).dotToken().lineRange();
        } else {
            return Optional.empty();
        }
        LinePosition startLine = dotTokenLineRange.startLine();
        LinePosition endLine = dotTokenLineRange.endLine();
        TextEdit textEdit = new TextEdit();
        Range range = new Range();
        range.setStart(new Position(startLine.line(), startLine.offset()));
        range.setEnd(new Position(endLine.line(), endLine.offset()));
        textEdit.setRange(range);
        textEdit.setNewText("");
        return Optional.of(textEdit);
    }

    public static boolean hasNilType(RecordFieldSymbol recordFieldSymbol) {
        if (recordFieldSymbol.typeDescriptor().typeKind() == TypeDescKind.NIL) {
            return true;
        }
        if (recordFieldSymbol.typeDescriptor().typeKind() != TypeDescKind.UNION) {
            return false;
        }
        UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)recordFieldSymbol.typeDescriptor();
        return unionTypeSymbol.memberTypeDescriptors().stream().anyMatch(member -> member.typeKind() == TypeDescKind.NIL);
    }
}

