/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.api.symbols.resourcepath.util.NamedPathSegment;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.DefaultValueGenerationUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.completions.builder.FunctionCompletionItemBuilder;

public final class ResourcePathCompletionUtil {
    private ResourcePathCompletionUtil() {
    }

    public static boolean isInMethodCallContext(ClientResourceAccessActionNode node, BallerinaCompletionContext context) {
        return node.dotToken().isPresent() && ((Token)node.dotToken().get()).textRange().endOffset() <= context.getCursorPositionInTree();
    }

    public static Optional<ClientResourceAccessActionNode> findClientResourceAccessActionNode(BallerinaCompletionContext context) {
        for (NonTerminalNode evalNode = context.getNodeAtCursor(); evalNode != null; evalNode = evalNode.parent()) {
            if (evalNode.kind() != SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION) continue;
            return Optional.of((ClientResourceAccessActionNode)evalNode);
        }
        return Optional.empty();
    }

    public static List<Pair<String, String>> getResourceAccessInfo(ResourceMethodSymbol resourceMethodSymbol, BallerinaCompletionContext ctx, List<PathSegment> segments) {
        String functionName = resourceMethodSymbol.getName().orElse("");
        String escapedFunctionName = CommonUtil.escapeEscapeCharsInIdentifier(functionName);
        if (functionName.isEmpty()) {
            return List.of(ImmutablePair.of((Object)(escapedFunctionName + "()"), (Object)(functionName + "()")));
        }
        StringBuilder signatureWithNamedSegments = new StringBuilder();
        StringBuilder insertTextWithNamedSegments = new StringBuilder();
        StringBuilder signatureWithComputedResourceSegments = new StringBuilder();
        StringBuilder insertTextWithComputedResourceSegments = new StringBuilder();
        int placeHolderIndex = 1;
        boolean isStringPathParamsAvailable = false;
        for (PathSegment pathSegment : segments) {
            ResourceAccessPathPart resourceAccessPart = ResourcePathCompletionUtil.getResourceAccessPartForSegment(pathSegment, placeHolderIndex, ctx);
            signatureWithComputedResourceSegments.append("/").append(resourceAccessPart.computedPathSignature);
            insertTextWithComputedResourceSegments.append("/").append(resourceAccessPart.computedPathInsertText);
            if (resourceAccessPart.isStringPathParam) {
                isStringPathParamsAvailable = true;
                signatureWithNamedSegments.append("/").append(resourceAccessPart.namedPathSignature);
                insertTextWithNamedSegments.append("/").append(resourceAccessPart.namedPathInsertText);
                ++placeHolderIndex;
                continue;
            }
            signatureWithNamedSegments.append("/").append(resourceAccessPart.computedPathSignature);
            insertTextWithNamedSegments.append("/").append(resourceAccessPart.computedPathInsertText);
            if (pathSegment.pathSegmentKind() == PathSegment.Kind.NAMED_SEGMENT) continue;
            ++placeHolderIndex;
        }
        ArrayList<Pair<String, String>> resourceAccessInfo = new ArrayList<Pair<String, String>>();
        ResourcePathCompletionUtil.addResourceMethodCallSignature(resourceMethodSymbol, ctx, escapedFunctionName, signatureWithComputedResourceSegments, insertTextWithComputedResourceSegments, placeHolderIndex);
        insertTextWithComputedResourceSegments.append(";");
        resourceAccessInfo.add((Pair<String, String>)new ImmutablePair((Object)insertTextWithComputedResourceSegments.toString(), (Object)signatureWithComputedResourceSegments.toString()));
        if (isStringPathParamsAvailable) {
            ResourcePathCompletionUtil.addResourceMethodCallSignature(resourceMethodSymbol, ctx, escapedFunctionName, signatureWithNamedSegments, insertTextWithNamedSegments, placeHolderIndex);
            insertTextWithNamedSegments.append(";");
            resourceAccessInfo.add((Pair<String, String>)new ImmutablePair((Object)insertTextWithNamedSegments.toString(), (Object)signatureWithNamedSegments.toString()));
        }
        return resourceAccessInfo;
    }

    public static void addResourceMethodCallSignature(ResourceMethodSymbol resourceMethodSymbol, BallerinaCompletionContext ctx, String escapedFunctionName, StringBuilder signature, StringBuilder insertText, int placeHolderIndex) {
        List<String> funcArguments;
        if (resourceMethodSymbol.resourcePath().kind() == ResourcePath.Kind.DOT_RESOURCE_PATH) {
            signature.append("/");
            insertText.append("/");
        }
        if (!escapedFunctionName.equals("get")) {
            signature.append(".").append(escapedFunctionName);
            insertText.append(".").append(escapedFunctionName);
        }
        if (!(funcArguments = CommonUtil.getFuncArguments((FunctionSymbol)resourceMethodSymbol, ctx)).isEmpty()) {
            signature.append("(").append(String.join((CharSequence)", ", funcArguments)).append(")");
            insertText.append("(${").append(placeHolderIndex).append("})");
        }
    }

    public static String getFilterTextForClientResourceAccessAction(ResourceMethodSymbol resourceMethodSymbol, List<PathSegment> segments) {
        ResourcePath resourcePath = resourceMethodSymbol.resourcePath();
        if (resourcePath.kind() == ResourcePath.Kind.DOT_RESOURCE_PATH || resourcePath.kind() == ResourcePath.Kind.PATH_REST_PARAM) {
            return resourceMethodSymbol.getName().orElse("");
        }
        return segments.stream().filter(pathSegment -> pathSegment.pathSegmentKind() == PathSegment.Kind.NAMED_SEGMENT).map(pathSegment -> ((NamedPathSegment)pathSegment).name()).collect(Collectors.joining("|")) + "|" + resourceMethodSymbol.getName().orElse("");
    }

    public static boolean checkSubtype(TypeSymbol paramType, TypeSymbol exprType, String exprValue) {
        if (exprType.subtypeOf(paramType)) {
            return true;
        }
        return switch (paramType.typeKind()) {
            case TypeDescKind.UNION -> {
                for (TypeSymbol childSymbol : ((UnionTypeSymbol)paramType).memberTypeDescriptors()) {
                    if (!ResourcePathCompletionUtil.checkSubtype(childSymbol, exprType, exprValue)) continue;
                    yield true;
                }
                yield false;
            }
            case TypeDescKind.SINGLETON -> {
                if (paramType.subtypeOf(exprType) && exprValue.equals(paramType.signature())) {
                    yield true;
                }
                yield false;
            }
            case TypeDescKind.TYPE_REFERENCE -> paramType.subtypeOf(exprType);
            default -> false;
        };
    }

    private static ResourceAccessPathPart getResourceAccessPartForSegment(PathSegment segment, int placeHolderIndex, BallerinaCompletionContext context) {
        if (segment.pathSegmentKind() == PathSegment.Kind.NAMED_SEGMENT) {
            String name = ((NamedPathSegment)segment).name();
            return new ResourceAccessPathPart(name, name);
        }
        PathParameterSymbol pathParameterSymbol = (PathParameterSymbol)segment;
        TypeSymbol typeSymbol = pathParameterSymbol.typeDescriptor();
        if (segment.pathSegmentKind() == PathSegment.Kind.PATH_REST_PARAMETER && pathParameterSymbol.typeDescriptor().typeKind() == TypeDescKind.ARRAY) {
            typeSymbol = ((ArrayTypeSymbol)pathParameterSymbol.typeDescriptor()).memberTypeDescriptor();
        }
        Optional<String> defaultValue = DefaultValueGenerationUtil.getDefaultValueForType(typeSymbol);
        String paramType = FunctionCompletionItemBuilder.getFunctionParameterSyntax(pathParameterSymbol, context).orElse("");
        String computedSignature = "[" + paramType + "]";
        String computedInsertText = typeSymbol.typeKind().equals((Object)TypeDescKind.SINGLETON) ? "[" + defaultValue.orElse("") + "]" : "[${" + placeHolderIndex + ":" + defaultValue.orElse("") + "}]";
        ResourceAccessPathPart resourceAccessPathPart = new ResourceAccessPathPart(computedInsertText, computedSignature);
        if (context.currentSemanticModel().isPresent() && ResourcePathCompletionUtil.isStringSubtype(typeSymbol, ((SemanticModel)context.currentSemanticModel().get()).types().STRING)) {
            if (typeSymbol.typeKind().equals((Object)TypeDescKind.SINGLETON)) {
                resourceAccessPathPart.namedPathInsertText = resourceAccessPathPart.namedPathSignature = typeSymbol.signature().substring(1, typeSymbol.signature().length() - 1);
            } else {
                resourceAccessPathPart.namedPathSignature = "<" + (pathParameterSymbol.getName().isPresent() ? (String)pathParameterSymbol.getName().get() : "path") + ">";
                resourceAccessPathPart.namedPathInsertText = "${" + placeHolderIndex + ":path}";
                resourceAccessPathPart.computedPathInsertText = "[${" + placeHolderIndex + ":\"path\"}]";
            }
            resourceAccessPathPart.isStringPathParam = true;
        }
        return resourceAccessPathPart;
    }

    private static boolean isStringSubtype(TypeSymbol paramType, TypeSymbol stringType) {
        if (stringType.subtypeOf(paramType)) {
            return true;
        }
        return switch (paramType.typeKind()) {
            case TypeDescKind.UNION -> {
                for (TypeSymbol childSymbol : ((UnionTypeSymbol)paramType).memberTypeDescriptors()) {
                    if (!ResourcePathCompletionUtil.isStringSubtype(childSymbol, stringType)) continue;
                    yield true;
                }
                yield false;
            }
            case TypeDescKind.SINGLETON, TypeDescKind.TYPE_REFERENCE -> paramType.subtypeOf(stringType);
            default -> false;
        };
    }

    private static class ResourceAccessPathPart {
        private String computedPathInsertText;
        private final String computedPathSignature;
        private String namedPathSignature;
        private String namedPathInsertText;
        boolean isStringPathParam = false;

        ResourceAccessPathPart(String computedPathInsertText, String computedPathSignature) {
            this.computedPathInsertText = computedPathInsertText;
            this.computedPathSignature = computedPathSignature;
        }
    }
}

