/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import java.util.List;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;

public final class SpreadCompletionItemBuilder {
    public static final String SPREAD_OPERATOR = "...";

    private SpreadCompletionItemBuilder() {
    }

    public static CompletionItem build(Symbol symbol, String typeName, BallerinaCompletionContext context) {
        if (symbol.kind() == SymbolKind.FUNCTION) {
            return SpreadCompletionItemBuilder.build((FunctionSymbol)symbol, typeName, context);
        }
        String symbolName = (String)symbol.getName().orElseThrow();
        String insertText = SPREAD_OPERATOR + symbolName;
        return SpreadCompletionItemBuilder.build(insertText, insertText, CompletionItemKind.Variable, symbolName, typeName);
    }

    private static CompletionItem build(FunctionSymbol symbol, String typeName, BallerinaCompletionContext context) {
        String symbolName = (String)symbol.getName().orElseThrow();
        List<String> funcArguments = CommonUtil.getFuncArguments(symbol, context);
        String insertText = SPREAD_OPERATOR + symbolName + (funcArguments.isEmpty() ? "()" : "(${1})");
        String label = SPREAD_OPERATOR + symbolName + "(" + String.join((CharSequence)", ", funcArguments) + ")";
        return SpreadCompletionItemBuilder.build(insertText, label, CompletionItemKind.Function, symbolName, typeName);
    }

    private static CompletionItem build(String insertText, String label, CompletionItemKind kind, String symbolName, String typeName) {
        CompletionItem completionItem = new CompletionItem();
        completionItem.setLabel(label);
        completionItem.setKind(kind);
        completionItem.setDetail(typeName);
        completionItem.setFilterText(symbolName);
        completionItem.setInsertText(insertText);
        return completionItem;
    }
}

