/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;

public final class VariableCompletionItemBuilder {
    private VariableCompletionItemBuilder() {
    }

    public static CompletionItem build(VariableSymbol varSymbol, String label, String type) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        String insertText = CommonUtil.escapeSpecialCharsInInsertText(label);
        item.setInsertText(insertText);
        item.setDetail(type.isEmpty() ? "none" : type);
        VariableCompletionItemBuilder.setMeta(item, varSymbol);
        return item;
    }

    private static void setMeta(CompletionItem item, VariableSymbol varSymbol) {
        item.setKind(CompletionItemKind.Variable);
        if (varSymbol == null) {
            return;
        }
        if (varSymbol.documentation().isPresent() && ((Documentation)varSymbol.documentation().get()).description().isPresent()) {
            item.setDocumentation((String)((Documentation)varSymbol.documentation().get()).description().get());
        }
    }
}

