/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.Node;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.FieldAccessContext;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public abstract class AbstractFieldAccessExpressionNodeContext<T extends Node>
extends FieldAccessContext<T> {
    public AbstractFieldAccessExpressionNodeContext(Class<T> attachmentPoint) {
        super(attachmentPoint);
    }

    @Override
    public void sort(BallerinaCompletionContext context, T node, List<LSCompletionItem> completionItems) {
        for (LSCompletionItem completionItem : completionItems) {
            this.sortByAssignability(context, completionItem, switch (completionItem.getType()) {
                case LSCompletionItem.CompletionItemType.OBJECT_FIELD, LSCompletionItem.CompletionItemType.RECORD_FIELD -> 1;
                case LSCompletionItem.CompletionItemType.SYMBOL -> {
                    Optional<Symbol> symbol = ((SymbolCompletionItem)completionItem).getSymbol();
                    if (symbol.stream().anyMatch(sym -> sym.kind() == SymbolKind.XMLNS)) {
                        yield 2;
                    }
                    if (symbol.stream().anyMatch(sym -> sym.kind() == SymbolKind.METHOD)) {
                        yield 3;
                    }
                    if (symbol.stream().anyMatch(sym -> sym.kind() == SymbolKind.FUNCTION)) {
                        yield 4;
                    }
                    yield SortingUtil.toRank(context, completionItem, 4);
                }
                default -> SortingUtil.toRank(context, completionItem, 4);
            });
        }
    }
}

